/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.types.ExactNumericType;
import com.cognos.xqe.data.types.TypeInvalidArgumentException;
import com.cognos.xqe.data.types.TypeRuntimeException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;

public class DecimalType
extends ExactNumericType {
    static final long serialVersionUID = -1292624492665318144L;
    private static final int THIRTY_ONE = 31;
    public static final String TYPE_NAME = "decimal";
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 256;
    public static final int MAX_CACHED_PRECISION = 256;
    public static final int MAX_SPECIALIZED_PRECISION = 18;
    public static final int MIN_SCALE = -256;
    public static final int MAX_SCALE = 128;
    public static final int DEFAULT_PRECISION = 256;
    public static final int DEFAULT_SCALE = 2;
    public static final DecimalType DEFAULT_DECIMALTYPE = new DecimalType();

    DecimalType() {
        this(256, 2);
    }

    DecimalType(int iPrecision) {
        this(iPrecision, 2);
    }

    public DecimalType(int iPrecision, int iScale) throws TypeRuntimeException {
        super((byte)12, iPrecision, iScale);
        boolean isUnlimitedUpperBoundry;
        boolean bl = isUnlimitedUpperBoundry = iPrecision == Integer.MAX_VALUE;
        if (iPrecision < 0 || iPrecision > 256 && !isUnlimitedUpperBoundry || iScale < -256 || iScale > iPrecision) {
            throw new TypeInvalidArgumentException(XQEMessageKeys.DAT_DecimalTypeInvalid, Integer.toString(iPrecision), Integer.toString(iScale));
        }
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createDecimalValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return DecimalValue.getEncodedSize();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getSQLText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSQLTypeName());
        buffer.append(String.format("(%1$d,%2$d)", this.precision, this.scale));
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "decimal(" + this.precision + "," + this.scale + ")";
    }

    @Override
    public int sizeOf() {
        return (this.precision - 1) / 2 + 1 + 1;
    }

    @Override
    public int getLength() {
        return (this.precision - 1) / 2 + 1 + 1;
    }

    @Override
    public int getCCLLength() {
        return this.precision / 2 + 1;
    }

    @Override
    public String toModelType() {
        return TYPE_NAME;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DecimalType) {
            DecimalType other = (DecimalType)obj;
            return this.getScale() == other.getScale() && this.getPrecision() == other.getPrecision();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getScale() * 31 + this.getPrecision();
    }

    @Override
    public int getJDBCType() {
        return 3;
    }
}

