/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.types.TypeInvalidArgumentException;
import com.cognos.xqe.exception.XQEMessageKeys;

public abstract class ExternalBufferType
extends TextType {
    static final long serialVersionUID = -5117305801160082662L;
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    public static final String TYPE_NAME = "externalBuffer";

    protected ExternalBufferType(byte dType) {
        super(dType);
    }

    protected ExternalBufferType() {
        super((byte)45);
    }

    public ExternalBufferType(int maxStrLength) {
        this(45, maxStrLength);
    }

    protected ExternalBufferType(byte dType, int maxStrLength) throws TypeInvalidArgumentException {
        super(dType);
        if (maxStrLength < -1) {
            throw new TypeInvalidArgumentException(XQEMessageKeys.DAT_InvalidStringLength, Integer.toString(maxStrLength), TYPE_NAME);
        }
        this.maximumLength = maxStrLength;
    }

    @Override
    public String getSQLText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSQLTypeName());
        if (this.maximumLength > 0) {
            buffer.append(String.format("(%1$d)", this.maximumLength));
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        String value = this.getTypeName();
        if (this.maximumLength >= 0) {
            value = value + LPAREN + this.maximumLength + RPAREN;
        }
        return value;
    }
}

