/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

public enum IntervalQualifier {
    INTERVAL_UNKNOWN("unknown", -1),
    INTERVAL_YEAR_TO_MONTH("year to month", 0),
    INTERVAL_YEAR("year", 1),
    INTERVAL_MONTH("month", 2),
    INTERVAL_DAY_TO_HOUR("day to hour", 3),
    INTERVAL_DAY_TO_MINUTE("day to minute", 4),
    INTERVAL_DAY_TO_SECOND("day to second", 5),
    INTERVAL_HOUR_TO_MINUTE("hour to minute", 6),
    INTERVAL_HOUR_TO_SECOND("hour to second", 7),
    INTERVAL_MINUTE_TO_SECOND("minute to second", 8),
    INTERVAL_DAY("day", 9),
    INTERVAL_HOUR("hour", 10),
    INTERVAL_MINUTE("minute", 11),
    INTERVAL_SECOND("second", 12);

    private static final String TO = "to";
    private String descriptor;
    private byte ordinal;
    private static IntervalQualifier[] map;

    private IntervalQualifier(String theDescriptor, int index) {
        this.descriptor = theDescriptor;
        this.ordinal = (byte)index;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public byte getOrdinal() {
        return this.ordinal;
    }

    public String getStartField() {
        String[] parts = this.descriptor.split(TO);
        return parts[0].trim();
    }

    public String getEndField() {
        String[] parts = this.descriptor.split(TO);
        if (parts.length > 1) {
            return parts[1].trim();
        }
        return null;
    }

    public static IntervalQualifier get(int index) {
        if (index >= 0) {
            return map[index];
        }
        return INTERVAL_UNKNOWN;
    }

    public static IntervalQualifier get(String s) {
        for (int i = 0; i < map.length; ++i) {
            if (IntervalQualifier.map[i].descriptor.compareToIgnoreCase(s) != 0) continue;
            return map[i];
        }
        return INTERVAL_UNKNOWN;
    }

    public static IntervalQualifier getQualifierFromValue(String v) {
        v = v.toLowerCase();
        for (int i = 0; i < map.length; ++i) {
            if (!v.contains(IntervalQualifier.map[i].descriptor)) continue;
            return map[i];
        }
        return INTERVAL_UNKNOWN;
    }

    static {
        map = new IntervalQualifier[]{INTERVAL_YEAR_TO_MONTH, INTERVAL_YEAR, INTERVAL_MONTH, INTERVAL_DAY_TO_HOUR, INTERVAL_DAY_TO_MINUTE, INTERVAL_DAY_TO_SECOND, INTERVAL_HOUR_TO_MINUTE, INTERVAL_HOUR_TO_SECOND, INTERVAL_MINUTE_TO_SECOND, INTERVAL_DAY, INTERVAL_HOUR, INTERVAL_MINUTE, INTERVAL_SECOND};
    }
}

