/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.IntervalQualifier;

public abstract class IntervalType
extends DataType {
    static final long serialVersionUID = 2956124479365978808L;
    protected static final String TYPE_NAME_PREFIX = "interval";
    protected IntervalQualifier qualifier = IntervalQualifier.INTERVAL_UNKNOWN;
    protected int leadingPrecision = -1;
    public static final int DEFAULT_LEADING_PRECISION = 9;
    public static final int MINIMUM_NON_FRACTIONAL_PRECISION = 1;
    public static final int UNKNOWN_PRECISION = -1;
    public static final int PRECISION_YEAR = 32;
    public static final int PRECISION_MONTH = 16;
    public static final int PRECISION_DAY = 8;
    public static final int PRECISION_HOUR = 4;
    public static final int PRECISION_MINUTE = 2;
    public static final int PRECISION_SECOND = 1;

    protected IntervalType(byte dType, DataSubType subType) {
        super(dType, subType);
    }

    @Override
    public String getTypeName() {
        return "interval " + this.qualifier.getDescriptor();
    }

    public void setQualifier(IntervalQualifier theQualifier) {
        this.qualifier = theQualifier;
    }

    public IntervalQualifier getQualifier() {
        return this.qualifier;
    }

    public static IntervalQualifier getQualifier(int precision) {
        IntervalQualifier q = IntervalQualifier.INTERVAL_UNKNOWN;
        switch (precision) {
            case 32: {
                q = IntervalQualifier.INTERVAL_YEAR;
                break;
            }
            case 16: {
                q = IntervalQualifier.INTERVAL_MONTH;
                break;
            }
            case 8: {
                q = IntervalQualifier.INTERVAL_DAY;
                break;
            }
            case 4: {
                q = IntervalQualifier.INTERVAL_HOUR;
                break;
            }
            case 2: {
                q = IntervalQualifier.INTERVAL_MINUTE;
                break;
            }
            case 1: {
                q = IntervalQualifier.INTERVAL_SECOND;
                break;
            }
            case 48: {
                q = IntervalQualifier.INTERVAL_YEAR_TO_MONTH;
                break;
            }
            case 12: {
                q = IntervalQualifier.INTERVAL_DAY_TO_HOUR;
                break;
            }
            case 14: {
                q = IntervalQualifier.INTERVAL_DAY_TO_MINUTE;
                break;
            }
            case 15: {
                q = IntervalQualifier.INTERVAL_DAY_TO_SECOND;
                break;
            }
            case 6: {
                q = IntervalQualifier.INTERVAL_HOUR_TO_MINUTE;
                break;
            }
            case 7: {
                q = IntervalQualifier.INTERVAL_HOUR_TO_SECOND;
                break;
            }
            case 3: {
                q = IntervalQualifier.INTERVAL_MINUTE_TO_SECOND;
                break;
            }
        }
        return q;
    }

    public void setLeadingPrecision(int precision) {
        this.leadingPrecision = precision;
    }

    public int getLeadingPrecision() {
        return this.leadingPrecision;
    }

    @Override
    public String toString() {
        return "interval " + this.qualifier.getDescriptor();
    }

    @Override
    public int getPrecision() {
        int precision = 0;
        switch (this.qualifier) {
            case INTERVAL_YEAR: {
                precision = 32;
                break;
            }
            case INTERVAL_MONTH: {
                precision = 16;
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                precision = 48;
                break;
            }
            case INTERVAL_DAY: {
                precision = 8;
                break;
            }
            case INTERVAL_HOUR: {
                precision = 4;
                break;
            }
            case INTERVAL_MINUTE: {
                precision = 2;
                break;
            }
            case INTERVAL_SECOND: {
                precision = 1;
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                precision = 12;
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                precision = 6;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                precision = 14;
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                precision = 15;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                precision = 7;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                precision = 3;
                break;
            }
        }
        return precision;
    }

    @Override
    public boolean hasPrecision() {
        return true;
    }

    public boolean hasLeadingPrecision() {
        return this.leadingPrecision != -1;
    }

    public boolean hasFractionalPrecision() {
        return false;
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        if (!(obj instanceof IntervalType)) {
            return false;
        }
        return this.getQualifier().equals((Object)((IntervalType)obj).getQualifier());
    }
}

