/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;

public class IntervalYearMonthType
extends IntervalType {
    static final long serialVersionUID = -4626683555857289270L;
    public static final String TYPE_NAME = "interval year to month";
    private static final int CCLDTYPEYMINTERVAL_SIZE = 12;
    public static final IntervalYearMonthType DEFAULT_INTERVALYEARMONTHTYPE = IntervalYearMonthType.loadDefaultTypeValue();

    private static IntervalYearMonthType loadDefaultTypeValue() {
        return new IntervalYearMonthType();
    }

    IntervalYearMonthType() {
        this(IntervalQualifier.INTERVAL_YEAR_TO_MONTH, -1);
    }

    IntervalYearMonthType(IntervalQualifier pQualifier) {
        this(pQualifier, -1);
    }

    IntervalYearMonthType(IntervalQualifier pQualifier, int leadPrecision) {
        super((byte)17, DataSubType.INTERVALYMTYPE);
        this.qualifier = pQualifier;
        this.leadingPrecision = leadPrecision;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createIntervalYearMonthValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return IntervalYearMonthValue.getEncodedSize();
    }

    @Override
    public int sizeOf() {
        int size = 5;
        if (this.qualifier == IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
            ++size;
        }
        return size;
    }

    @Override
    public int getLength() {
        int size = 5;
        if (this.qualifier == IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
            ++size;
        }
        return size;
    }

    @Override
    public int getCCLLength() {
        return 12;
    }

    @Override
    public String getSQLText() {
        String typeName = this.getTypeName();
        if (this.hasLeadingPrecision()) {
            typeName = "interval " + this.qualifier.getStartField() + "(" + this.leadingPrecision + ")";
            if (this.qualifier.getEndField() != null) {
                typeName = typeName + " TO " + this.qualifier.getEndField();
            }
        }
        return typeName.toUpperCase();
    }
}

