/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.values.IValue;

public class TextType
extends DataType {
    static final long serialVersionUID = -36016280971084028L;
    public static final String TYPE_NAME = "string";
    private static final int BYTES_PER_STRING = 3;
    private static final int BYTES_PER_LENGTH = 2;
    public static final int DEFAULT_MAXIMUM_STRING_LENGTH = -1;
    static final TextType TEXTTYPE = new TextType(22);
    protected int maximumLength = -1;

    protected TextType(byte dType) {
        super(dType, DataSubType.TEXTTYPE);
    }

    @Override
    public int getLength() {
        if (this.maximumLength == -1) {
            return -1;
        }
        return (this.maximumLength + 1) * 2;
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        if (!(obj instanceof TextType)) {
            return false;
        }
        TextType st = (TextType)obj;
        return this.equals(st) && this.maximumLength == st.maximumLength;
    }

    public boolean lessThanOrEquivalent(Object obj) {
        if (!(obj instanceof TextType)) {
            return false;
        }
        TextType st = (TextType)obj;
        return this.equals(st) && this.maximumLength >= st.maximumLength;
    }

    public boolean hasMaximumLength() {
        return this.maximumLength == -1;
    }

    @Override
    public int sizeOf() {
        return this.getLength() * 3 + 2;
    }

    @Override
    public boolean hasPrecision() {
        return true;
    }

    @Override
    public int getPrecision() {
        return this.maximumLength;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public IValue createValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEncodedValueSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTextType() {
        return true;
    }
}

