/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.dom4j.Element;

public class BigDecimalValue
extends DecimalValue {
    static final long serialVersionUID = 8966504082800168934L;
    protected BigDecimal value;
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final String ONE = "1";
    private static final BigDecimal VALUE10 = new BigDecimal("10");
    private static final BigDecimal VALUE1 = new BigDecimal("1");
    private static final BigDecimal DEC2SHORT_UPPERBOUND = new BigDecimal(32768.0);
    private static final BigDecimal DEC2SHORT_LOWERBOUND = new BigDecimal(-32769.0);
    private static final BigDecimal DEC2FLT_UPPERBOUND = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal DEC2FLT_LOWERBOUND = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal[] CACHEDUPPERPRECISION = BigDecimalValue.initCachedDecimalMaxes(1);
    private static final BigDecimal[] CACHEDLOWERPRECISION = BigDecimalValue.initCachedDecimalMaxes(-1);
    private int decMaxIndex;

    private static BigDecimal[] initCachedDecimalMaxes(int sign) {
        BigDecimal[] b = new BigDecimal[257];
        for (int i = 0; i <= 256; ++i) {
            b[i] = BigDecimalValue.createLargestUnscaledBigDecimal(i, sign);
        }
        return b;
    }

    private static BigDecimal createLargestUnscaledBigDecimal(int precision, int sign) {
        StringBuilder buf = new StringBuilder();
        if (precision == 0) {
            return new BigDecimal(Integer.toString(sign));
        }
        if (sign == 1) {
            buf.append(ONE);
        } else {
            buf.append("-1");
        }
        for (int i = 0; i < precision; ++i) {
            buf.append("0").toString();
        }
        return new BigDecimal(buf.toString());
    }

    public static boolean notWithinRange(int cacheIndex, BigDecimal aValue) {
        if (cacheIndex <= 256) {
            return aValue.compareTo(CACHEDUPPERPRECISION[cacheIndex]) != -1 || aValue.compareTo(CACHEDLOWERPRECISION[cacheIndex]) != 1;
        }
        BigDecimal absValue = aValue.abs();
        BigDecimal tmp = null;
        boolean notWithinRange = true;
        for (int i = 0; i < cacheIndex; ++i) {
            tmp = absValue.divide(VALUE10, 1);
            if ((absValue = tmp).compareTo(VALUE1) != -1) continue;
            notWithinRange = false;
            break;
        }
        return notWithinRange;
    }

    public static BigDecimal getScaledValue(BigDecimal b, int scale, int roundMode) {
        return b.setScale(scale, roundMode);
    }

    protected BigDecimalValue(DecimalType aDataType) {
        super(aDataType);
        this.decMaxIndex = aDataType.getPrecision() - aDataType.getScale();
    }

    @Override
    public void set(IValue v) throws ValueConversionException {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null && theValue.isOK()) {
            BigDecimal b = theValue.getBigDecimal(this.getPrecision(), this.getScale());
            this.set(b);
            this.copyStateFrom(theValue);
        }
    }

    @Override
    public void set(String aValue) throws ValueConversionException {
        BigDecimal b;
        if (aValue == null || aValue.compareTo("") == 0 || aValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.setParseBigDecimal(true);
        aValue = aValue.trim();
        if (aValue.charAt(0) == '+') {
            aValue = aValue.substring(1);
        }
        try {
            b = (BigDecimal)df.parse(aValue);
        }
        catch (Exception e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", aValue, "decimal");
        }
        b = BigDecimalValue.getScaledValue(b, this.getScale(), 1);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue, Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(short aValue) {
        BigDecimal b = new BigDecimal(Short.toString(aValue));
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Short.toString(aValue), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(int aValue) {
        BigDecimal b = new BigDecimal(Integer.toString(aValue));
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Integer.toString(aValue), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(long aValue) {
        BigDecimal b = new BigDecimal(Long.toString(aValue));
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Long.toString(aValue), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal aValue) {
        if (aValue == null) {
            this.setNull();
            return;
        }
        if (this.dataType.getPrecision() == Integer.MAX_VALUE) {
            this.value = aValue;
            this.setNotNull();
            return;
        }
        BigDecimal b = this.cast(aValue);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(float aValue) {
        BigDecimal b = new BigDecimal(aValue);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Float.toString(aValue), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(double aValue) {
        if (aValue == Double.POSITIVE_INFINITY || aValue == Double.NEGATIVE_INFINITY || Double.isNaN(aValue)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(aValue), "decimal");
        }
        BigDecimal b = BigDecimal.valueOf(aValue);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 5)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 5))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Double.toString(aValue), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.getBigDecimal(this.getPrecision(), this.getScale());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return this.value.toPlainString();
    }

    @Override
    public short getShort(int precision, int scale) throws ValueConversionException {
        if (this.value.compareTo(DEC2SHORT_UPPERBOUND) != -1 || this.value.compareTo(DEC2SHORT_LOWERBOUND) != 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", this.value.toString(), "smallint");
        }
        BigDecimal bd = BigDecimalValue.cast(this.value, precision, scale, RoundingMode.DOWN);
        return bd.unscaledValue().shortValue();
    }

    @Override
    public int getInteger(int precision, int scale) throws ValueConversionException {
        if (this.value.compareTo(DEC2INT_UPPERBOUND) != -1 || this.value.compareTo(DEC2INT_LOWERBOUND) != 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", this.value.toString(), "integer");
        }
        BigDecimal bd = BigDecimalValue.cast(this.value, precision, scale, RoundingMode.DOWN);
        return bd.unscaledValue().intValue();
    }

    @Override
    public long getLong(int precision, int scale) throws ValueConversionException {
        if (this.value.compareTo(DEC2LONG_UPPERBOUND) != -1 || this.value.compareTo(DEC2LONG_LOWERBOUND) != 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", this.value.toString(), "long");
        }
        BigDecimal bd = BigDecimalValue.cast(this.value, precision, scale, RoundingMode.DOWN);
        return bd.unscaledValue().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        return BigDecimalValue.cast(this.value, precision, scale);
    }

    @Override
    public float getFloat() throws ValueConversionException {
        if (this.value.compareTo(DEC2FLT_UPPERBOUND) != -1 || this.value.compareTo(DEC2FLT_LOWERBOUND) != 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", this.value.toString(), "float");
        }
        return this.value.floatValue();
    }

    @Override
    public double getDouble() {
        return this.value.doubleValue();
    }

    @Override
    public Object copy() {
        BigDecimalValue v = new BigDecimalValue((DecimalType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue aValue) throws ValueConversionException {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        BigDecimal b = this.value.add(a);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
    }

    @Override
    public void subtract(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        BigDecimal b = this.value.subtract(a);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
    }

    @Override
    public void multiply(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        BigDecimal b = this.value.multiply(a);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
    }

    @Override
    public void divide(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        if (a.compareTo(ZERO) == 0) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DivisionByZero);
        }
        BigDecimal b = this.value.divide(a, this.getScale(), 1);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
    }

    @Override
    public void mod(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        double dValue = ((Value)aValue).getDouble();
        if (dValue == 0.0) {
            return;
        }
        double d = this.value.doubleValue() % dValue;
        BigDecimal b = new BigDecimal(d);
        if (BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, this.getScale(), 1)) && BigDecimalValue.notWithinRange(this.decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, aValue.toString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = this.value.abs();
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            return this.value.signum();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value.doubleValue());
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsNull && thatIsNull) {
            return 0;
        }
        BigDecimal zeroValue = new BigDecimal(0.0);
        if (NullBehavior.ZERO_FIRST == nullHandling) {
            if (thisIsNull) {
                int compareValue = zeroValue.compareTo(pValue.getBigDecimal(this.dataType.getPrecision(), this.dataType.getScale()));
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = this.value.compareTo(zeroValue);
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO_LAST == nullHandling) {
            if (thisIsNull) {
                int compareValue = zeroValue.compareTo(pValue.getBigDecimal(this.dataType.getPrecision(), this.dataType.getScale()));
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = this.value.compareTo(zeroValue);
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
            if (thisIsNull) {
                return zeroValue.compareTo(pValue.getBigDecimal(this.dataType.getPrecision(), this.dataType.getScale()));
            }
            if (thatIsNull) {
                return this.value.compareTo(zeroValue);
            }
        } else if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return 1;
            }
            if (thisIsNull) {
                return -1;
            }
        } else if (NullBehavior.NULL_LAST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return -1;
            }
            if (thisIsNull) {
                return 1;
            }
        }
        return this.value.compareTo(pValue.getBigDecimal());
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        DecimalValue a = (DecimalValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        BigDecimal b = a.getBigDecimal();
        if (this.value.compareTo(b) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void floor() {
        if (!this.isOK()) {
            return;
        }
        int scale = this.value.scale();
        BigDecimal tmp = this.value.setScale(0, 3);
        this.value = tmp.setScale(scale);
    }

    @Override
    public void ceil() {
        if (!this.isOK()) {
            return;
        }
        int scale = this.value.scale();
        BigDecimal tmp = this.value.setScale(0, 2);
        this.value = tmp.setScale(scale);
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        BigDecimal tmp = this.value;
        int scale = tmp.scale();
        if (n != 0) {
            tmp = tmp.movePointRight(n);
        }
        tmp = tmp.setScale(0, 1);
        if (n != 0) {
            tmp = tmp.movePointLeft(n);
        }
        this.value = tmp.setScale(scale);
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        BigDecimal tmp = this.value;
        int scale = tmp.scale();
        if (n != 0) {
            tmp = tmp.movePointRight(n);
        }
        tmp = tmp.setScale(0, 4);
        if (n != 0) {
            tmp = tmp.movePointLeft(n);
        }
        this.value = tmp.setScale(scale);
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        BigDecimal tmp = this.value;
        tmp = tmp.abs();
        int sign = this.value.signum();
        int scale = tmp.scale();
        if (n != 0) {
            tmp = tmp.movePointRight(n);
        }
        tmp = tmp.setScale(0, 2);
        if (n != 0) {
            tmp = tmp.movePointLeft(n);
        }
        if (sign == -1) {
            tmp = tmp.negate();
        }
        this.value = tmp.setScale(scale);
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        BigDecimal tmp = this.value;
        tmp = tmp.abs();
        int sign = this.value.signum();
        int scale = tmp.scale();
        if (n != 0) {
            tmp = tmp.movePointRight(n);
        }
        tmp = tmp.setScale(0, 3);
        if (n != 0) {
            tmp = tmp.movePointLeft(n);
        }
        if (sign == -1) {
            tmp = tmp.negate();
        }
        this.value = tmp.setScale(scale);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            byte scale = iStream.readByte();
            byte len = iStream.readByte();
            byte[] bytes = new byte[len];
            iStream.readFully(bytes);
            this.value = new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            byte[] bytes = this.value.unscaledValue().toByteArray();
            oStream.writeByte(this.value.scale());
            oStream.writeByte(bytes.length);
            oStream.write(bytes);
        }
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public String getUnscaledString() {
        return this.value.unscaledValue().toString();
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOfBigDecimalValue(this);
    }

    @Override
    public boolean isZero() {
        if (!this.isOK() || this.value == null) {
            return false;
        }
        return this.value.compareTo(ZERO) == 0;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == null ? ((BigDecimalValue)otherValue).value == null : this.value.equals(((BigDecimalValue)otherValue).value);
        }
        return result;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(this.value.toString());
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = new BigDecimal(text);
        }
    }
}

