/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.BinaryType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VarBinaryType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IAppendable;
import com.cognos.xqe.data.values.IPosition;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQELogger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.dom4j.Element;

public class BinaryValue
extends Value
implements IAppendable,
IPosition {
    static final long serialVersionUID = 1L;
    private static final int C_4 = 4;
    private byte[] value;

    BinaryValue(BinaryType aDataType) {
        super(aDataType);
    }

    BinaryValue(VarBinaryType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(Object object) throws XQERuntimeException {
        if (object == null) {
            this.setNull();
            return;
        }
        if (object instanceof byte[]) {
            this.set((byte[])object);
        } else if (object instanceof ByteBuffer) {
            this.set((ByteBuffer)object);
        }
    }

    @Override
    public void set(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            this.setNull();
            return;
        }
        String bStr = sValue;
        if (bStr.length() % 2 != 0) {
            bStr = "0" + sValue;
        }
        this.value = new byte[bStr.length() / 2];
        int j = 0;
        for (int i = 0; i < this.value.length; ++i) {
            int b = Character.digit(bStr.charAt(j++), 16) << 4;
            this.value[i] = (byte)(b |= Character.digit(bStr.charAt(j++), 16));
        }
        this.setNotNull();
    }

    @Override
    public void set(byte[] bValue) {
        if (bValue == null) {
            this.setNull();
            return;
        }
        this.value = bValue;
        this.setNotNull();
    }

    @Override
    public void set(ByteBuffer bValue) {
        if (bValue == null) {
            this.setNull();
            return;
        }
        if (null == this.value || this.value.length != bValue.remaining()) {
            this.value = new byte[bValue.remaining()];
        }
        bValue.get(this.value);
        this.setNotNull();
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        this.set(((Value)v).getByteArray());
    }

    @Override
    public Object copy() {
        BinaryValue v = new BinaryValue((BinaryType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        Value pValue = (Value)iValue;
        this.setState(pValue.getState());
        if (!pValue.isNull()) {
            byte[] v = pValue.getByteArray();
            this.value = new byte[v.length];
            System.arraycopy(v, 0, this.value, 0, v.length);
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return this.convertByteArrayToString(this.value, this.value.length);
    }

    @Override
    public byte[] getByteArray() {
        return this.value;
    }

    public byte[] getObject() {
        return this.getByteArray();
    }

    @Override
    public String getSQLLiteral() {
        return this.getFormattedLiteral("X'%s'");
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        return String.format(formatSpec, this.getString());
    }

    @Override
    public void append(IValue pValue) throws XQERuntimeException {
        this.append(((Value)pValue).getByteArray());
    }

    public void append(byte[] pValue) throws XQERuntimeException {
        byte[] bytes = new byte[this.value.length + pValue.length];
        System.arraycopy(this.value, 0, bytes, 0, this.value.length);
        System.arraycopy(pValue, 0, bytes, this.value.length, pValue.length);
        this.value = bytes;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        Value b = (Value)pObject;
        if (this.isNull() && b.isNull()) {
            return 0;
        }
        if (!this.isNull() && b.isNull()) {
            return 1;
        }
        if (this.isNull() && !b.isNull()) {
            return -1;
        }
        byte[] arr1 = this.value;
        byte[] arr2 = b.getByteArray();
        int length = Math.min(arr1.length, arr2.length);
        for (int i = 0; i < length; ++i) {
            if (arr1[i] < arr2[i]) {
                return -1;
            }
            if (arr1[i] <= arr2[i]) continue;
            return 1;
        }
        if (arr1.length == arr2.length) {
            return 0;
        }
        if (arr1.length < arr2.length) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.value = new byte[iStream.readInt()];
            iStream.readFully(this.value);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeInt(this.value.length);
            oStream.write(this.value, 0, this.value.length);
        }
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            byte[] otherBytes = ((BinaryValue)otherValue).value;
            result = this.value == null && otherBytes == null ? true : (this.value == null && otherBytes != null ? false : Arrays.equals(this.value, otherBytes));
        }
        return result;
    }

    @Override
    public void validate(IDataType iDataType, XQELogger aLogger) {
        if (this.value == null) {
            return;
        }
        BinaryType dType = (BinaryType)this.dataType;
        if (this.value.length > dType.getMaxLength()) {
            for (int i = dType.getMaxLength(); i < this.value.length; ++i) {
                if (this.value[i] == 0) continue;
                throw new ValueConversionException(XQEMessageKeys.DAT_BinaryOverflowError, Integer.toString(this.value.length), dType.getTypeName(), Integer.toString(dType.getMaxLength()));
            }
            byte[] bytes = new byte[dType.getMaxLength()];
            System.arraycopy(this.value, 0, bytes, 0, bytes.length);
            this.value = bytes;
        }
    }

    public byte[] substring(int index) throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (index < 0 || index > this.value.length - 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_BinarySubstringFunctionError, Integer.toString(index), Integer.toString(this.value.length), Integer.toString(this.value.length));
        }
        return this.substring(index, this.value.length);
    }

    public byte[] substring(int indexStart, int indexEnd) throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (indexStart < 0 || indexStart > indexEnd || indexEnd > this.value.length) {
            throw new ValueConversionException(XQEMessageKeys.DAT_BinarySubstringFunctionError, Integer.toString(indexStart), Integer.toString(indexEnd), Integer.toString(this.value.length));
        }
        return Arrays.copyOfRange(this.value, indexStart, indexEnd);
    }

    @Override
    public long position(IValue pattern) {
        int index = this.getString().indexOf(pattern.toString());
        if (index % 2 != 0) {
            return -1L;
        }
        return index / 2 + 1;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

