/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.ibm.json.java.internal.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import org.dom4j.Element;

public class BooleanValue
extends Value {
    static final long serialVersionUID = 4079593479635305149L;
    private static final String STRING_TRUE = "TRUE";
    private static final String STRING_FALSE = "FALSE";
    protected static final String STRING_UNKNOWN = "UNKNOWN";
    private static final String STRING_NUMERIC_TRUE = "1";
    private static final String STRING_NUMERIC_FALSE = "0";
    private static final int NUMERIC_TRUE = 1;
    private static final int NUMERIC_FALSE = 0;
    private boolean value;
    public static final BooleanValue TRUE = BooleanValue.getBooleanTrue();
    public static final BooleanValue FALSE = BooleanValue.getBooleanFalse();
    public static final BooleanValue UNKNOWN = BooleanValue.getBooleanUnknown();

    private static BooleanValue getBooleanTrue() {
        BooleanValue b = new BooleanValue();
        b.set(true);
        return b;
    }

    private static BooleanValue getBooleanFalse() {
        BooleanValue b = new BooleanValue();
        b.set(false);
        return b;
    }

    private static BooleanValue getBooleanUnknown() {
        BooleanValue b = new BooleanValue();
        b.setNull();
        return b;
    }

    BooleanValue() {
        super(DataTypeFactory.getBooleanType());
        this.setNotNull();
    }

    @Override
    public void set(Object object) {
        if (object == null) {
            this.setNull();
            return;
        }
        if (object instanceof Boolean) {
            this.set((Boolean)object);
        } else if (object instanceof Integer) {
            this.set((Integer)object);
        } else if (object instanceof Short) {
            this.set((Short)object);
        } else if (object instanceof Float) {
            this.set(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.set((Double)object);
        } else if (object instanceof Long) {
            this.set((Long)object);
        } else if (object instanceof Byte) {
            this.set(((Byte)object).intValue());
        } else if (object instanceof BigDecimal) {
            this.set((BigDecimal)object);
        } else if (object instanceof String) {
            this.set((String)object);
        } else {
            super.set(object);
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        if (sValue.compareToIgnoreCase(STRING_TRUE) == 0) {
            this.value = true;
            this.setNotNull();
            return;
        }
        if (sValue.compareToIgnoreCase(STRING_FALSE) == 0) {
            this.value = false;
            this.setNotNull();
            return;
        }
        if (sValue.compareToIgnoreCase(STRING_NUMERIC_TRUE) == 0) {
            this.value = true;
            this.setNotNull();
            return;
        }
        if (sValue.compareToIgnoreCase(STRING_NUMERIC_FALSE) == 0) {
            this.value = false;
            this.setNotNull();
            return;
        }
        if (sValue.compareToIgnoreCase(STRING_UNKNOWN) == 0) {
            this.setNull();
            return;
        }
        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "boolean");
    }

    @Override
    public void set(char[] cValue) {
        if (cValue == null) {
            this.setNull();
            return;
        }
        String s = new String(cValue);
        this.set(s);
    }

    @Override
    public void set(boolean bValue) {
        this.value = bValue;
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        this.value = sValue != 0;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = iValue != 0;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) {
        this.value = lValue != 0L;
        this.setNotNull();
    }

    @Override
    public void set(float fValue) {
        this.value = fValue != 0.0f;
        this.setNotNull();
    }

    @Override
    public void set(double dValue) {
        this.value = dValue != 0.0;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) {
        if (dValue == null) {
            this.setNull();
            return;
        }
        this.value = dValue.intValue() != 0;
        this.setNotNull();
    }

    @Override
    public void set(IValue v) {
        BooleanValue bValue = (BooleanValue)v;
        if (bValue.isNull()) {
            this.setNull();
        } else {
            this.value = bValue.getBoolean();
            this.setNotNull();
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return STRING_UNKNOWN;
        }
        if (this.value) {
            return STRING_TRUE;
        }
        return STRING_FALSE;
    }

    @Override
    public String getV5Literal() {
        return this.getString();
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        String[] literals = formatSpec.split(":");
        if (this.isNull()) {
            return literals[2];
        }
        if (this.value) {
            return literals[0];
        }
        return literals[1];
    }

    @Override
    public char[] getCharArray() {
        if (this.isNull()) {
            return STRING_UNKNOWN.toCharArray();
        }
        if (this.value) {
            return STRING_TRUE.toCharArray();
        }
        return STRING_FALSE.toCharArray();
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return STRING_UNKNOWN;
        }
        if (this.value) {
            return STRING_TRUE;
        }
        return STRING_FALSE;
    }

    @Override
    public boolean getBoolean() {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    @Override
    public short getShort() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getInteger() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getLong() {
        return this.getInteger();
    }

    @Override
    public float getFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        if (this.value) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public double getDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        if (this.value) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return new BigDecimal(0.0);
        }
        if (this.value) {
            return new BigDecimal(1.0);
        }
        return new BigDecimal(0.0);
    }

    public BooleanType getBooleanType() {
        return (BooleanType)this.dataType;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Boolean.hashCode(this.value);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        Value pValue = (Value)pObject;
        if (this.isError()) {
            if (pValue.isError()) {
                return 0;
            }
            return -1;
        }
        if (pValue.isError()) {
            return 1;
        }
        if (pValue.isNumeric()) {
            return -1 * pValue.compareTo(this, nullHandling);
        }
        boolean thatValue = false;
        boolean thisValue = false;
        if (this.isNull() && pValue.isNull()) {
            return 0;
        }
        if (this.isNull()) {
            if (nullHandling == NullBehavior.ZERO || nullHandling == NullBehavior.ZERO_STABLE_ELSE_FIRST || nullHandling == NullBehavior.ZERO_STABLE_ELSE_LAST) {
                thisValue = false;
                thatValue = pValue.getBoolean();
            } else if (nullHandling == NullBehavior.SQL) {
                return -1;
            }
        } else if (pValue.isNull()) {
            if (nullHandling == NullBehavior.ZERO || nullHandling == NullBehavior.ZERO_STABLE_ELSE_FIRST || nullHandling == NullBehavior.ZERO_STABLE_ELSE_LAST) {
                thisValue = this.value;
                thatValue = false;
            } else if (nullHandling == NullBehavior.SQL) {
                return 1;
            }
        } else {
            thisValue = this.value;
            thatValue = pValue.getBoolean();
        }
        if (thisValue == thatValue) {
            return 0;
        }
        if (thisValue && !thatValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo(object, NullBehavior.SQL);
    }

    public BooleanValue sqlCompareTo(Object object) {
        BooleanValue a = (BooleanValue)object;
        if (this.isNull() || a.isNull()) {
            return UNKNOWN;
        }
        if (this.value == a.getBoolean()) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public Object copy() {
        BooleanValue v = new BooleanValue();
        v.set(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = pValue.getBoolean();
        }
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.value = iStream.readBoolean();
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeBoolean(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((BooleanValue)otherValue).value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJSONLiteral() {
        String string;
        StringWriter writer = new StringWriter();
        Serializer srl = new Serializer((Writer)writer);
        try {
            if (this.isNull()) {
                srl.writeNull().flush();
            } else {
                srl.writeBoolean(Boolean.valueOf(this.value)).flush();
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                srl.close();
                writer.close();
                srl = null;
                writer = null;
                throw throwable;
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
            }
        }
        srl.close();
        writer.close();
        srl = null;
        writer = null;
        return string;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Boolean.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Boolean.parseBoolean(text);
        }
    }
}

