/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IAppendable;
import com.cognos.xqe.data.values.IPosition;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.dom4j.Element;

public class ClobValue
extends Value
implements ITextValue,
IAppendable,
IPosition,
Clob {
    static final long serialVersionUID = -8931617823567402600L;
    private Clob clob;
    private String value;

    ClobValue() {
        super(ClobType.CLOBTYPE);
    }

    @Override
    public void set(Object object) throws XQERuntimeException {
        if (object == null) {
            this.clob = null;
            this.setNull();
            return;
        }
        if (object instanceof String) {
            this.set((String)object);
        } else if (object instanceof Clob) {
            this.clob = (Clob)object;
        } else {
            super.set(object);
        }
        this.setNotNull();
    }

    @Override
    public void set(String sValue) throws XQERuntimeException {
        if (sValue == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        if (this.clob == null) {
            this.value = sValue;
            return;
        }
        OutputStream os = null;
        try {
            os = this.clob.setAsciiStream(1L);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        try {
            os.write(sValue.getBytes());
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void append(IValue sValue) throws ValueConversionException {
        this.append(((Value)sValue).getString());
    }

    @Override
    public void append(String sValue) throws XQERuntimeException {
        if (sValue == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        if (this.clob == null) {
            this.value = this.value == null ? sValue : this.value.concat(sValue);
            return;
        }
        OutputStream os = null;
        try {
            os = this.clob.setAsciiStream(this.clob.length() + 1L);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        try {
            os.write(sValue.getBytes());
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        this.set(((Value)v).getString());
    }

    @Override
    public Object getObject() {
        return this.clob;
    }

    @Override
    public String getString() {
        String result;
        if (this.isNull()) {
            return null;
        }
        if (this.clob == null) {
            return this.value;
        }
        try {
            result = this.clob.length() == 0L ? "" : this.clob.getSubString(1L, (int)this.clob.length());
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    @Override
    public String getJDBCLiteral() {
        return this.getSQLLiteral();
    }

    @Override
    public String getSQLLiteral() {
        return this.getFormattedLiteral("'%s'");
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        return String.format(formatSpec, this.getString());
    }

    @Override
    public Object copy() {
        ClobValue v = new ClobValue();
        if (this.isNull()) {
            v.setNull();
        } else if (this.clob == null) {
            v.set(this.value);
        } else {
            v.set(this.clob);
        }
        return v;
    }

    @Override
    public Object toJSON() {
        return this.getString();
    }

    @Override
    public long position(IValue pattern) {
        long result;
        try {
            String searchStr = pattern.toString();
            result = this.clob == null ? (long)(this.value.indexOf(searchStr, 1) + 1) : this.clob.position(searchStr, 1L);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        if (result < 0L) {
            result = 0L;
        }
        return result;
    }

    @Override
    public String substring(long position, int length) {
        String result;
        try {
            result = this.clob == null ? (this.value.length() == 0 ? "" : this.value.substring((int)position, length)) : (this.clob.length() == 0L ? "" : this.clob.getSubString(position, length));
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        Value sValue = (Value)pObject;
        int result = this.isNull() ? (sValue.isNull() ? 0 : -1) : (sValue.isNull() ? 1 : this.getString().compareTo(sValue.getString()));
        return result;
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readUTF());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeUTF(this.getString());
        }
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        this.set(iValue);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            ClobValue otherClob = (ClobValue)otherValue;
            result = this.clob == null ? otherClob.clob == null : this.clob.equals(otherClob.clob);
            if (result) {
                result = this.value == null ? otherClob.value == null : this.value.equals(otherClob.value);
            }
        }
        return result;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return null;
    }

    @Override
    public int getInteger() {
        int result;
        try {
            result = Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.getString(), "integer");
        }
        return result;
    }

    @Override
    public int getInteger(int precision, int scale) {
        int result = this.getInteger();
        if (scale == 0) {
            return result;
        }
        return (int)((double)result * MathUtil.pow10(scale));
    }

    @Override
    public long getLong(int precision, int scale) {
        long result = this.getTimeInNanoseconds();
        if (scale == 0) {
            return result;
        }
        return (long)((double)result * MathUtil.pow10(scale));
    }

    public long getTimeInNanoseconds() {
        long result;
        try {
            result = Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.getString(), "long");
        }
        return result;
    }

    @Override
    public short getShort() {
        short result;
        try {
            result = Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.getString(), "smallint");
        }
        return result;
    }

    @Override
    public short getShort(int precision, int scale) {
        short result = this.getShort();
        if (scale == 0) {
            return result;
        }
        return (short)((double)result * MathUtil.pow10(scale));
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.getString());
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        BigDecimal bd = new BigDecimal(this.getString(), new MathContext(precision, RoundingMode.HALF_DOWN));
        return bd.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public float getFloat() {
        FloatValue floatValue = DataValueFactory.createFloatValue();
        floatValue.set(this.getString());
        return floatValue.getFloat();
    }

    @Override
    public double getDouble() throws XQERuntimeException {
        DoubleValue doubleValue = DataValueFactory.createDoubleValue();
        doubleValue.set(this.getString());
        return doubleValue.getDouble();
    }

    @Override
    public Date getDate() throws XQERuntimeException {
        if (this.isNull() || this.getString() == null) {
            return null;
        }
        DateValue dv = DataValueFactory.createDateValue();
        dv.set(this.getString());
        return dv.getDate();
    }

    @Override
    public Timestamp getTimestamp() throws XQERuntimeException {
        if (this.isNull() || this.getString() == null) {
            return null;
        }
        TimestampValue tv = DataValueFactory.createTimestampValue();
        tv.set(this.getString());
        return tv.getTimestamp();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.clob != null) {
            return this.substring(pos, length);
        }
        return this.value.substring((int)pos - 1, (int)pos + length - 1);
    }

    @Override
    public long length() throws SQLException {
        if (this.clob != null) {
            return this.clob.length();
        }
        return this.value.length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return 0L;
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return 0L;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return null;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return null;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return 0;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return 0;
    }

    @Override
    public void truncate(long len) throws SQLException {
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return null;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        if (this.value != null) {
            ctx.data(this.value);
        }
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = text;
        }
    }
}

