/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.BinaryType;
import com.cognos.xqe.data.types.BlobType;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.JSONType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.MapType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.data.types.PeriodType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.types.TinyintType;
import com.cognos.xqe.data.types.VarBinaryType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.BinaryValue;
import com.cognos.xqe.data.values.BlobValue;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.ClobValue;
import com.cognos.xqe.data.values.DataLinkValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Decfloat128DecimalValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.JSONValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.MapValue;
import com.cognos.xqe.data.values.MemberNumericPropertyValue;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.MemberStringPropertyValue;
import com.cognos.xqe.data.values.MultisetValue;
import com.cognos.xqe.data.values.NCharValue;
import com.cognos.xqe.data.values.NVarcharValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.PeriodValue;
import com.cognos.xqe.data.values.RefValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.SmallDecimalValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.StructValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.TinyintValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.VarBinaryValue;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.data.values.VariantValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;

public final class DataValueFactory {
    private DataValueFactory() {
    }

    public static ArrayValue createArrayValue(ArrayType type) {
        return new ArrayValue(type);
    }

    public static ArrayValue createArrayValue(IDataType type) {
        return new ArrayValue(DataTypeFactory.getArrayType(type));
    }

    public static BinaryValue createBinaryValue(BinaryType type) {
        return new BinaryValue(type);
    }

    public static BinaryValue createBinaryValue() {
        return new BinaryValue(DataTypeFactory.getBinaryType());
    }

    public static VarBinaryValue createVarBinaryValue(VarBinaryType type) {
        return new VarBinaryValue(type);
    }

    public static VarBinaryValue createVarBinaryValue() {
        return new VarBinaryValue(DataTypeFactory.getVarBinaryType());
    }

    public static TinyintValue createTinyintValue(TinyintType type) {
        return new TinyintValue(type);
    }

    public static TinyintValue createTinyintValue() {
        return new TinyintValue(DataTypeFactory.getTinyintType());
    }

    public static TinyintValue createTinyintValue(byte value) {
        TinyintValue result = new TinyintValue(DataTypeFactory.getTinyintType());
        result.set(value);
        return result;
    }

    public static SmallintValue createSmallintValue(SmallintType type) {
        return new SmallintValue(type);
    }

    public static SmallintValue createSmallintValue() {
        return new SmallintValue(DataTypeFactory.getSmallintType());
    }

    public static SmallintValue createSmallintValue(int value) {
        SmallintValue result = new SmallintValue(DataTypeFactory.getSmallintType());
        result.set(value);
        return result;
    }

    public static IntegerValue createIntegerValue(IntegerType type) {
        return new IntegerValue(type);
    }

    public static IntegerValue createIntegerValue() {
        return new IntegerValue(DataTypeFactory.getIntegerType());
    }

    public static IntegerValue createIntegerValue(int value) {
        IntegerValue result = new IntegerValue(DataTypeFactory.getIntegerType());
        result.set(value);
        return result;
    }

    public static LongValue createLongValue(LongType type) {
        return new LongValue(type);
    }

    public static LongValue createLongValue() {
        return new LongValue(DataTypeFactory.getLongType());
    }

    public static FloatValue createFloatValue() {
        return new FloatValue();
    }

    public static DoubleValue createDoubleValue() {
        return new DoubleValue();
    }

    public static DecimalValue createDecimalValue(DecimalType type) {
        if (type.getPrecision() == 0) {
            return new Decfloat128DecimalValue(type);
        }
        if (type.getPrecision() <= 18) {
            return new SmallDecimalValue(type);
        }
        return new BigDecimalValue(type);
    }

    public static DecimalValue createDecimalValue() {
        return new BigDecimalValue(DataTypeFactory.getDecimalType());
    }

    public static StringValue createStringValue(StringType type) {
        return new StringValue(type, null);
    }

    public static StringValue createStringValue() {
        return new StringValue(DataTypeFactory.getStringType(), null);
    }

    public static StringValue createStringValue(Collator collator) {
        return new StringValue(DataTypeFactory.getStringType(), collator);
    }

    public static StringValue createStringValue(StringType type, Collator collator) {
        return new StringValue(type, collator);
    }

    public static CharValue createCharValue(CharType type) {
        return new CharValue(type, null);
    }

    public static CharValue createCharValue(CharType type, Collator collator) {
        return new CharValue(type, collator);
    }

    public static CharValue createCharValue() {
        return new CharValue(DataTypeFactory.getCharType(), null);
    }

    public static CharValue createCharValue(String value) {
        CharValue result = new CharValue(DataTypeFactory.getCharType(value.length()), null);
        result.set(value);
        return result;
    }

    public static CharValue createCharValue(int length) {
        return new CharValue(DataTypeFactory.getCharType(length), null);
    }

    public static VarcharValue createVarcharValue(VarcharType type) {
        return new VarcharValue(type, null);
    }

    public static VarcharValue createVarcharValue(Collator collator) {
        return new VarcharValue(DataTypeFactory.getVarcharType(), collator);
    }

    public static VarcharValue createVarcharValue(VarcharType type, Collator collator) {
        return new VarcharValue(type, collator);
    }

    public static VarcharValue createVarcharValue(int length) {
        return new VarcharValue(DataTypeFactory.getVarcharType(length), null);
    }

    public static VarcharValue createVarcharValue() {
        return new VarcharValue(DataTypeFactory.getVarcharType(), null);
    }

    public static MultisetValue createMultisetValue(IDataType type) {
        return new MultisetValue(DataTypeFactory.getMultisetType(type));
    }

    public static MultisetValue createMultisetValue(MultisetType type) {
        return new MultisetValue(type);
    }

    public static MapValue createMapValue(MapType type) {
        return new MapValue(DataTypeFactory.getMapType(type.getKeyType(), type.getElementType()));
    }

    public static NCharValue createNCharValue(NCharType type) {
        return new NCharValue(type, null);
    }

    public static NCharValue createNCharValue(NCharType type, Collator collator) {
        return new NCharValue(type, collator);
    }

    public static NCharValue createNCharValue() {
        return new NCharValue(DataTypeFactory.getNCharType(), null);
    }

    public static NCharValue createNCharValue(int length) {
        return new NCharValue(DataTypeFactory.getNCharType(length), null);
    }

    public static NVarcharValue createNVarcharValue(NVarcharType type) {
        return new NVarcharValue(type, null);
    }

    public static NVarcharValue createNVarcharValue(NVarcharType type, Collator collator) {
        return new NVarcharValue(type, collator);
    }

    public static NVarcharValue createNVarcharValue(int length) {
        return new NVarcharValue(DataTypeFactory.getNVarcharType(length), null);
    }

    public static NVarcharValue createNVarcharValue() {
        return new NVarcharValue(DataTypeFactory.getNVarcharType(), null);
    }

    public static DateValue createDateValue() {
        return new DateValue();
    }

    public static TimeValue createTimeValue(TimeType type) {
        return new TimeValue(type);
    }

    public static TimeValue createTimeValue() {
        return new TimeValue(DataTypeFactory.getTimeType());
    }

    public static TimeWithTZValue createTimeWithTZValue(TimeWithTZType type) {
        return new TimeWithTZValue(type);
    }

    public static TimeWithTZValue createTimeWithTZValue() {
        return new TimeWithTZValue(DataTypeFactory.getTimeWithTZType());
    }

    public static TimestampValue createTimestampValue(TimestampType type) {
        return new TimestampValue(type);
    }

    public static TimestampValue createTimestampValue() {
        return new TimestampValue(DataTypeFactory.getTimestampType());
    }

    public static TimestampWithTZValue createTimestampWithTZValue(TimestampWithTZType type) {
        return new TimestampWithTZValue(type);
    }

    public static TimestampWithTZValue createTimestampWithTZValue() {
        return new TimestampWithTZValue(DataTypeFactory.getTimestampWithTZType());
    }

    public static PeriodValue createPeriodValue(PeriodType type) {
        return new PeriodValue(type);
    }

    public static BooleanValue createBooleanValue() {
        return new BooleanValue();
    }

    public static IntervalYearMonthValue createIntervalYearMonthValue() {
        return new IntervalYearMonthValue(DataTypeFactory.getIntervalYearMonthType());
    }

    public static IntervalYearMonthValue createIntervalYearMonthValue(IntervalYearMonthType type) {
        return new IntervalYearMonthValue(type);
    }

    public static IntervalDayTimeValue createIntervalDayTimeValue() {
        return new IntervalDayTimeValue(DataTypeFactory.getIntervalDayTimeType());
    }

    public static IntervalDayTimeValue createIntervalDayTimeValue(IntervalDayTimeType type) {
        return new IntervalDayTimeValue(type);
    }

    public static BlobValue createBlobValue(BlobType type) {
        return new BlobValue();
    }

    public static BlobValue createBlobValue() {
        return new BlobValue();
    }

    public static ClobValue createClobValue(ClobType type) {
        return new ClobValue();
    }

    public static ClobValue createClobValue() {
        return new ClobValue();
    }

    public static XmlValue createXmlValue(XmlType type) {
        return new XmlValue(type);
    }

    public static XmlValue createXmlValue() {
        return new XmlValue(DataTypeFactory.getXmlType());
    }

    public static JSONValue createJSONValue(JSONType type) {
        return new JSONValue(type);
    }

    public static JSONValue createJSONValue() {
        return new JSONValue(DataTypeFactory.getJSONType());
    }

    public static StructValue createStructValue(StructType type) {
        return new StructValue(type);
    }

    public static StructValue createStructValue(Collator collator, StructType structType) {
        return new StructValue(collator, structType);
    }

    public static VariantValue createVariantValue() {
        return new VariantValue(DataTypeFactory.getVariantType());
    }

    public static RowValue createRowValue(int nColumns) {
        return new RowValue(nColumns);
    }

    public static RowValue createRowValue(IValue[] values) {
        return new RowValue(values);
    }

    public static RowValue createRowValue(IRowsetInfo rowsetInfo) {
        return new RowValue(new IValue[rowsetInfo.getNumColumns()]);
    }

    public static RowValue createRowValue(Collator collator, IRowsetInfo rowsetInfo) {
        IValue[] values = new IValue[rowsetInfo.getNumColumns()];
        for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
            values[i] = rowsetInfo.getColumnInfo(i).getDataType().createValue(collator);
        }
        return new RowValue(values);
    }

    public static RowValue createRowValue(RowType rowType) {
        return DataValueFactory.createRowValue(null, rowType);
    }

    public static RowValue createRowValue(Collator collator, RowType rowType) {
        RowValue result = new RowValue(rowType);
        IValue[] values = new IValue[rowType.getNumberColumns()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = rowType.getFieldDataType(i).createValue(collator);
        }
        result.set(values);
        return result;
    }

    public static RowValue createRowValue(Collator collator, IDataType[] columnTypes) {
        IValue[] values = new IValue[columnTypes.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = columnTypes[i].createValue(collator);
        }
        return new RowValue(values);
    }

    public static RowValue createRowValue(IDataType[] columnTypes) {
        return DataValueFactory.createRowValue(null, columnTypes);
    }

    public static ObjectValue createObjectValue() {
        return new ObjectValue();
    }

    public static ObjectValue createObjectValue(Object value) {
        ObjectValue objValue = new ObjectValue();
        objValue.set(value);
        return objValue;
    }

    public static RefValue createRefValue() {
        return new RefValue();
    }

    public static NullValue createNullValue() {
        return new NullValue();
    }

    public static DataLinkValue createDataLinkValue() {
        return new DataLinkValue();
    }

    public static IValue createValueFromStandardJDBCType(Collator collator, ResultSetMetaData metadata, int columnNo) {
        IDataType dataType = DataTypeFactory.createDataTypeFromStandardJDBCType(metadata, columnNo);
        return dataType.createValue(collator);
    }

    public static IValue createMemberPropertyValue(IDataType dataType) {
        return new MemberStringPropertyValue(dataType, null);
    }

    public static IValue createMemberNumericPropertyValue(IDataType dataType) {
        return new MemberNumericPropertyValue(dataType);
    }

    public static IValue createMemberRSAPIValue() {
        return new MemberRSAPIValue(null);
    }

    public static Value convertObjectToIValue(Object object) {
        Value value = null;
        value = object instanceof String ? DataValueFactory.createStringValue() : (object instanceof Integer ? DataValueFactory.createIntegerValue() : (object instanceof Boolean ? DataValueFactory.createBooleanValue() : (object instanceof Float ? DataValueFactory.createFloatValue() : (object instanceof Double ? DataValueFactory.createDoubleValue() : (object instanceof BigDecimal ? DataValueFactory.createDecimalValue() : (object instanceof Date ? DataValueFactory.createDateValue() : (object instanceof Array ? DataValueFactory.createArrayValue(null) : (object instanceof Long ? DataValueFactory.createLongValue() : DataValueFactory.createObjectValue()))))))));
        ((Value)value).set(object);
        return value;
    }

    public static Value createByName(String name) {
        Value result = null;
        if (name.equals("BigDecimalValue")) {
            result = DataValueFactory.createDecimalValue();
        } else if (name.equals("BooleanValue")) {
            result = DataValueFactory.createBooleanValue();
        } else if (name.equals("CharValue")) {
            result = DataValueFactory.createCharValue();
        } else if (name.equals("DateValue")) {
            result = DataValueFactory.createDateValue();
        } else if (name.equals("DoubleValue")) {
            result = DataValueFactory.createDoubleValue();
        } else if (name.equals("FloatValue")) {
            result = DataValueFactory.createFloatValue();
        } else if (name.equals("IntegerValue")) {
            result = DataValueFactory.createIntegerValue();
        } else if (name.equals("IntervalDayTimeValue")) {
            result = DataValueFactory.createIntervalDayTimeValue();
        } else if (name.equals("IntervalYearMonthValue")) {
            result = DataValueFactory.createIntervalYearMonthValue();
        } else if (name.equals("Long")) {
            result = DataValueFactory.createLongValue();
        } else if (name.equals("NCharValue")) {
            result = DataValueFactory.createNCharValue();
        } else if (name.equals("NullValue")) {
            result = DataValueFactory.createNullValue();
        } else if (name.equals("NVarcharValue")) {
            result = DataValueFactory.createNVarcharValue();
        } else if (name.equals("SmallDecimalValue")) {
            result = DataValueFactory.createDecimalValue();
        } else if (name.equals("SmallintValue")) {
            result = DataValueFactory.createSmallintValue();
        } else if (name.equals("StringValue")) {
            result = DataValueFactory.createStringValue();
        } else if (name.equals("TimestampValue")) {
            result = DataValueFactory.createTimestampValue();
        } else if (name.equals("TimeValue")) {
            result = DataValueFactory.createTimeValue();
        } else if (name.equals("VarcharValue")) {
            result = DataValueFactory.createVarcharValue();
        }
        return result;
    }
}

