/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IExtract;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.ibm.json.java.internal.Serializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.dom4j.Element;

public abstract class DateTimeValue
extends Value
implements IExtract,
IAddable,
ISubtractable {
    static final long serialVersionUID = -4231132006736867360L;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int DAYS_PER_WEEK = 7;
    public static final int NANOSECONDS_PER_SECOND = 1000000000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MILLISECONDS_PER_WEEK = 604800000;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MONTHS_PER_YEAR = 12;
    public static final int MONTHS_PER_QUARTER = 3;
    public static final int QUARTERS_PER_YEAR = 4;
    public static final String CONFIG_INCLUDE_DST_IN_TZ_OFFSET = "general.includeDstInTimeZoneOffset";
    private static final String ONE = "1";
    private static final int PRIME = 31;
    public static final String RX_DATE = "[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+";
    public static final String RX_TIME = "[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?";
    public static final String RX_TIMEZONE = "(\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?";
    public static final String SPACE = " ";
    public static final String HYPHEN = "-";
    public static final String PLUS = "+";
    public static final String COLON = ":";
    public static final String PERIOD = ".";
    public static final String ZERO_NANOSECONDS = "000";
    public static final int NUMBER_OF_DAYS_IN_FIRST_ISO_WEEK = 4;
    public static final int ISO_FIRST_DAY_OF_WEEK = 2;
    public static final int ISO_DOW_CONVERSION_FACTOR = 5;
    public static final int PRECISION = 9;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String[] ZEROS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    protected static final String[] DATETIME_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy.MM.dd G 'at' HH:mm:ss z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "MMM dd, yyyy hh:mm:ss aaa", "yyyy-MM-dd", "EEE, d MMM yyyy HH:mm:ss Z", "EEE MMM dd HH:mm:ss Z yyyy"};
    private static final byte JDBC_NANOSECOND_PRECISION = 3;
    private static final GregorianCalendar GC_VALUE = new GregorianCalendar();
    private static Boolean includeDstInTimeZoneOffset;
    private GregorianCalendar value;
    private int nanoseconds = 0;
    private long milliseconds = -1L;
    protected static final Value ONE_SECOND;
    protected static final Value ONE_DAY;

    private static Boolean includeDstInTimeZoneOffset() {
        if (includeDstInTimeZoneOffset == null) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
            includeDstInTimeZoneOffset = config.getBooleanProperty("general.includeDstInTimeZoneOffset[@enabled]", true);
        }
        return includeDstInTimeZoneOffset;
    }

    DateTimeValue(DataType type) {
        super(type);
        this.setNull();
        this.value = null;
    }

    private GregorianCalendar getTheCalendarValue() {
        if (this.value == null) {
            this.value = (GregorianCalendar)GC_VALUE.clone();
            if (this.milliseconds != -1L) {
                this.value.setTimeInMillis(this.milliseconds);
                this.milliseconds = -1L;
            }
        }
        return this.value;
    }

    private int getTheCalendarValue(int field) {
        return this.getTheCalendarValue().get(field);
    }

    private void clearCalendarValue() {
        if (this.value != null) {
            this.value.clear();
        }
    }

    protected void clear() {
        this.value = null;
    }

    private void addCalendarValue(int property, int iValue) {
        this.getTheCalendarValue().add(property, iValue);
    }

    public Calendar getCalendar() {
        return this.getTheCalendarValue();
    }

    public static long subtractNoDST(Calendar c1, Calendar c2) {
        GregorianCalendar cc1 = new GregorianCalendar(UTC);
        GregorianCalendar cc2 = new GregorianCalendar(UTC);
        cc1.set(1, c1.get(1));
        cc1.set(2, c1.get(2));
        cc1.set(5, c1.get(5));
        cc1.set(11, c1.get(11));
        cc1.set(12, c1.get(12));
        cc1.set(13, c1.get(13));
        cc1.set(14, 0);
        cc1.setLenient(false);
        cc2.set(1, c2.get(1));
        cc2.set(2, c2.get(2));
        cc2.set(5, c2.get(5));
        cc2.set(11, c2.get(11));
        cc2.set(12, c2.get(12));
        cc2.set(13, c2.get(13));
        cc2.set(14, 0);
        cc2.setLenient(false);
        long diff = cc1.getTimeInMillis() - cc2.getTimeInMillis() - (long)c1.get(15) + (long)c2.get(15);
        return diff;
    }

    public long getMilliseconds() {
        if (this.value != null || this.milliseconds == -1L) {
            return this.getTheCalendarValue().getTimeInMillis();
        }
        return this.milliseconds;
    }

    public int getYear() throws XQERuntimeException {
        return this.getTheCalendarValue(1);
    }

    public int getQuarter() throws XQERuntimeException {
        return (this.getMonth() - 1) / 3 + 1;
    }

    public int getMonth() throws XQERuntimeException {
        return this.getTheCalendarValue(2) + 1;
    }

    public int getDay() throws XQERuntimeException {
        return this.getTheCalendarValue(5);
    }

    public int getHour() throws XQERuntimeException {
        return this.getTheCalendarValue(11);
    }

    public int getMinute() throws XQERuntimeException {
        return this.getTheCalendarValue(12);
    }

    public int getSecond() throws XQERuntimeException {
        return this.getTheCalendarValue(13);
    }

    public int getNanoseconds() throws XQERuntimeException {
        return this.nanoseconds;
    }

    public TimeZone getTimeZone() {
        return this.getTheCalendarValue().getTimeZone();
    }

    public boolean useDaylight() {
        return this.getTimeZone().useDaylightTime();
    }

    public boolean inDaylightTime() {
        TimeZone timeZone = this.getTimeZone();
        return timeZone.inDaylightTime(this.getDate());
    }

    public int getTimeZoneHour() {
        if (DateTimeValue.includeDstInTimeZoneOffset().booleanValue() && this.inDaylightTime()) {
            return (this.getZoneOffset() + this.getTimeZone().getDSTSavings()) / 3600000;
        }
        return this.getZoneOffset() / 3600000;
    }

    public int getTimeZoneMinute() {
        if (DateTimeValue.includeDstInTimeZoneOffset().booleanValue() && this.inDaylightTime()) {
            return (this.getZoneOffset() + this.getTimeZone().getDSTSavings()) % 3600000 / 60000;
        }
        return this.getZoneOffset() % 3600000 / 60000;
    }

    public int getEpoch() {
        return (int)(this.getMilliseconds() / 1000L);
    }

    public int getDSTOffset() {
        return this.getTheCalendarValue(16);
    }

    @Override
    public java.util.Date getDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.util.Date(this.getMilliseconds());
    }

    private int getZoneOffset() {
        return this.getTheCalendarValue(15);
    }

    @Override
    public Date getJdbcDate() {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getMilliseconds());
    }

    @Override
    public Time getTime() {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.getMilliseconds());
    }

    @Override
    public Timestamp getTimestamp() {
        if (this.isNull()) {
            return null;
        }
        Timestamp t = new Timestamp(this.getMilliseconds());
        t.setNanos(this.getNanoseconds());
        return t;
    }

    @Override
    public LocalDate getLocalDate() {
        if (this.isNull()) {
            return null;
        }
        return LocalDate.of(this.getYear(), this.getMonth(), this.getDay());
    }

    @Override
    public LocalTime getLocalTime() {
        if (this.isNull()) {
            return null;
        }
        return LocalTime.of(this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
    }

    @Override
    public OffsetTime getOffsetTime() {
        if (this.isNull()) {
            return null;
        }
        return this.getLocalTime().atOffset(ZoneOffset.ofHoursMinutes(this.getTimeZoneHour(), this.getTimeZoneMinute()));
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        if (this.isNull()) {
            return null;
        }
        return LocalDateTime.of(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        if (this.isNull()) {
            return null;
        }
        return this.getLocalDateTime().atOffset(ZoneOffset.ofHoursMinutes(this.getTimeZoneHour(), this.getTimeZoneMinute()));
    }

    @Override
    public void set(Object obj) throws UnsupportedOperationException {
        if (obj instanceof TimestampColumnVector.UnixTimestamp) {
            this.set((TimestampColumnVector.UnixTimestamp)obj);
        } else {
            super.set(obj);
        }
    }

    public void set(TimestampColumnVector.UnixTimestamp ts) {
        this.set(ts.milliseconds);
        this.setNanoseconds(ts.nanoseconds);
    }

    @Override
    public void set(String sValue) {
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("[NULL]") == 0) {
            this.setNull();
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat();
        ParsePosition pp = new ParsePosition(0);
        df.parse(sValue, pp);
        if (pp.getErrorIndex() != 0 || pp.getIndex() != sValue.length()) {
            pp.setErrorIndex(0);
            pp.setIndex(0);
            for (String pattern : DATETIME_PATTERNS) {
                df.applyPattern(pattern);
                df.parse(sValue, pp);
                if (pp.getErrorIndex() == 0 && pp.getIndex() == sValue.length()) {
                    this.set(df.getCalendar());
                    this.setNotNull();
                    return;
                }
                pp.setErrorIndex(0);
                pp.setIndex(0);
            }
        }
        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "date");
    }

    @Override
    public void set(long lValue) {
        long integralSeconds = lValue / 1000L * 1000L;
        this.setNanoseconds((int)(lValue % 1000L * 1000000L));
        if (this.getNanoseconds() < 0) {
            this.setNanoseconds(1000000000 + this.getNanoseconds());
            integralSeconds = (integralSeconds / 1000L - 1L) * 1000L;
        }
        this.setNotNull();
        this.clearCalendarValue();
        this.setTimeInMillis(integralSeconds);
    }

    public void set(Calendar calendar) {
        this.setNotNull();
        this.clearCalendarValue();
        TimeZone timeZone = calendar.getTimeZone();
        long timeInMillis = calendar.getTimeInMillis();
        int pNanos = 1000000 * calendar.get(14);
        this.set(timeZone, timeInMillis, pNanos);
    }

    private void set(TimeZone timeZone, long timeInMillis, int pNanos) {
        this.setTimeZone(timeZone);
        this.setTimeInMillis(timeInMillis);
        this.setNanoseconds(pNanos);
    }

    public void set(java.util.Date dValue) {
        if (dValue == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.clearCalendarValue();
        this.setTimeInMillis(dValue.getTime());
        this.clearMillisecond();
        this.setNanoseconds(0);
    }

    @Override
    public void set(Timestamp dValue) {
        if (dValue == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.clearCalendarValue();
        this.setTimeInMillis(dValue.getTime());
        this.clearMillisecond();
        this.setNanoseconds(dValue.getNanos());
    }

    private void setTimeInMillis(long time) {
        if (this.value != null) {
            this.getTheCalendarValue().setTimeInMillis(time);
            return;
        }
        this.milliseconds = time;
    }

    private void setYear(int year) {
        this.getTheCalendarValue().set(1, year);
    }

    private void setMonth(int month) {
        this.getTheCalendarValue().set(2, month - 1);
    }

    private void setDay(int day) {
        this.getTheCalendarValue().set(5, day);
    }

    private void setHour(int pHour) {
        this.getTheCalendarValue().set(11, pHour);
    }

    private void setMinute(int pMinutes) {
        this.getTheCalendarValue().set(12, pMinutes);
    }

    private void setSecond(int pSeconds) {
        this.getTheCalendarValue().set(13, pSeconds);
    }

    public void setNanoseconds(int pNanos) {
        this.nanoseconds = pNanos;
    }

    private void clearMillisecond() {
        this.getTheCalendarValue().set(14, 0);
    }

    protected void setTimeZone(TimeZone tz) {
        this.getTheCalendarValue().setTimeZone(tz);
    }

    public void setTimeZone(int offset) {
        String timeZoneID = TimeWithTZValue.createCustomTimeZoneID(offset);
        this.setTimeZone(new SimpleTimeZone(offset, timeZoneID));
    }

    @Override
    public abstract void add(IValue var1);

    public void addYears(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(1, iValue);
    }

    public void addQuarters(int iValue) {
        if (this.isNull()) {
            return;
        }
        int nMonths = iValue * 3;
        this.addCalendarValue(2, nMonths);
    }

    public void addMonths(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(2, iValue);
    }

    public void addWeeks(int iValue) {
        if (this.isNull()) {
            return;
        }
        int nDays = iValue * 7;
        this.addCalendarValue(5, nDays);
    }

    public void addDays(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(5, iValue);
    }

    public void addHours(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(10, iValue);
    }

    public void addMinutes(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(12, iValue);
    }

    public void addSeconds(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addCalendarValue(13, iValue);
    }

    public void addNanoSeconds(long iValue) {
        if (this.isNull()) {
            return;
        }
        long nanosecs = (long)this.getNanoseconds() + iValue;
        int seconds = (int)(nanosecs / 1000000000L);
        this.setNanoseconds((int)(nanosecs % 1000000000L));
        if (this.getNanoseconds() < 0) {
            --seconds;
            this.setNanoseconds(this.getNanoseconds() + 1000000000);
        }
        this.addCalendarValue(13, seconds);
    }

    public void subtractYears(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addYears(-iValue);
    }

    public void subtractQuarters(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addQuarters(-iValue);
    }

    public void subtractMonths(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addMonths(-iValue);
    }

    public void subtractWeeks(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addWeeks(-iValue);
    }

    public void subtractDays(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addDays(-iValue);
    }

    public void subtractHours(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addHours(-iValue);
    }

    public void subtractMinutes(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addMinutes(-iValue);
    }

    public void subtractSeconds(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addSeconds(-iValue);
    }

    public void subtractNanoSeconds(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.addNanoSeconds(-iValue);
    }

    @Override
    public void subtract(IValue value1, IValue value2) throws ValueArithmeticException {
        this.set(value1);
        this.subtract(value2);
    }

    public abstract DateTimeValue next() throws SQLException;

    public abstract DateTimeValue prior() throws SQLException;

    @Override
    public int compareTo(Object object) {
        DateTimeValue a;
        Value val = (Value)object;
        if (this.isNull() && val.isNull()) {
            return 0;
        }
        if (!this.isNull() && val.isNull()) {
            return 1;
        }
        if (this.isNull() && !val.isNull()) {
            return -1;
        }
        if (object instanceof TextValue) {
            a = DataValueFactory.createTimestampValue();
            a.set(((TextValue)object).getTimestamp());
        } else {
            a = (DateTimeValue)object;
        }
        int result = this.getMilliseconds() > a.getMilliseconds() ? 1 : (this.getMilliseconds() < a.getMilliseconds() ? -1 : (this.getNanoseconds() == a.getNanoseconds() ? 0 : (this.getNanoseconds() > a.getNanoseconds() ? 1 : -1)));
        return result;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return 31 * Long.hashCode(this.getMilliseconds()) + this.getNanoseconds();
    }

    public BooleanValue sqlCompareTo(Object object) {
        DateTimeValue a = (DateTimeValue)object;
        if (this.isNull() || a.isNull()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.getMilliseconds() == a.getMilliseconds() && this.getNanoseconds() == a.getNanoseconds()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static String convertNanosToFractionalString(int nanos) {
        if (nanos == 0) {
            return ZEROS[0];
        }
        StringBuilder b = new StringBuilder();
        b.append(PERIOD);
        String nanosString = Integer.toString(nanos);
        b.append(ZEROS[9 - nanosString.length()]);
        b.append(nanosString);
        return b.toString();
    }

    public static int extractNanoseconds(String pValue) throws XQERuntimeException {
        int numZeros = 9 - pValue.length();
        if (numZeros != 0) {
            pValue = pValue + ZEROS[numZeros];
        }
        return Integer.parseInt(pValue);
    }

    public String convertTimeZoneToString() {
        StringBuilder b = new StringBuilder();
        int hour = this.getTimeZoneHour();
        int minute = Math.abs(this.getTimeZoneMinute());
        if (hour < 0) {
            hour = -hour;
            b.append(HYPHEN);
        } else {
            b.append(PLUS);
        }
        DecimalFormat f = new DecimalFormat(ZEROS[2]);
        b.append(f.format(hour) + COLON + f.format(minute));
        return b.toString();
    }

    @Override
    public double extract(int field) {
        switch (field) {
            case 1: {
                return this.getYear();
            }
            case 2: {
                return this.getMonth();
            }
            case 3: {
                return this.getDay();
            }
            case 4: {
                return this.getHour();
            }
            case 5: {
                return this.getMinute();
            }
            case 6: {
                double result = this.getSecond();
                return result += (double)this.getNanoseconds() / 1.0E9;
            }
            case 7: {
                return this.getTimeZoneHour();
            }
            case 8: {
                return this.getTimeZoneMinute();
            }
            case 9: {
                return this.getEpoch();
            }
        }
        return 0.0;
    }

    @Override
    public String getXSDLiteral() {
        if (this.isNull()) {
            return null;
        }
        if (this.getNanoseconds() > 0) {
            return String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d.%7$09d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
        }
        return String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }

    public int weekOfYear() {
        return this.getTheCalendarValue(3);
    }

    public int dayOfYear() {
        return this.getTheCalendarValue(6);
    }

    public int dayOfWeek() {
        return (this.getTheCalendarValue(7) + 5) % 7 + 1;
    }

    public void setFirstOfMonth(DateTimeValue v) {
        this.set(v);
        this.setDay(1);
    }

    public void setLastOfMonth(DateTimeValue v) {
        this.set(v);
        int lastDay = this.getTheCalendarValue().getActualMaximum(5);
        this.setDay(lastDay);
    }

    protected static String truncateNanosecondPrecision(String value) {
        int pos;
        String time = value;
        int dotPos = time.indexOf(46);
        if (dotPos != -1 && (pos = dotPos + 3 + 1) < time.length()) {
            return time.substring(0, pos);
        }
        return value;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.getTheCalendarValue().equals(((DateTimeValue)otherValue).getTheCalendarValue()) && this.getNanoseconds() == ((DateTimeValue)otherValue).getNanoseconds();
        }
        return result;
    }

    public static DateTimeValue minimum(DateTimeValue v1, DateTimeValue v2) {
        if (v1.compareTo(v2) <= 0) {
            return v1;
        }
        return v2;
    }

    public static DateTimeValue maximum(DateTimeValue v1, DateTimeValue v2) {
        if (v1.compareTo(v2) >= 0) {
            return v1;
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJSONLiteral() {
        String string;
        String date = (String)this.toJSON();
        StringWriter writer = new StringWriter();
        Serializer srl = new Serializer((Writer)writer);
        try {
            if (this.isNull()) {
                srl.writeNull().flush();
            } else {
                srl.writeString(date).flush();
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                srl.close();
                writer.close();
                srl = null;
                writer = null;
                throw throwable;
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
            }
        }
        srl.close();
        writer.close();
        srl = null;
        writer = null;
        return string;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        if (this.getCalendar() != null) {
            ctx.data(this.getXSDLiteral());
        }
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.set(text);
        }
    }

    protected void clearTimeFromValue() {
        this.setHour(0);
        this.setMinute(0);
        this.setSecond(0);
        this.clearMillisecond();
    }

    public void set(int year, int month, int day, int hour, int minute, int second, int nano) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setNanoseconds(nano);
        this.setNotNull();
    }

    protected void setTime(int hour, int minute, int second, int nanos) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setNanoseconds(nanos);
        this.setNotNull();
    }

    protected void setDate(int year, int month, int day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setNotNull();
    }

    static {
        GC_VALUE.setFirstDayOfWeek(2);
        GC_VALUE.setMinimalDaysInFirstWeek(4);
        GC_VALUE.clear();
        includeDstInTimeZoneOffset = null;
        IntervalDayTimeType type = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_SECOND);
        ONE_SECOND = (Value)type.createValue();
        ONE_SECOND.set(ONE);
        type = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY);
        ONE_DAY = (Value)type.createValue();
        ONE_DAY.set(ONE);
    }
}

