/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IDivisible;
import com.cognos.xqe.data.values.IExtract;
import com.cognos.xqe.data.values.IMultiplicable;
import com.cognos.xqe.data.values.INegatable;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public abstract class IntervalValue
extends Value
implements IExtract,
IAddable,
ISubtractable,
IMultiplicable,
IDivisible,
INegatable {
    static final long serialVersionUID = -4231132006736867360L;
    protected int sign = 1;
    protected int[] fields;

    IntervalValue(IntervalType type, int nFields) {
        super(type);
        this.fields = new int[nFields];
    }

    public void zero() {
        this.sign = 1;
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = 0;
        }
        this.setNotNull();
    }

    @Override
    public void set(Object pObject) throws UnsupportedOperationException {
        if (pObject == null) {
            this.setNull();
        } else if (pObject instanceof String) {
            this.set((String)pObject);
        } else if (pObject instanceof IntervalColumnVector.IntervalStruct) {
            this.set((IntervalColumnVector.IntervalStruct)pObject);
        } else {
            super.set(pObject);
        }
    }

    public void abs() throws XQERuntimeException {
        if (!this.isOK()) {
            return;
        }
        if (this.isNull()) {
            return;
        }
        if (this.sign < 0) {
            this.sign = 1;
        }
    }

    public int getSign() {
        return this.sign;
    }

    @Override
    public void subtract(IValue value1, IValue value2) throws ValueArithmeticException {
        this.set(value1);
        this.subtract(value2);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.sign == ((IntervalValue)otherValue).sign;
        }
        return result;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        this.sign = iStream.readByte();
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        oStream.writeByte(this.sign);
    }

    @Override
    public Object getObject() {
        return this.getString();
    }

    public int[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    public void set(IntervalColumnVector.IntervalStruct iStruct) throws ValueConversionException {
        this.sign = iStruct.sign;
        System.arraycopy(iStruct.fields, 0, this.fields, 0, iStruct.fields.length);
        this.setNotNull();
    }

    @Override
    public short getShort(int precision, int scale) {
        IntegerValue v = DataValueFactory.createIntegerValue();
        v.set(this.getInteger(precision, scale));
        return v.getShort();
    }

    @Override
    public long getLong(int precision, int scale) {
        IntegerValue v = DataValueFactory.createIntegerValue();
        v.set(this.getInteger(precision, scale));
        return v.getLong();
    }

    @Override
    public float getFloat() {
        IntegerValue v = DataValueFactory.createIntegerValue();
        IntegerType it = DataTypeFactory.getIntegerType();
        v.set(this.getInteger(it.getPrecision(), it.getScale()));
        return v.getFloat();
    }

    @Override
    public double getDouble() {
        IntegerValue v = DataValueFactory.createIntegerValue();
        IntegerType it = DataTypeFactory.getIntegerType();
        v.set(this.getInteger(it.getPrecision(), it.getScale()));
        return v.getDouble();
    }
}

