/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.JSONType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.json.java.JSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class JSONValue
extends Value {
    private static final long serialVersionUID = 1L;
    public static final String JSON_NULL = "null";
    String value;

    JSONValue(JSONType pType) {
        super(pType);
    }

    public static boolean compliesJSONFormat(String v) throws IOException {
        JSON.parse((String)v);
        return true;
    }

    @Override
    public void set(Object object) {
        if (object == null) {
            this.setNull();
            return;
        }
        try {
            if (JSONValue.compliesJSONFormat(object.toString())) {
                this.value = object.toString();
                this.setNotNull();
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
        }
    }

    @Override
    public void set(String sValue) {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        try {
            if (JSONValue.compliesJSONFormat(sValue)) {
                this.value = sValue;
                this.setNotNull();
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
        }
    }

    @Override
    public void set(char[] cValue) {
        if (cValue == null) {
            this.setNull();
            return;
        }
        this.set(String.valueOf(cValue));
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        if (v == null) {
            this.setNull();
            return;
        }
        this.set(((JSONValue)v).getString());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String getSQLLiteral() {
        return null;
    }

    @Override
    public Object getObject() {
        return this;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        Value pValue = (Value)pObject;
        if (this.isNull()) {
            if (pValue.isNull()) {
                return 0;
            }
            return -1;
        }
        if (pValue.isNull()) {
            return 1;
        }
        return this.getString().compareTo(pValue.getString());
    }

    public boolean equals(Object pObject) {
        if (pObject == null) {
            return false;
        }
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public Object copy() {
        JSONValue v = DataValueFactory.createJSONValue();
        v.set(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
        } else {
            this.set(pValue.getString());
        }
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readUTF());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeUTF(this.toString());
        }
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String getJSONLiteral() {
        return this.getString();
    }

    @Override
    public Object toJSON() {
        return this.getJSONLiteral();
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

