/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.dom4j.Element;

public class LongValue
extends ExactNumericValue {
    static final long serialVersionUID = 7647274105530911872L;
    private static final int TEN = 10;
    protected long value;

    LongValue(LongType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(IValue v) {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null && theValue.isOK()) {
            this.value = theValue.getLong(19, this.dataType.getScale());
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        long a;
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        try {
            a = Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "long");
        }
        this.value = a;
        this.setNotNull();
    }

    @Override
    public void set(byte bValue) {
        this.value = bValue;
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        this.value = sValue;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) {
        this.value = lValue;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) throws ValueConversionException {
        if (dValue == null) {
            this.setNull();
        } else {
            if (dValue.compareTo(DecimalValue.DEC2LONG_UPPERBOUND) == 1 || dValue.compareTo(DecimalValue.DEC2LONG_LOWERBOUND) == -1) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", dValue.toString(), "long");
            }
            BigDecimal bd = LongValue.cast(dValue, this.dataType.getPrecision(), this.dataType.getScale(), RoundingMode.DOWN);
            this.value = bd.unscaledValue().longValue();
            this.setNotNull();
        }
    }

    @Override
    public void set(float fValue) throws ValueConversionException {
        if (fValue > 9.223372E18f || fValue < -9.223372E18f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(fValue), "long");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? (long)((double)fValue * MathUtil.pow10(scale)) : (long)fValue;
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        if (dValue > 9.223372036854776E18 || dValue < -9.223372036854776E18) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(dValue), "long");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? Math.round(dValue * MathUtil.pow10(scale)) : (long)dValue;
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        int scale = this.dataType.getScale();
        String result = scale == 0 ? this.getUnscaledString() : (scale < 0 ? new BigInteger(String.valueOf(this.value * (long)MathUtil.pow10(-scale))).toString() : Double.toString((double)this.value / MathUtil.pow10(scale)));
        return result;
    }

    @Override
    public short getShort(int precision, int scale) {
        long temp = this.getLong(precision, scale);
        if (temp > 32767L || temp < -32768L) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "long", Long.toString(this.value), "smallint");
        }
        return (short)temp;
    }

    @Override
    public int getInteger(int precision, int scale) {
        long temp = this.getLong(precision, scale);
        if (temp > Integer.MAX_VALUE || temp < Integer.MIN_VALUE) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "long", Long.toString(this.value), "integer");
        }
        return (int)temp;
    }

    @Override
    public long getLong(int precision, int scale) {
        int diff = scale - this.dataType.getScale();
        if (diff == 0 || this.value == 0L) {
            return this.value;
        }
        if (diff > 0) {
            if (diff >= LONG_SCALE_VALUES.length || this.value > Long.MAX_VALUE / LONG_SCALE_VALUES[diff] || this.value < Long.MIN_VALUE / LONG_SCALE_VALUES[diff]) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "long", Long.toString(this.value), "long");
            }
            return this.value * LONG_SCALE_VALUES[diff];
        }
        if (-diff >= LONG_SCALE_VALUES.length) {
            return 0L;
        }
        return this.value / LONG_SCALE_VALUES[-diff];
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(this.value, this.getDataType().getScale());
        return LongValue.cast(bd, precision, scale);
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() {
        int scale = this.dataType.getScale();
        if (scale == 0) {
            return this.value;
        }
        return (double)this.value / MathUtil.pow10(scale);
    }

    @Override
    public Object copy() {
        LongValue v = new LongValue((LongType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value + otherLong;
        if (this.value > 0L == otherLong > 0L && result > 0L != this.value > 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "+", Long.toString(otherLong), "long");
        }
        this.value = result;
    }

    @Override
    public void subtract(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value - otherLong;
        if (this.value > 0L != otherLong > 0L && result > 0L != this.value > 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericUnderflowError, Long.toString(this.value), "-", Long.toString(otherLong), "long");
        }
        this.value = result;
    }

    @Override
    public void multiply(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value * otherLong;
        if (this.value != 0L && otherLong != result / this.value) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "*", Long.toString(otherLong), "long");
        }
        this.value = result;
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long denominator = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        if (denominator == 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        if (this.value == Long.MIN_VALUE && denominator == -1L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "/", "-1", "long");
        }
        this.value /= denominator;
    }

    @Override
    public void mod(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        if (otherLong != 0L) {
            this.value %= otherLong;
        }
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            if (this.value > 0L) {
                return 1;
            }
            if (this.value < 0L) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        long thisValue = this.value;
        long thatValue = 0L;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsNull && thatIsNull) {
            return 0;
        }
        if (thisIsNull) {
            thatValue = pValue.getLong(this.dataType.getPrecision(), this.dataType.getScale());
            if (thatValue == 0L) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return 1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thisValue = 0L;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return 1;
                }
            }
        } else if (thatIsNull) {
            thisValue = this.value;
            if (thisValue == 0L) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return -1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thatValue = 0L;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return -1;
                }
            }
        } else {
            thisValue = this.value;
            thatValue = pValue.getLong(this.dataType.getPrecision(), this.dataType.getScale());
        }
        if (thisValue == thatValue) {
            return 0;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Long.hashCode(this.value);
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        LongValue a = (LongValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.value == a.getLong(this.dataType.getPrecision(), this.dataType.getScale())) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        if (n >= 0 || this.value == 0L) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        long mod = this.value % (long)shiftFactor;
        this.value -= mod;
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (n >= 0 || tmp == 0L) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int rounder = this.value > 0L ? 5 * (shiftFactor / 10) : -5 * (shiftFactor / 10);
        long mod = (tmp += (long)rounder) % (long)shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (n >= 0 || tmp == 0L) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        long mod = tmp % (long)shiftFactor;
        this.value = this.value > 0L ? tmp + (long)shiftFactor : (tmp -= mod) - (long)shiftFactor;
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (n >= 0 || tmp == 0L) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        long mod = tmp % (long)shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeLong(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readLong());
        }
    }

    @Override
    public String getUnscaledString() {
        return Long.toString(this.value);
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.LONG);
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0L;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((LongValue)otherValue).value;
        }
        return result;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Long.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Long.parseLong(text);
        }
    }

    @Override
    Number getScaledNumber() {
        if (this.getDataType().getScale() != 0) {
            return this.getBigDecimal();
        }
        return (Number)this.getObject();
    }

    @Override
    public Object toJSON() {
        return this.getScaledNumber();
    }
}

