/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.MapType;
import com.cognos.xqe.data.values.IElementRef;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class MapValue
extends Value
implements Map<Object, IValue>,
IElementRef {
    static final long serialVersionUID = 1L;
    private Map<Object, IValue> map = new HashMap<Object, IValue>();

    MapValue(MapType dType) {
        super(dType);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Object, IValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public IValue get(Object key) {
        return this.map.get(((Value)key).getObject());
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public IValue put(Object key, IValue value) {
        this.setNotNull();
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends IValue> arg0) {
        this.map.putAll(arg0);
    }

    @Override
    public IValue remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<IValue> values() {
        return this.map.values();
    }

    @Override
    public Object copy() {
        MapValue v = new MapValue((MapType)this.dataType);
        v.setState(this.getState());
        if (!v.isNull()) {
            for (Map.Entry<Object, IValue> entry : this.map.entrySet()) {
                v.put(entry.getKey(), entry.getValue());
            }
        }
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        MapValue pValue = (MapValue)iValue;
        this.setState(pValue.getState());
        if (pValue.isNull()) {
            return;
        }
        for (Map.Entry<Object, IValue> entry : pValue.map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("MAP(");
        Iterator<Map.Entry<Object, IValue>> it = this.map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i++ > 0) {
                builder.append(", ");
            }
            Map.Entry<Object, IValue> entry = it.next();
            builder.append(entry.getKey());
            builder.append(" -> ");
            builder.append(entry.getValue());
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        throw new IOException("Reading unknown type:" + this.getClass().getName());
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        throw new IOException("Writing unknown type:" + this.getClass().getName());
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        return false;
    }

    @Override
    public int compareTo(Object arg0) {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            return this.map.equals(obj);
        }
        return false;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

