/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.values.IMemberPropertyValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberNumericPropertyValue
extends IntegerValue
implements IMemberPropertyValue {
    static final long serialVersionUID = 1L;
    IMember member;

    public MemberNumericPropertyValue(IDataType aDataType) {
        super((IntegerType)aDataType);
    }

    @Override
    public IMember getMember() {
        return this.member;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int compareTo(Object o) {
        return super.compareTo(o);
    }

    @Override
    public Object copy() {
        IValue v = this.getDataType().createValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void set(IValue obj) {
        if (obj == null) {
            this.setNull();
            this.member = null;
        } else if (obj instanceof IMember) {
            this.set((IMember)obj);
        } else {
            MemberNumericPropertyValue src = (MemberNumericPropertyValue)obj;
            this.member = src.member != null ? (IMember)src.member.copy() : null;
            super.set(src);
            this.dataType = src.dataType;
        }
    }

    protected void set(IMember obj) {
        this.member = obj;
        if (this.dataType == LevelNumberType.LEVELNUMBERTYPE) {
            this.set(this.member.getLevel().getIndex());
        }
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            MemberNumericPropertyValue otherProperty = (MemberNumericPropertyValue)otherValue;
            if (this.member == null) {
                result = otherProperty.member == null;
            } else {
                this.member.equals(otherProperty.member);
            }
        }
        return result;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        boolean isNull = iStream.readBoolean();
        if (!isNull) {
            long memberKey = iStream.readLong();
            int levelIndex = iStream.readInt();
            MemberProxy memberProxy = new MemberProxy(context, memberKey, levelIndex);
            this.member = memberProxy;
        } else {
            this.member = null;
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        oStream.writeBoolean(this.member == null);
        if (this.member != null) {
            MetadataCacheKey memKey = context.cacheMember(this.member, null);
            int index = context.cacheLevel(this.member.getLevel());
            oStream.writeLong(memKey.getKeyValue());
            oStream.writeInt(index);
        }
    }
}

