/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IMemberPropertyValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;

public class MemberRSAPIValue
extends StringValue
implements IMemberPropertyValue {
    private static final long serialVersionUID = 3383554211870766854L;
    IMember member;

    public MemberRSAPIValue(Collator theCollator) {
        super(StringType.DEFAULTSTRINGTYPE, theCollator);
    }

    @Override
    public IMember getMember() {
        return this.member;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int compareTo(Object o) {
        return super.compareTo(o);
    }

    @Override
    public Object copy() {
        IValue v = DataValueFactory.createMemberRSAPIValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue value) {
        if (value == null) {
            this.setNull();
            this.member = null;
        } else if (value instanceof IMember) {
            IMember src = (IMember)value;
            this.member = (IMember)src.copy();
            super.set(this.member.getUniqueName());
        } else if (value instanceof IMemberPropertyValue) {
            IMember src = ((IMemberPropertyValue)((Object)value)).getMember();
            this.member = (IMember)src.copy();
            super.set(this.member.getUniqueName());
        }
    }

    @Override
    public void set(Object obj) {
        this.set((IMember)obj);
    }

    protected void set(IMember obj) {
        this.member = obj;
        super.set(this.member.getV5UniqueName());
    }

    public Value getBusinessKeyValue() {
        Value bk = this.member.getBusinessKeyValue();
        String businessKey = null;
        if (bk == null) {
            bk = DataValueFactory.createStringValue();
            businessKey = this.member.getUniqueName();
        } else {
            IMember m = this.member;
            while (m != null && m instanceof ContextMember) {
                m = ((ContextMember)m).getMember();
            }
            if (m != null && !(m instanceof MemberProxy)) {
                ArrayList<String> parts = new ArrayList<String>();
                for (IMember current = this.member; current != null; current = current.getParent()) {
                    Value businessKeyValue = current.getBusinessKeyValue();
                    if (businessKeyValue == null) continue;
                    parts.add(0, businessKeyValue.toString());
                }
                String[] nameParts = new String[parts.size()];
                parts.toArray(nameParts);
                bk = DataValueFactory.createStringValue();
                businessKey = UniqueNameGenerator.createUniqueName(nameParts);
            } else {
                businessKey = bk.toString();
            }
        }
        if (bk != null) {
            bk.set(UniqueNameParser.escapeSquareBrackets(businessKey));
        }
        return bk;
    }
}

