/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.ICollection;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.json.java.JSONArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class MultisetValue
extends Value
implements ICollection {
    static final long serialVersionUID = 1L;
    private static final String COMMA_SPACE = ", ";
    private static final String CLOSE_BRACKET = "]";
    private static final String OPEN_BRACKET = "[";
    private List<IValue> elements = new ArrayList<IValue>();
    private ResultSet resultSet;
    private String deferredUri;

    MultisetValue(MultisetType dType) {
        super(dType);
    }

    @Override
    public void set(Collection<IValue> aCollection) {
        this.elements.clear();
        this.elements.addAll(aCollection);
        this.setNotNull();
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        this.elements.clear();
        this.elements.addAll(((MultisetValue)v).elements);
        this.setNotNull();
    }

    public void setDeferredURI(String aUri) {
        this.deferredUri = aUri;
        this.setNotNull();
    }

    public void add(IValue element) {
        this.elements.add(element);
        this.setNotNull();
    }

    public void set(ResultSet aResultSet) {
        this.resultSet = aResultSet;
        this.setNotNull();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public MultisetValue getSet() {
        return new MultisetValue((MultisetType)this.dataType);
    }

    public IValue getElement() {
        return null;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public String getString() {
        if (this.deferredUri != null) {
            return this.deferredUri;
        }
        if (this.isNull() || this.elements.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(OPEN_BRACKET);
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i > 0) {
                builder.append(COMMA_SPACE);
            }
            builder.append(this.elements.get(i).toString());
        }
        builder.append(CLOSE_BRACKET);
        return builder.toString();
    }

    @Override
    public boolean containsKey(Object iValue) {
        return this.elements.contains(iValue);
    }

    public void clear() {
        this.elements.clear();
    }

    public MultisetValue union(boolean distinct, MultisetValue set) {
        throw new UnsupportedOperationException();
    }

    public MultisetValue except(boolean distinct, MultisetValue set) {
        throw new UnsupportedOperationException();
    }

    public MultisetValue intersect(boolean distinct, MultisetValue set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isASet() {
        return false;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        Value b = (Value)pObject;
        if (this.isNull() && b.isNull()) {
            return 0;
        }
        if (!this.isNull() && b.isNull()) {
            return 1;
        }
        if (this.isNull() && !b.isNull()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Object copy() {
        MultisetValue v = new MultisetValue((MultisetType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        MultisetValue pValue = (MultisetValue)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        this.elements = pValue.elements;
        this.deferredUri = pValue.deferredUri;
        this.setNotNull();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        int i;
        int size = iStream.readInt();
        IDataType dType = ((MultisetType)this.dataType).getElementType();
        if (this.elements.size() == 0 || this.elements.size() < size) {
            for (i = this.elements.size(); i < size; ++i) {
                Value value = (Value)dType.createValue();
                this.elements.add(value);
            }
        }
        for (i = 0; i < size; ++i) {
            ((IEncodable)((Object)this.elements.get(i))).decode(context, iStream);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeInt(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            ((IEncodable)((Object)this.elements.get(i))).encode(context, oStream);
        }
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        return false;
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.elements.iterator();
    }

    @Override
    public String toString() {
        if (this.deferredUri != null) {
            return this.deferredUri;
        }
        return this.getString();
    }

    @Override
    public Object toJSON() {
        JSONArray jArray = new JSONArray();
        for (IValue element : this.elements) {
            jArray.add(element.toJSON());
        }
        return jArray;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

