/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.dom4j.Element;

public class SmallDecimalValue
extends DecimalValue {
    static final long serialVersionUID = 8966504082800168934L;
    private long value;
    private static final String ONE = "1";
    private static final String BAD_SCALE = "scale < 0";
    private static final String NEGATIVE_ONE = "-1";
    private static final long[] CACHEDUPPERPRECISION = SmallDecimalValue.initCachedDecimalMaxes(1);
    private static final long[] CACHEDLOWERPRECISION = SmallDecimalValue.initCachedDecimalMaxes(-1);

    private static long[] initCachedDecimalMaxes(int sign) {
        long[] b = new long[19];
        for (int i = 0; i <= 18; ++i) {
            b[i] = SmallDecimalValue.createLargestUnscaledLongValue(i, sign);
        }
        return b;
    }

    private static long createLargestUnscaledLongValue(int precision, int sign) {
        StringBuilder buf = new StringBuilder();
        if (sign == 1) {
            buf.append(ONE);
        } else {
            buf.append(NEGATIVE_ONE);
        }
        for (int i = 1; i <= precision; ++i) {
            buf.append("0").toString();
        }
        return Long.parseLong(buf.toString());
    }

    private boolean notWithinRange(long aValue) {
        return aValue >= CACHEDUPPERPRECISION[this.getPrecision()] || aValue <= CACHEDLOWERPRECISION[this.getPrecision()];
    }

    private long checkRange(long tmp) {
        if (this.notWithinRange(tmp)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, Long.toString(tmp), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
        return tmp;
    }

    private void checkRange(BigDecimal tmp) {
        int decMaxIndex = this.dataType.getPrecision() - this.dataType.getScale();
        if (BigDecimalValue.notWithinRange(decMaxIndex, tmp)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, tmp.toPlainString(), Integer.toString(this.getPrecision()), Integer.toString(this.getScale()));
        }
    }

    private String padOrTruncate(String fraction) {
        StringBuilder x = new StringBuilder(fraction);
        x.setLength(this.getScale());
        for (int i = 0; i < x.length(); ++i) {
            if (x.charAt(i) != '\u0000') continue;
            x.setCharAt(i, '0');
        }
        return x.toString();
    }

    private long getScaledValue(long unscaled) {
        int scale = this.getScale();
        if (scale < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, BAD_SCALE);
        }
        if (scale == 0) {
            return unscaled;
        }
        for (int i = 0; i < scale; ++i) {
            unscaled *= 10L;
        }
        return unscaled;
    }

    private long getScaledValue(double unscaled) {
        int scale = this.getScale();
        if (scale < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, BAD_SCALE);
        }
        if (scale == 0) {
            return (long)unscaled;
        }
        for (int i = 0; i < scale; ++i) {
            unscaled *= 10.0;
        }
        return Math.round(unscaled);
    }

    protected SmallDecimalValue(DecimalType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(IValue v) throws ValueConversionException {
        SmallDecimalValue sdv;
        super.set(v);
        Value theValue = (Value)v;
        if (theValue == null || !theValue.isOK()) {
            return;
        }
        int precision = this.getPrecision();
        int scale = this.getScale();
        if (theValue instanceof SmallDecimalValue && (sdv = (SmallDecimalValue)theValue).getPrecision() == precision && sdv.getScale() == scale) {
            this.value = sdv.value;
            return;
        }
        this.value = this.checkRange(theValue.getBigDecimal(precision, scale).unscaledValue().longValue());
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        long integral = 0L;
        long fraction = 0L;
        long negative = 1L;
        try {
            String[] values = sValue.split("\\.");
            if (values[0].indexOf(45) != -1) {
                values[0] = values[0].replace('-', ' ');
                negative = -1L;
            }
            values[0] = values[0].replace('+', ' ').trim();
            if (values[0].compareTo("") != 0) {
                integral = Long.parseLong(values[0]);
            }
            if (values.length > 1) {
                values[1] = this.padOrTruncate(values[1]);
                fraction = Long.parseLong(values[1]);
            }
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "long");
        }
        long full = this.getScaledValue(integral);
        full = negative * (full + fraction);
        this.value = this.checkRange(full);
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        long x = this.getScaledValue(sValue);
        this.value = this.checkRange(x);
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        long x = this.getScaledValue(iValue);
        this.value = this.checkRange(x);
        this.setNotNull();
    }

    @Override
    public void set(long aValue) {
        long x = this.getScaledValue(aValue);
        this.value = this.checkRange(x);
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) throws ValueConversionException {
        if (dValue == null) {
            this.setNull();
            return;
        }
        if (dValue.compareTo(DecimalValue.DEC2LONG_UPPERBOUND) == 1 || dValue.compareTo(DecimalValue.DEC2LONG_LOWERBOUND) == -1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", dValue.toString(), "long");
        }
        if (dValue.scale() != this.getScale()) {
            dValue = dValue.setScale(this.getScale(), RoundingMode.HALF_DOWN);
        }
        this.value = dValue.unscaledValue().longValue();
        this.checkRange(dValue);
        this.setNotNull();
    }

    @Override
    public void set(float fValue) throws ValueConversionException {
        double x = this.getScaledValue(fValue);
        if (fValue > 9.223372E18f || fValue < -9.223372E18f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(fValue), "long");
        }
        this.value = this.checkRange((long)x);
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        if (dValue > 9.223372036854776E18 || dValue < -9.223372036854776E18) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Double.toString(dValue), "long");
        }
        long x = this.getScaledValue(dValue);
        this.value = this.checkRange(x);
        this.setNotNull();
    }

    public void setFromScaledValue(long scaledValue) {
        this.value = this.checkRange(scaledValue);
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.getBigDecimal(this.getPrecision(), this.getScale());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        int scale = this.dataType.getScale();
        String result = scale == 0 ? this.getUnscaledString() : BigDecimal.valueOf(this.value, this.getScale()).toPlainString();
        return result;
    }

    @Override
    public short getShort(int precision, int scale) {
        if (this.value > this.getScaledValue(32767L) || this.value < this.getScaledValue(-32768L)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "integer", Long.toString(this.value), "smallint");
        }
        if (scale == this.getScale()) {
            return (short)this.value;
        }
        return (short)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public int getInteger(int precision, int scale) {
        if (scale == this.getScale()) {
            return (int)this.value;
        }
        return (int)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public long getLong(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (long)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(this.value, this.getDataType().getScale());
        return SmallDecimalValue.cast(bd, precision, scale);
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() {
        int scale = this.dataType.getScale();
        if (scale == 0) {
            return this.value;
        }
        return (double)this.value / MathUtil.pow10(scale);
    }

    @Override
    public Object copy() {
        SmallDecimalValue v = new SmallDecimalValue((DecimalType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value + otherLong;
        if (this.value > 0L == otherLong > 0L && result > 0L != this.value > 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "+", Long.toString(otherLong), "long");
        }
        this.value = this.checkRange(result);
    }

    @Override
    public void subtract(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value - otherLong;
        if (this.value > 0L != otherLong > 0L && result > 0L != this.value > 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericUnderflowError, Long.toString(this.value), "-", Long.toString(otherLong), "long");
        }
        this.value = this.checkRange(result);
    }

    @Override
    public void multiply(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        boolean bIsExactNumericWithZeroScale = nValue.getDataType().isExactNumeric() && nValue.getDataType().getScale() == 0;
        long otherLong = bIsExactNumericWithZeroScale ? ((Value)nValue).getLong() : ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long result = this.value * otherLong;
        if (this.value != 0L && otherLong != result / this.value) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "*", Long.toString(otherLong), "decimal");
        }
        this.value = bIsExactNumericWithZeroScale ? this.checkRange(result) : this.checkRange((long)((double)result * MathUtil.pow10(-this.dataType.getScale())));
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long denominator = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        if (denominator == 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        if (this.value == Long.MIN_VALUE && denominator == -1L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Long.toString(this.value), "/", NEGATIVE_ONE, "long");
        }
        BigDecimal dividend = new BigDecimal(this.value);
        BigDecimal divisor = new BigDecimal(denominator);
        BigDecimal result = dividend.divide(divisor, this.dataType.getScale(), RoundingMode.DOWN);
        this.value = this.checkRange(result.unscaledValue().longValue());
    }

    @Override
    public void mod(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        if (otherLong != 0L) {
            this.value = this.checkRange(this.value % otherLong);
        }
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            if (this.value > 0L) {
                return 1;
            }
            if (this.value < 0L) {
                return -1;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Long.hashCode(this.value);
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsNull && thatIsNull) {
            return 0;
        }
        long thisValue = this.value;
        long thatValue = 0L;
        if (thisIsNull) {
            thatValue = pValue.getLong(this.dataType.getPrecision(), this.dataType.getScale());
            if (thatValue == 0L) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return 1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thisValue = 0L;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return 1;
                }
            }
        } else if (thatIsNull) {
            thisValue = this.value;
            if (thisValue == 0L) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return -1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thatValue = 0L;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return -1;
                }
            }
        } else {
            if (pValue.getDataType().getScale() > this.dataType.getScale()) {
                return -pValue.compareTo(this);
            }
            thisValue = this.value;
            thatValue = pValue.getLong(this.dataType.getPrecision(), this.dataType.getScale());
        }
        if (thisValue == thatValue) {
            return 0;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        return -1;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        LongValue a = (LongValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.value == a.getLong(this.dataType.getPrecision(), this.dataType.getScale())) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public int getPrecision() {
        return ((DecimalType)this.dataType).getPrecision();
    }

    @Override
    public int getScale() {
        return ((DecimalType)this.dataType).getScale();
    }

    @Override
    public void floor() {
        if (!this.isOK()) {
            return;
        }
        int divisor = 1;
        for (int i = 0; i < this.getScale(); ++i) {
            divisor *= 10;
        }
        if (divisor != 1) {
            long modulo = this.value % (long)divisor;
            this.value = modulo >= 0L ? (this.value -= modulo) : (this.value -= (long)divisor + modulo);
        }
    }

    @Override
    public void ceil() {
        if (!this.isOK()) {
            return;
        }
        int divisor = 1;
        for (int i = 0; i < this.getScale(); ++i) {
            divisor *= 10;
        }
        if (divisor != 1) {
            long modulo = this.value % (long)divisor;
            this.value = modulo > 0L ? (this.value += (long)divisor - modulo) : (this.value -= modulo);
        }
    }

    @Override
    public void trunc(int n) {
        int i;
        if (!this.isOK()) {
            return;
        }
        for (i = 0; i < this.getScale() - n; ++i) {
            this.value /= 10L;
        }
        for (i = 0; i < this.getScale() - n; ++i) {
            this.value *= 10L;
        }
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (tmp == 0L || n >= this.getScale()) {
            return;
        }
        n = this.getScale() - n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int rounder = this.value > 0L ? 5 * (shiftFactor / 10) : -5 * (shiftFactor / 10);
        long mod = (tmp += (long)rounder) % (long)shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (tmp == 0L || n >= this.getScale()) {
            return;
        }
        n = this.getScale() - n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        long mod = tmp % (long)shiftFactor;
        this.value = this.value > 0L ? tmp + (long)shiftFactor : (tmp -= mod) - (long)shiftFactor;
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        long tmp = this.value;
        if (tmp == 0L || n >= this.getScale()) {
            return;
        }
        n = this.getScale() - n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        long mod = tmp % (long)shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.value = iStream.readLong();
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeLong(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8;
    }

    @Override
    public String getUnscaledString() {
        return Long.toString(this.value);
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.SMALLDECIMAL);
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0L;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((SmallDecimalValue)otherValue).value;
        }
        return result;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

