/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.dom4j.Element;

public class SmallintValue
extends ExactNumericValue {
    static final long serialVersionUID = 7647274105530911872L;
    private short value;

    SmallintValue(SmallintType pType) {
        super(pType);
    }

    @Override
    public void set(IValue v) {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null && theValue.isOK()) {
            this.value = theValue.getShort(this.dataType.getPrecision(), this.dataType.getScale());
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        try {
            this.value = Short.parseShort(sValue);
        }
        catch (NumberFormatException e) {
            this.setState(ValueState.ERROR);
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "smallint");
        }
        this.setNotNull();
    }

    @Override
    public void set(byte bValue) {
        this.value = bValue;
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        this.value = sValue;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) throws ValueConversionException {
        if (iValue > Short.MAX_VALUE || iValue < Short.MIN_VALUE) {
            this.setState(ValueState.ERROR);
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "integer", Integer.toString(iValue), "smallint");
        }
        this.value = (short)iValue;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) throws ValueConversionException {
        if (lValue > Integer.MAX_VALUE || lValue < Integer.MIN_VALUE) {
            this.setState(ValueState.ERROR);
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "long", Long.toString(lValue), "smallint");
        }
        this.value = (short)lValue;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) throws ValueConversionException {
        if (dValue == null) {
            this.setNull();
        } else {
            if (dValue.compareTo(DecimalValue.DEC2INT_UPPERBOUND) != -1 || dValue.compareTo(DecimalValue.DEC2INT_LOWERBOUND) != 1) {
                this.setState(ValueState.ERROR);
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", dValue.toString(), "smallint");
            }
            BigDecimal bd = SmallintValue.cast(dValue, this.dataType.getPrecision(), this.dataType.getScale(), RoundingMode.DOWN);
            this.value = bd.unscaledValue().shortValue();
            this.setNotNull();
        }
    }

    @Override
    public void set(float fValue) throws ValueConversionException {
        if (fValue >= 32768.0f || fValue <= -32769.0f) {
            this.setState(ValueState.ERROR);
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(fValue), "smallint");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? (short)((double)fValue * MathUtil.pow10(scale)) : (short)fValue;
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        if (dValue >= 32768.0 || dValue <= -32769.0) {
            this.setState(ValueState.ERROR);
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(dValue), "smallint");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? (short)(dValue * MathUtil.pow10(scale)) : (short)dValue;
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        int scale = this.dataType.getScale();
        String result = scale == 0 ? Short.toString(this.value) : (scale < 0 ? Integer.toString(this.value * (int)MathUtil.pow10(-scale)) : Double.toString((double)this.value / MathUtil.pow10(scale)));
        return result;
    }

    @Override
    public short getShort(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (short)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public int getInteger(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (int)((double)this.value * Math.pow(10.0, scale - this.dataType.getScale()));
    }

    @Override
    public long getLong(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (long)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(this.value, this.getDataType().getScale());
        return SmallintValue.cast(bd, precision, scale);
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() {
        int scale = this.dataType.getScale();
        if (scale == 0) {
            return this.value;
        }
        return (double)this.value / MathUtil.pow10(scale);
    }

    @Override
    public Object copy() {
        SmallintValue v = new SmallintValue((SmallintType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        Short iValue = ((Value)nValue).getShort(this.dataType.getPrecision(), this.dataType.getScale());
        int l = this.value + iValue;
        if (l > Short.MAX_VALUE || l < Short.MIN_VALUE) {
            this.setState(ValueState.OVERFLOW);
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Short.toString(this.value), "+", Short.toString(iValue), "smallint");
        }
        this.value = (short)l;
    }

    @Override
    public void subtract(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        int l = this.value - ((Value)nValue).getShort(this.dataType.getPrecision(), this.dataType.getScale());
        if (l > Short.MAX_VALUE || l < Short.MIN_VALUE) {
            this.setState(ValueState.UNDERFLOW);
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericUnderflowError, Integer.toString(this.value), "-", Long.toString(((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale())), "smallint");
        }
        this.value = (short)l;
    }

    @Override
    public void multiply(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        int l = this.value * ((Value)nValue).getShort(this.dataType.getPrecision(), this.dataType.getScale());
        if (l > Short.MAX_VALUE || l < Short.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Integer.toString(this.value), "*", Long.toString(((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale())), "smallint");
        }
        this.value = (short)l;
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        int l = ((Value)nValue).getShort(this.dataType.getPrecision(), this.dataType.getScale());
        if (l == 0) {
            this.setState(ValueState.DIV_BY_ZERO);
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        if ((l = this.value / l) > Short.MAX_VALUE || l < Short.MIN_VALUE) {
            this.setState(ValueState.OVERFLOW);
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Integer.toString(this.value), "/", Long.toString(((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale())), "smallint");
        }
        this.value = (short)l;
    }

    @Override
    public void mod(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        int iValue = ((Value)nValue).getShort(this.dataType.getPrecision(), this.dataType.getScale());
        int l = iValue;
        if (l == 0) {
            return;
        }
        if ((l = this.value % l) > Short.MAX_VALUE || l < Short.MIN_VALUE) {
            this.setState(ValueState.OVERFLOW);
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Short.toString(this.value), "%", Integer.toString(iValue), "smallint");
        }
        this.value = (short)l;
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = (short)StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            if (this.value > 0) {
                return 1;
            }
            if (this.value < 0) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        short thisValue = this.value;
        short thatValue = 0;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (this.isNull() && pValue.isNull()) {
            return 0;
        }
        if (this.isNull()) {
            thatValue = pValue.getShort(this.dataType.getPrecision(), this.dataType.getScale());
            if (thatValue == 0) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return 1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thisValue = 0;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return -1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return 1;
                }
            }
        } else if (pValue.isNull()) {
            thisValue = this.value;
            if (thisValue == 0) {
                if (NullBehavior.ZERO_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.ZERO_LAST == nullHandling) {
                    return -1;
                }
            }
            if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
                thatValue = 0;
            } else {
                if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
                    return 1;
                }
                if (NullBehavior.NULL_LAST == nullHandling) {
                    return -1;
                }
            }
        } else {
            thisValue = this.value;
            thatValue = pValue.getShort(this.dataType.getPrecision(), this.dataType.getScale());
        }
        if (thisValue == thatValue) {
            return 0;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return this.value;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        SmallintValue a = (SmallintValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.value == a.getInteger(this.dataType.getPrecision(), this.dataType.getScale())) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        if (n >= 0 || this.value == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = this.value % shiftFactor;
        this.value = (short)(this.value - mod);
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        int tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int rounder = this.value > 0 ? 5 * (shiftFactor / 10) : -5 * (shiftFactor / 10);
        int mod = (tmp += rounder) % shiftFactor;
        this.value = (short)(tmp - mod);
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        int tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = tmp % shiftFactor;
        this.value = this.value > 0 ? (short)(tmp + shiftFactor) : (short)((tmp -= mod) - shiftFactor);
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        short tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = tmp % shiftFactor;
        this.value = (short)(tmp - mod);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readShort());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeShort(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 2;
    }

    @Override
    public String getUnscaledString() {
        return Short.toString(this.value);
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.SMALLINT);
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((SmallintValue)otherValue).value;
        }
        return result;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Short.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Short.parseShort(text);
        }
    }

    @Override
    Number getScaledNumber() {
        if (this.getDataType().getScale() != 0) {
            return this.getBigDecimal();
        }
        return (Number)this.getObject();
    }

    @Override
    public Object toJSON() {
        return this.getScaledNumber();
    }
}

