/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class TimeValue
extends DateTimeValue {
    static final long serialVersionUID = 1L;
    public static final Pattern TIME_PATTERN = Pattern.compile("[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?");
    public static final String TIME_FORMAT_NO_FRACTIONAL_SECONDS = "%1$02d:%2$02d:%3$02d";
    public static final String TIME_FORMAT_MILLISECONDS = "%1$02d:%2$02d:%3$02d.%4$03d";
    public static final String TIME_FORMAT_NANOSECONDS = "%1$02d:%2$02d:%3$02d.%4$09d";

    TimeValue(TimeType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        Matcher m = TIME_PATTERN.matcher(sValue);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "time");
        }
        String[] timeFields = sValue.split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split("\\.");
        int second = Integer.parseInt(timeFields[0]);
        int nano = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(ZEROS[9 - timeFields[1].length()]);
            nano = Integer.parseInt(tmpBuf.toString());
        }
        this.setTime(hour, minute, second, nano);
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        TimeValue tValue = (TimeValue)v;
        this.setTime(tValue.getHour(), tValue.getMinute(), tValue.getSecond(), tValue.getNanoseconds());
        this.copyFormatIdFrom(tValue);
    }

    @Override
    public void set(Object pObject) {
        if (pObject == null) {
            this.setNull();
        } else if (pObject instanceof TimestampColumnVector.UnixTimestamp) {
            this.set((TimestampColumnVector.UnixTimestamp)pObject);
        } else if (pObject instanceof Time) {
            this.set((Time)pObject);
        } else if (pObject instanceof LocalTime) {
            this.set((LocalTime)pObject);
        } else if (pObject instanceof OffsetTime) {
            this.set((OffsetTime)pObject);
        } else if (pObject instanceof LocalDateTime) {
            this.set((LocalDateTime)pObject);
        } else if (pObject instanceof OffsetDateTime) {
            this.set((OffsetDateTime)pObject);
        } else if (pObject instanceof String) {
            this.set((String)pObject);
        } else {
            super.set(pObject);
        }
    }

    public void set(Time tv) {
        if (tv == null) {
            this.setNull();
            return;
        }
        this.set(tv.getTime());
        this.setNotNull();
    }

    @Override
    public void set(LocalTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.setTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    @Override
    public void set(OffsetTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.set(time.toLocalTime());
    }

    @Override
    public void set(LocalDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.set(dateTime.toLocalTime());
    }

    @Override
    public void set(OffsetDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.set(dateTime.toLocalTime());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.getNanoseconds() > 0) {
            return String.format(TIME_FORMAT_NANOSECONDS, this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
        }
        return String.format(TIME_FORMAT_NO_FRACTIONAL_SECONDS, this.getHour(), this.getMinute(), this.getSecond());
    }

    @Override
    public String getXSDLiteral() {
        return this.getString();
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "TIME '" + this.getString() + "'";
    }

    @Override
    public String getV5Literal() {
        return this.getString();
    }

    @Override
    public String getJDBCLiteral() {
        if (this.isNull()) {
            return null;
        }
        String time = TimeValue.truncateNanosecondPrecision(this.getString());
        return "{t '" + time + "'}";
    }

    @Override
    public String getSPARQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return String.format("'%s'^^xsd:time", this.getString());
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        String literal = String.format(formatSpec, this.getHour(), this.getMinute(), this.getSecond(), TimeValue.convertNanosToFractionalString(this.getNanoseconds()));
        return literal;
    }

    public Timestamp getTimestamp(XDataContext context) {
        if (this.isNull()) {
            return null;
        }
        TimestampValue t = DataValueFactory.createTimestampValue();
        t.setNotNull();
        t.set(context.getExecutionTime());
        t.setTime(this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
        return t.getTimestamp();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.getMilliseconds());
    }

    @Override
    public void add(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue i = (IntervalDayTimeValue)pValue;
            this.addHours(i.getSign() * i.getHour());
            this.addMinutes(i.getSign() * i.getMinute());
            this.addSeconds(i.getSign() * i.getSecond());
            this.addNanoSeconds(i.getSign() * i.getNanoseconds());
        }
    }

    @Override
    public void subtract(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue i = (IntervalDayTimeValue)pValue;
            this.subtractHours(i.getSign() * i.getHour());
            this.subtractMinutes(i.getSign() * i.getMinute());
            this.subtractSeconds(i.getSign() * i.getSecond());
            this.subtractNanoSeconds(i.getSign() * i.getNanoseconds());
        }
    }

    @Override
    public DateTimeValue next() throws SQLException {
        TimeValue result = (TimeValue)this.copy();
        result.add(ONE_SECOND);
        return result;
    }

    @Override
    public DateTimeValue prior() throws SQLException {
        TimeValue result = (TimeValue)this.copy();
        result.subtract(ONE_SECOND);
        return result;
    }

    @Override
    public Object copy() {
        TimeValue v = new TimeValue((TimeType)this.dataType);
        v.set(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (pValue instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)pValue;
            this.setTime(dValue.getHour(), dValue.getMinute(), dValue.getSecond(), dValue.getNanoseconds());
        } else {
            this.set(pValue.getString());
        }
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readLong());
            this.setNanoseconds(iStream.readInt());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeLong(this.getMilliseconds());
            oStream.writeInt(this.getNanoseconds());
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8 + 4;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.TIME);
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        if (this.getNanoseconds() > 0) {
            return String.format(TIME_FORMAT_MILLISECONDS, this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds() / 1000000);
        }
        return String.format(TIME_FORMAT_NO_FRACTIONAL_SECONDS, this.getHour(), this.getMinute(), this.getSecond());
    }
}

