/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeWithTZValue
extends TimeValue {
    static final long serialVersionUID = 1L;
    private static final String GMT = "GMT";
    public static final Pattern PATTERN = Pattern.compile("[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?((\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?)?");

    TimeWithTZValue(TimeWithTZType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null) {
            this.setNull();
            return;
        }
        Matcher m = PATTERN.matcher(sValue);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "time with time zone");
        }
        int sign = 1;
        if (sValue.indexOf("-") > 0) {
            sign = -1;
        }
        String[] list = sValue.split("\\+|-");
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split("\\.");
        int second = Integer.parseInt(timeFields[0]);
        int nano = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(ZEROS[9 - timeFields[1].length()]);
            nano = Integer.parseInt(tmpBuf.toString());
        }
        boolean utcTime = false;
        int tzHour = 0;
        int tzMinute = 0;
        if (list.length == 1) {
            utcTime = true;
        }
        if (!utcTime) {
            String[] timeZoneFields = list[1].split(":");
            tzHour = Integer.parseInt(timeZoneFields[0]);
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
        }
        int rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
        String timeZoneID = TimeWithTZValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
        this.setTimeZone(new SimpleTimeZone(rawOffset, timeZoneID));
        this.setTime(hour, minute, second, nano);
    }

    public static String createCustomTimeZoneID(int sign, int tzHour, int tzMinute) {
        StringBuilder sb = new StringBuilder();
        sb.append(GMT);
        if (sign > 0) {
            sb.append("+");
        } else {
            sb.append("-");
        }
        sb.append(tzHour);
        sb.append(":");
        sb.append(tzMinute);
        return sb.toString();
    }

    public static String createCustomTimeZoneID(int offset) {
        int sign = 1;
        if (offset < 0) {
            sign = -1;
            offset = -offset;
        }
        int tzHour = offset / 3600000;
        int tzMinute = offset % 3600000 / 60000;
        return TimeWithTZValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
    }

    @Override
    public void set(TimestampColumnVector.UnixTimestamp ts) {
        this.set(ts.milliseconds);
        this.setNanoseconds(ts.nanoseconds);
        this.setTimeZone(ts.timeZoneOffset);
    }

    @Override
    public void set(OffsetTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.setTimeZone(time.getOffset().getTotalSeconds() * 1000);
        this.setTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    @Override
    public void set(OffsetDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.setTimeZone(dateTime.getOffset().getTotalSeconds() * 1000);
        this.setTime(dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano());
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        TimeWithTZValue tValue = (TimeWithTZValue)v;
        this.setTimeZone(tValue.getTimeZone());
        this.set(tValue.getMilliseconds());
        this.setNanoseconds(tValue.getNanoseconds());
        this.copyFormatIdFrom(tValue);
    }

    public void set(Time tv, TimeZone tz) {
        if (tv == null) {
            this.setNull();
            return;
        }
        this.setTimeZone(tz);
        TimeValue temp = DataValueFactory.createTimeValue();
        temp.set(tv.getTime());
        this.setTime(temp.getHour(), temp.getMinute(), temp.getSecond(), temp.getNanoseconds());
    }

    @Override
    public Timestamp getTimestamp(XDataContext context) {
        if (this.isNull()) {
            return null;
        }
        TimestampValue tmpValue = DataValueFactory.createTimestampValue();
        tmpValue.set(context.getExecutionTime());
        TimestampValue t = DataValueFactory.createTimestampValue();
        t.setTimeZone(this.getTimeZone());
        t.set(tmpValue.getYear(), tmpValue.getMonth(), tmpValue.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
        return t.getTimestamp();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.getString());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public String getXSDLiteral() {
        return this.getString();
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.toJSON());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "TIME '" + this.getString() + "'";
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        char tzSign;
        if (this.isNull()) {
            return null;
        }
        int tzHour = this.getTimeZoneHour();
        if (tzHour < 0) {
            tzSign = '-';
            tzHour = -tzHour;
        } else {
            tzSign = '+';
        }
        String lit = String.format(formatSpec, this.getHour(), this.getMinute(), this.getSecond(), TimeWithTZValue.convertNanosToFractionalString(this.getNanoseconds()), tzHour, Math.abs(this.getTimeZoneMinute()), Character.valueOf(tzSign));
        return lit;
    }

    @Override
    public Object copy() {
        TimeWithTZValue v = new TimeWithTZValue((TimeWithTZType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (pValue instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)pValue;
            this.setTimeZone(dValue.getTimeZone());
            this.set(dValue.getTime());
            this.setNanoseconds(dValue.getNanoseconds());
        } else {
            this.set(pValue.getString());
        }
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            int rawOffset = iStream.readInt();
            SimpleTimeZone timeZone = null;
            String[] ids = TimeZone.getAvailableIDs(rawOffset);
            String timeZoneID = ids.length == 0 ? TimeWithTZValue.createCustomTimeZoneID(rawOffset) : ids[0];
            timeZone = new SimpleTimeZone(rawOffset, timeZoneID);
            this.getHour();
            this.setTimeZone(timeZone);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeInt(this.getTimeZone().getRawOffset());
        }
    }

    public static int getEncodedSize() {
        return TimeValue.getEncodedSize() + 4 + 1 + 4;
    }
}

