/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampValue
extends DateTimeValue {
    static final long serialVersionUID = 1L;
    public static final Pattern PATTERN = Pattern.compile("[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+((\\s|T)[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?)?");

    TimestampValue(TimestampType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        if (v instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)v;
            this.set(dValue.getMilliseconds());
            this.setNanoseconds(dValue.getNanoseconds());
            this.copyFormatIdFrom(dValue);
        } else {
            super.set(v);
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.isEmpty()) {
            this.setNull();
            return;
        }
        Matcher m = PATTERN.matcher(sValue);
        if (m.matches()) {
            sValue = sValue.replace('T', ' ');
            String[] list = sValue.split(" ");
            String[] dateFields = list[0].split("-");
            int year = Integer.parseInt(dateFields[0]);
            int month = Integer.parseInt(dateFields[1]);
            int day = Integer.parseInt(dateFields[2]);
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nano = 0;
            if (list.length > 1) {
                String[] timeFields = list[1].split(":");
                hour = Integer.parseInt(timeFields[0]);
                minute = Integer.parseInt(timeFields[1]);
                timeFields = timeFields[2].split("\\.");
                second = Integer.parseInt(timeFields[0]);
                if (timeFields.length > 1) {
                    StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
                    tmpBuf.append(ZEROS[9 - timeFields[1].length()]);
                    nano = Integer.parseInt(tmpBuf.toString());
                }
            }
            this.set(year, month, day, hour, minute, second, nano);
        } else {
            try {
                super.set(sValue);
            }
            catch (ValueConversionException e) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "timestamp");
            }
        }
        this.setNotNull();
    }

    @Override
    public void set(LocalDate date) {
        if (null == date) {
            this.setNull();
            return;
        }
        this.clear();
        this.setDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @Override
    public void set(LocalTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.clear();
        this.setTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    @Override
    public void set(OffsetTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.set(time.toLocalTime());
    }

    @Override
    public void set(LocalDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.clear();
        this.set(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano());
    }

    @Override
    public void set(OffsetDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.set(dateTime.toLocalDateTime());
    }

    @Override
    public void set(Object pObject) {
        if (pObject == null) {
            this.setNull();
        } else if (pObject instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)pObject;
            if (dValue.isNull()) {
                this.setNull();
                return;
            }
            this.set(dValue.getMilliseconds());
            this.setNanoseconds(dValue.getNanoseconds());
            this.copyFormatIdFrom(dValue);
        } else if (pObject instanceof Long) {
            this.set(pObject);
        } else if (pObject instanceof String) {
            this.set((String)pObject);
        } else if (pObject instanceof Timestamp) {
            this.set((Timestamp)pObject);
        } else if (pObject instanceof TimestampColumnVector.UnixTimestamp) {
            this.set((TimestampColumnVector.UnixTimestamp)pObject);
        } else if (pObject instanceof LocalDateTime) {
            this.set((LocalDateTime)pObject);
        } else if (pObject instanceof OffsetDateTime) {
            this.set((OffsetDateTime)pObject);
        } else if (pObject instanceof LocalDate) {
            this.set((LocalDate)pObject);
        } else if (pObject instanceof LocalTime) {
            this.set((LocalTime)pObject);
        } else if (pObject instanceof OffsetTime) {
            this.set((OffsetTime)pObject);
        } else {
            super.set(pObject);
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.getNanoseconds() > 0) {
            return this.getStringTimestampWithNanoseconds();
        }
        return String.format("%1$04d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }

    public String getStringWithNanoseconds() {
        return this.getStringTimestampWithNanoseconds();
    }

    final String getStringTimestampWithNanoseconds() {
        if (this.isNull()) {
            return null;
        }
        return String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$09d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds());
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public String getV5Literal() {
        return this.getString();
    }

    @Override
    public String getJDBCLiteral() {
        if (this.isNull()) {
            return null;
        }
        String timestamp = TimestampValue.truncateNanosecondPrecision(this.getString());
        return "{ts '" + timestamp + "'}";
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        Timestamp ts = new Timestamp(0L);
        ts.setTime(this.getMilliseconds());
        ts.setNanos(this.getNanoseconds());
        return ts;
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        String lit = String.format(formatSpec, this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), TimestampValue.convertNanosToFractionalString(this.getNanoseconds()));
        return lit;
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public void add(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalYearMonthType) {
            IntervalYearMonthValue ymv = (IntervalYearMonthValue)pValue;
            this.addYears(ymv.getSign() * ymv.getYear());
            this.addMonths(ymv.getSign() * ymv.getMonth());
        } else if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue dtv = (IntervalDayTimeValue)pValue;
            this.addDays(dtv.getSign() * dtv.getDay());
            this.addHours(dtv.getSign() * dtv.getHour());
            this.addMinutes(dtv.getSign() * dtv.getMinute());
            this.addSeconds(dtv.getSign() * dtv.getSecond());
            this.addNanoSeconds(dtv.getSign() * dtv.getNanoseconds());
        }
    }

    @Override
    public void subtract(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalYearMonthType) {
            IntervalYearMonthValue ymv = (IntervalYearMonthValue)pValue;
            this.subtractYears(ymv.getSign() * ymv.getYear());
            this.subtractMonths(ymv.getSign() * ymv.getMonth());
        } else if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue dtv = (IntervalDayTimeValue)pValue;
            this.subtractDays(dtv.getSign() * dtv.getDay());
            this.subtractHours(dtv.getSign() * dtv.getHour());
            this.subtractMinutes(dtv.getSign() * dtv.getMinute());
            this.subtractSeconds(dtv.getSign() * dtv.getSecond());
            this.subtractNanoSeconds(dtv.getSign() * dtv.getNanoseconds());
        }
    }

    @Override
    public DateTimeValue next() throws SQLException {
        TimestampValue result = (TimestampValue)this.copy();
        result.add(ONE_SECOND);
        return result;
    }

    @Override
    public DateTimeValue prior() throws SQLException {
        TimestampValue result = (TimestampValue)this.copy();
        result.subtract(ONE_SECOND);
        return result;
    }

    @Override
    public Object copy() {
        TimestampValue v = new TimestampValue((TimestampType)this.dataType);
        v.set(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (pValue instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)pValue;
            this.set(dValue.getYear(), dValue.getMonth(), dValue.getDay(), dValue.getHour(), dValue.getMinute(), dValue.getSecond(), dValue.getNanoseconds());
        } else {
            this.set(pValue.getString());
        }
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void copyFrom(XDataContext context, IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (!(pValue instanceof TimeValue)) {
            throw new UnsupportedOperationException();
        }
        TimeValue tValue = (TimeValue)pValue;
        DateTimeValue dValue = context.getExecutionTime();
        this.set(dValue.getYear(), dValue.getMonth(), dValue.getDay(), tValue.getHour(), tValue.getMinute(), tValue.getSecond(), tValue.getNanoseconds());
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readLong());
            this.setNanoseconds(iStream.readInt());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeLong(this.getMilliseconds());
            oStream.writeInt(this.getNanoseconds());
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8 + 4;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.TIMESTAMP);
    }

    public static Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        if (this.getNanoseconds() > 0) {
            return String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d.%7$03d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoseconds() / 1000000);
        }
        return String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }
}

