/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampWithTZValue
extends TimestampValue {
    static final long serialVersionUID = 1L;
    private static final String GMT = "GMT";
    public static final Pattern PATTERN = Pattern.compile("[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+(\\s|T)[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?((\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?|Z)?");

    TimestampWithTZValue(TimestampWithTZType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(TimestampColumnVector.UnixTimestamp ts) {
        this.set(ts.milliseconds);
        this.setNanoseconds(ts.nanoseconds);
        this.setTimeZone(ts.timeZoneOffset);
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        TimestampWithTZValue tValue = (TimestampWithTZValue)v;
        this.setTimeZone(tValue.getTimeZone());
        this.set(tValue.getMilliseconds());
        this.setNanoseconds(tValue.getNanoseconds());
        this.copyFormatIdFrom(tValue);
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null) {
            this.setNull();
            return;
        }
        Matcher m = PATTERN.matcher(sValue);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "timestamp with time zone");
        }
        sValue = sValue.replace('T', ' ');
        String[] list = sValue.split(" ");
        String[] dateFields = list[0].split("-");
        int year = Integer.parseInt(dateFields[0]);
        int month = Integer.parseInt(dateFields[1]);
        int day = Integer.parseInt(dateFields[2]);
        int sign = 1;
        if (list[1].indexOf("-") > 0) {
            sign = -1;
        }
        boolean utcTime = false;
        if ((list = list[1].split("\\+|-")).length == 1) {
            utcTime = true;
        }
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split("\\.");
        int second = Integer.parseInt(timeFields[0]);
        int nano = 0;
        if (timeFields.length > 1) {
            String nanoSecsStr = timeFields[1];
            if (nanoSecsStr.indexOf(90) > 0) {
                nanoSecsStr = nanoSecsStr.substring(0, nanoSecsStr.length() - 1);
                utcTime = true;
            }
            StringBuilder tmpBuf = new StringBuilder(nanoSecsStr);
            tmpBuf.append(ZEROS[9 - nanoSecsStr.length()]);
            nano = Integer.parseInt(tmpBuf.toString());
        }
        int tzHour = 0;
        int tzMinute = 0;
        if (!utcTime) {
            String[] timeZoneFields = list[1].split(":");
            tzHour = Integer.parseInt(timeZoneFields[0]);
            tzMinute = 0;
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
        }
        int rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
        String timeZoneID = TimeWithTZValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
        this.setTimeZone(new SimpleTimeZone(rawOffset, timeZoneID));
        this.set(year, month, day, hour, minute, second, nano);
    }

    public void set(Timestamp tv, TimeZone tz) {
        if (tv == null) {
            this.setNull();
            return;
        }
        TimestampValue temp = DataValueFactory.createTimestampValue();
        temp.set(tv);
        this.setTimeZone(tz);
        this.set(temp.getYear(), temp.getMonth(), temp.getDay(), temp.getHour(), temp.getMinute(), temp.getSecond(), temp.getNanoseconds());
    }

    @Override
    public void set(LocalDate date) {
        if (null == date) {
            this.setNull();
            return;
        }
        this.clear();
        this.setDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @Override
    public void set(OffsetTime time) {
        if (null == time) {
            this.setNull();
            return;
        }
        this.clear();
        this.setTimeZone(time.getOffset().getTotalSeconds() * 1000);
        this.setTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    @Override
    public void set(OffsetDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.clear();
        this.setTimeZone(dateTime.getOffset().getTotalSeconds() * 1000);
        this.set(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.getString());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public String getStringWithNanoseconds() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.getStringWithNanoseconds());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        char tzSign;
        if (this.isNull()) {
            return null;
        }
        int tzHour = this.getTimeZoneHour();
        if (tzHour < 0) {
            tzSign = '-';
            tzHour = -tzHour;
        } else {
            tzSign = '+';
        }
        String lit = String.format(formatSpec, this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), TimestampWithTZValue.convertNanosToFractionalString(this.getNanoseconds()), tzHour, Math.abs(this.getTimeZoneMinute()), Character.valueOf(tzSign));
        return lit;
    }

    @Override
    public String getXSDLiteral() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.getXSDLiteral());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(super.toJSON());
        b.append(this.convertTimeZoneToString());
        return b.toString();
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public String getV5Literal() {
        return this.getString();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public Object copy() {
        TimestampWithTZValue v = new TimestampWithTZValue((TimestampWithTZType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (pValue instanceof DateTimeValue) {
            DateTimeValue dValue = (DateTimeValue)pValue;
            this.setTimeZone(dValue.getTimeZone());
            this.set(dValue.getTimestamp());
            this.setNanoseconds(dValue.getNanoseconds());
        } else {
            this.set(pValue.getString());
        }
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void copyFrom(XDataContext context, IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        if (!(pValue instanceof TimeValue)) {
            throw new UnsupportedOperationException();
        }
        TimeValue dValue = (TimeValue)pValue;
        this.setTimeZone(dValue.getTimeZone());
        this.set(dValue.getTimestamp(context));
        this.setNanoseconds(dValue.getNanoseconds());
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            int rawOffset = iStream.readInt();
            SimpleTimeZone timeZone = null;
            String[] ids = TimeZone.getAvailableIDs(rawOffset);
            String timeZoneID = ids.length == 0 ? TimeWithTZValue.createCustomTimeZoneID(rawOffset) : ids[0];
            timeZone = new SimpleTimeZone(rawOffset, timeZoneID);
            this.getHour();
            this.setTimeZone(timeZone);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeInt(this.getTimeZone().getRawOffset());
        }
    }

    public static int getEncodedSize() {
        return TimestampValue.getEncodedSize() + 4 + 1 + 4;
    }

    public TimestampWithTZValue getGMTValue() {
        TimestampWithTZValue val = DataValueFactory.createTimestampWithTZValue();
        TimeZone timeZone = null;
        timeZone = TimeZone.getTimeZone(GMT);
        val.setTimeZone(timeZone);
        val.set(this.getDate());
        int tzHour = this.getTimeZoneHour();
        int tzMinute = this.getTimeZoneMinute();
        this.addHours(tzHour);
        this.addMinutes(tzMinute);
        return val;
    }

    public TimestampWithTZValue getLocalTimezoneValue() {
        int origTZHour = this.getTimeZoneHour();
        int origTZMinute = this.getTimeZoneMinute();
        TimestampWithTZValue val = DataValueFactory.createTimestampWithTZValue();
        val.set(this.getDate());
        int newTZHour = val.getTimeZoneHour();
        int newTZMinute = val.getTimeZoneMinute();
        this.addHours(origTZHour - newTZHour);
        this.addMinutes(origTZMinute - newTZMinute);
        return val;
    }
}

