/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.TextValue;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ValueSizeInfo {
    private static final boolean ISSUNJAVA = ValueSizeInfo.isSunJava();
    private static final boolean ISIBMJAVA = ValueSizeInfo.isIBMJava();
    private static final boolean ISJAVA6 = ValueSizeInfo.isJava6();
    private static final boolean ISJVM64BIT = ValueSizeInfo.isJVM64Bit();
    private static final boolean IS_OBJECT_REFERENCED_COMPRESSED = ValueSizeInfo.isObjectReferencedCompressionsSpecified();
    private static Map<String, Integer> entries = new HashMap<String, Integer>();
    private static final String BASE_CONFIG = "queryExecution.SizeOf";
    private static final int MASK = -8;
    private static final int C1 = 1;
    private static final int C2 = 2;
    private static final int C3 = 3;
    private static final int C7 = 7;
    private static final int C8 = 8;
    private static final String THIRTY_TWO = "32";
    private static final String SIXTY_FOUR = "64";
    private static final String SIXTY_FOUR_X = "64x";
    private static final String DOT = ".";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VERSION = "java.version";

    private static boolean isSunJava() {
        String vendor = System.getProperty(JAVA_VENDOR);
        return vendor.contains("Sun") || vendor.contains("Oracle");
    }

    private static boolean isIBMJava() {
        String vendor = System.getProperty(JAVA_VENDOR);
        return vendor.contains("IBM");
    }

    private static boolean isJava6() {
        String version = System.getProperty(JAVA_VERSION);
        return version.startsWith("1.6");
    }

    private static boolean isJVM64Bit() {
        String jvmBitSize = System.getProperty("sun.arch.data.model");
        return jvmBitSize.equals(SIXTY_FOUR);
    }

    private static boolean isObjectReferencedCompressionsSpecified() {
        Boolean compressOn = null;
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String argument : inputArgs) {
            if (argument.equals("-Xcompressedrefs") || argument.equals("-XX:+UseCompressedOops")) {
                compressOn = true;
                break;
            }
            if (!argument.equals("-Xnocompressedrefs") && !argument.equals("-XX:-UseCompressedOops")) continue;
            compressOn = false;
            break;
        }
        if (compressOn != null) {
            return compressOn;
        }
        if (ISJVM64BIT) {
            if (ISIBMJAVA && !ISJAVA6) {
                return true;
            }
            if (ISSUNJAVA) {
                String stringUpdaterNumber;
                String updater;
                String[] updaterParts;
                String version;
                String[] versionParts;
                return !ISJAVA6 || (versionParts = (version = System.getProperty(JAVA_VERSION)).split("\\.")).length != 3 || (updaterParts = (updater = versionParts[2]).split("_")).length != 2 || !(stringUpdaterNumber = updaterParts[1]).equals("22");
            }
        }
        return false;
    }

    private static String buildQualifiedKey(ValueEntry entry) {
        String javaVer = "Java";
        javaVer = ISJAVA6 ? javaVer + "6" : javaVer + "7";
        String bytesVers = "[@bytes";
        bytesVers = ISJVM64BIT ? (IS_OBJECT_REFERENCED_COMPRESSED ? bytesVers + SIXTY_FOUR_X : bytesVers + SIXTY_FOUR) : bytesVers + THIRTY_TWO;
        return "queryExecution.SizeOf." + entry.getName() + DOT + javaVer + bytesVers + "]";
    }

    private ValueSizeInfo() {
    }

    public static void loadSizes() {
        if (entries.size() > 0) {
            return;
        }
        XQEConfigurationManager manager = XQEConfigurationManager.getInstance();
        XQEConfiguration configuration = manager.getConfiguration(ServiceEnumeration.XQE);
        String qualifiedKey = null;
        for (ValueEntry entry : ValueEntry.values()) {
            qualifiedKey = ValueSizeInfo.buildQualifiedKey(entry);
            int size = configuration.getIntProperty(qualifiedKey, entry.getDefaultSize());
            entries.put(entry.getName(), size);
        }
    }

    public static int getSizeOf(ValueEntry valueEntry) {
        if (entries.size() == 0) {
            ValueSizeInfo.loadSizes();
        }
        return entries.get(valueEntry.getName());
    }

    public static int getSizeOfTextValue(TextValue textValue) {
        return ValueSizeInfo.getSizeOfTextValue(textValue.getValue());
    }

    public static int getSizeOfTextValue(String strValue) {
        int result = ValueSizeInfo.getSizeOf(ValueEntry.TEXT);
        int valueLength = strValue.length();
        valueLength *= 2;
        valueLength = ValueSizeInfo.roundUpToEight(valueLength);
        return result += valueLength;
    }

    public static int getSizeOfBigDecimalValue(BigDecimalValue bigDecimalValue) {
        int result = 0;
        if (bigDecimalValue == null) {
            return result;
        }
        int baseBigDecimalValue = ValueSizeInfo.getSizeOf(ValueEntry.BIGDECIMALVALUE);
        result += baseBigDecimalValue;
        BigDecimal bigDecimal = bigDecimalValue.getBigDecimal();
        if (bigDecimal != null) {
            result += ValueSizeInfo.getSizeOfBigDecimal(bigDecimal);
        }
        BigInteger bigInteger = null;
        if (bigDecimal != null) {
            bigInteger = ValueSizeInfo.getBigInteger(bigDecimal);
        }
        if (bigInteger != null) {
            result = (int)((long)result + ValueSizeInfo.sizeOfBigInteger(bigInteger));
        }
        return result;
    }

    private static int roundUpToEight(int number) {
        return number + 7 & 0xFFFFFFF8;
    }

    private static String getString(BigDecimal bigDecimal) {
        Class<?> bdClass = bigDecimal.getClass();
        String bi = null;
        try {
            Field field = bdClass.getDeclaredField("stringCache");
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(bigDecimal);
                if (fieldValue instanceof String) {
                    bi = (String)fieldValue;
                    return bi;
                }
            }
            catch (IllegalAccessException e) {
                return bi;
            }
        }
        catch (NoSuchFieldException e1) {
            return bi;
        }
        return null;
    }

    private static BigInteger getBigInteger(BigDecimal bigDecimalValue) {
        Class<?> bdClass = bigDecimalValue.getClass();
        BigInteger bi = null;
        try {
            Field field = bdClass.getDeclaredField("bi");
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(bigDecimalValue);
                if (fieldValue instanceof BigInteger) {
                    bi = (BigInteger)fieldValue;
                    return bi;
                }
            }
            catch (IllegalAccessException e) {
                return bi;
            }
        }
        catch (NoSuchFieldException e1) {
            return bi;
        }
        return null;
    }

    private static int[] getIntArray(BigInteger bigInteger, String fieldName) {
        Class<?> bdClass = bigInteger.getClass();
        try {
            Field field = bdClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(bigInteger);
                if (fieldValue instanceof int[]) {
                    int[] mag = (int[])fieldValue;
                    return mag;
                }
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return null;
    }

    private static byte[] getByteArray(BigInteger bigInteger) {
        Class<?> bdClass = bigInteger.getClass();
        try {
            Field field = bdClass.getDeclaredField("magnitude");
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(bigInteger);
                if (fieldValue instanceof byte[]) {
                    byte[] mag = (byte[])fieldValue;
                    return mag;
                }
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return null;
    }

    public static int getSizeOfBigDecimal(BigDecimal bigDecimal) {
        int result = 0;
        if (bigDecimal == null) {
            return result;
        }
        if (!ISSUNJAVA) {
            return result += ValueSizeInfo.getSizeOf(ValueEntry.BIGDECIMAL);
        }
        result += ValueSizeInfo.getSizeOf(ValueEntry.BIGDECIMAL_SUN);
        String stringCache = ValueSizeInfo.getString(bigDecimal);
        if (stringCache == null) {
            return result;
        }
        int valueLength = stringCache.length();
        valueLength *= 2;
        valueLength = ValueSizeInfo.roundUpToEight(valueLength);
        return result += valueLength;
    }

    private static long sizeOfBigInteger(BigInteger bigInteger) {
        int result = 0;
        if (bigInteger == null) {
            return result;
        }
        int baseOfBigInteger = 0;
        baseOfBigInteger = ISSUNJAVA ? ValueSizeInfo.getSizeOf(ValueEntry.BIGINTEGER_SUN) : ValueSizeInfo.getSizeOf(ValueEntry.BIGINTEGER);
        result += baseOfBigInteger;
        if (ISIBMJAVA && !ISJAVA6) {
            int[] digits;
            byte[] mag = ValueSizeInfo.getByteArray(bigInteger);
            if (mag != null) {
                result = (int)((long)result + ValueSizeInfo.byteArraySize(mag));
            }
            if ((digits = ValueSizeInfo.getIntArray(bigInteger, "digits")) != null) {
                result = (int)((long)result + ValueSizeInfo.intArraySize(digits));
            }
        } else {
            int[] mag = ValueSizeInfo.getIntArray(bigInteger, "mag");
            if (mag != null) {
                result = (int)((long)result + ValueSizeInfo.intArraySize(mag));
            }
        }
        return result;
    }

    private static long intArraySize(int[] intArray) {
        long result = 0L;
        if (intArray == null) {
            return result;
        }
        int baseSize = ValueSizeInfo.getSizeOf(ValueEntry.PRIMITIVEINTARRAY);
        result += (long)baseSize;
        int length = intArray.length;
        if (length == 0) {
            return result;
        }
        int multiplier = length / 2 + length % 2;
        if (!(ValueSizeInfo.isJava6() || ISJVM64BIT && !IS_OBJECT_REFERENCED_COMPRESSED)) {
            --multiplier;
        }
        return result += (long)(multiplier * 8);
    }

    public static long byteArraySize(byte[] byteArray) {
        long result = 0L;
        if (byteArray == null) {
            return result;
        }
        int baseSize = ValueSizeInfo.getSizeOf(ValueEntry.PRIMITIVEBYTEARRAY);
        result += (long)baseSize;
        int length = byteArray.length;
        if (length == 0) {
            return result;
        }
        int multiplier = (length - 1) / 8 + 1;
        if (!(ISJAVA6 || ISJVM64BIT && !IS_OBJECT_REFERENCED_COMPRESSED)) {
            --multiplier;
        }
        return result += (long)(multiplier * 8);
    }

    public static enum ValueEntry {
        DEFAULT("Default", new int[][]{{16, 24, 16}, {16, 16, 16}}),
        OBJECTSIZE("ObjectSize", new int[][]{{16, 24, 16}, {16, 16, 16}}),
        PRIMITIVEBOOLEAN("PrimitiveBoolean", new int[][]{{4, 4, 4}, {4, 4, 4}}),
        PRIMITIVEINT("PrimitiveInt", new int[][]{{4, 4, 4}, {4, 4, 4}}),
        PRIMITIVELONG("PrimitiveLong", new int[][]{{8, 8, 8}, {8, 8, 8}}),
        PRIMITIVEDOUBLE("PrimitiveDouble", new int[][]{{8, 8, 8}, {8, 8, 8}}),
        OBJECTREFERENCE("ObjectReference", new int[][]{{4, 8, 4}, {4, 8, 4}}),
        PRIMITIVEINTARRAY("PrimitiveIntArray", new int[][]{{16, 24, 16}, {16, 16, 16}}),
        PRIMITIVEBYTEARRAY("PrimitiveByteArray", new int[][]{{16, 32, 16}, {16, 24, 16}}),
        ARRAYLIST("ArrayList", new int[][]{{88, 152, 88}, {72, 128, 72}}),
        INTEGER("IntegerValue", new int[][]{{32, 48, 32}, {24, 40, 24}}),
        LONG("LongValue", new int[][]{{32, 48, 32}, {32, 40, 32}}),
        FLOAT("FloatValue", new int[][]{{32, 48, 32}, {24, 40, 24}}),
        DOUBLE("DoubleValue", new int[][]{{32, 48, 32}, {32, 40, 32}}),
        SMALLINT("SmallintValue", new int[][]{{32, 48, 32}, {24, 40, 24}}),
        SMALLDECIMAL("SmallDecimalValue", new int[][]{{32, 48, 32}, {32, 40, 32}}),
        TEXT("TextValue", new int[][]{{88, 136, 88}, {72, 104, 72}}),
        DATE("DateValue", new int[][]{{568, 728, 568}, {536, 664, 536}}),
        TIME("TimeValue", new int[][]{{536, 688, 536}, {504, 632, 504}}),
        TIMESTAMP("TimestampValue", new int[][]{{536, 688, 536}, {504, 632, 504}}),
        BIGDECIMALVALUE("BigDecimalValue", new int[][]{{32, 56, 32}, {32, 48, 32}}),
        BIGDECIMAL("BigDecimal", new int[][]{{32, 48, 32}, {32, 40, 32}}),
        BIGDECIMAL_SUN("BigDecimal_Sun", new int[][]{{32, 48, 40}, {32, 48, 40}}),
        BIGINTEGER("BigInteger", new int[][]{{40, 56, 40}, {56, 72, 56}}),
        BIGINTEGER_SUN("BigInteger_Sun", new int[][]{{32, 48, 40}, {40, 40, 40}});

        String valueEntryName;
        int[][] defaultSizes = new int[2][3];

        private ValueEntry(String name, int[][] defaults) {
            this.valueEntryName = name;
            this.defaultSizes = defaults;
        }

        String getName() {
            return this.valueEntryName;
        }

        int getDefaultSize() {
            if (ISJAVA6) {
                if (ISJVM64BIT) {
                    if (IS_OBJECT_REFERENCED_COMPRESSED) {
                        return this.defaultSizes[0][2];
                    }
                    return this.defaultSizes[0][1];
                }
                return this.defaultSizes[0][0];
            }
            if (ISJVM64BIT) {
                if (IS_OBJECT_REFERENCED_COMPRESSED) {
                    return this.defaultSizes[1][2];
                }
                return this.defaultSizes[1][1];
            }
            return this.defaultSizes[1][0];
        }
    }
}

