/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.util.xml.XMLWriter;
import java.util.HashMap;
import java.util.Map;

public enum ValueState {
    OK(0, 0, "OK"),
    NULL(1, 1, "NULL"),
    NOT_APPLICABLE(2, 2, "NA"),
    DIV_BY_ZERO(3, 4, "DIVBYZERO"),
    SECURITY_VIOLATION(4, 16, "SECURITY"),
    OVERFLOW(5, 8, "OVERFLOW"),
    UNDERFLOW(6, 65535, "UNDERFLOW"),
    ERROR(7, 32, "ERROR"),
    UNKNOWN(8, 65535, "UNKNOWN"),
    CALC(9, 0, "CALC");

    private final byte state;
    private final int ccldbState;
    private final byte[] ccldbStateAsByteArray;
    private final String name;
    private static final ValueState[] BYTE_TO_ENUM;
    private static final Map<Integer, ValueState> CCLDB_STATE_TO_ENUM;
    private static final String STATE_STR = "state";

    private ValueState(byte stateByte, int cclState, String aName) {
        this.state = stateByte;
        this.ccldbState = cclState;
        this.ccldbStateAsByteArray = Integer.toString(this.ccldbState).getBytes();
        this.name = aName;
    }

    public static final ValueState getValueState(byte stateByte) {
        if (stateByte >= BYTE_TO_ENUM.length) {
            throw new IllegalArgumentException();
        }
        return BYTE_TO_ENUM[stateByte];
    }

    public static final ValueState getValueStateFromCCLState(int cclDBState) {
        ValueState v = CCLDB_STATE_TO_ENUM.get(cclDBState);
        if (v == null) {
            return UNKNOWN;
        }
        return v;
    }

    static int getCCLDBState(byte stateByte) {
        return ValueState.getValueState(stateByte).getCCLDBState();
    }

    public byte getState() {
        return this.state;
    }

    public int getCCLDBState() {
        return this.ccldbState;
    }

    public byte[] getCCLDBStateAsByteArray() {
        return this.ccldbStateAsByteArray;
    }

    public String toString() {
        return this.name;
    }

    public void writeRSAPIValueState(XMLWriter writer) {
        switch (this) {
            case NULL: {
                writer.attribute(STATE_STR, "null");
                break;
            }
            case ERROR: {
                writer.attribute(STATE_STR, "error");
                break;
            }
            case DIV_BY_ZERO: {
                writer.attribute(STATE_STR, "dbz");
                break;
            }
            case NOT_APPLICABLE: {
                writer.attribute(STATE_STR, "na");
                break;
            }
            case OVERFLOW: {
                writer.attribute(STATE_STR, "overflow");
                break;
            }
            case SECURITY_VIOLATION: {
                writer.attribute(STATE_STR, "security");
                break;
            }
            case UNDERFLOW: {
                writer.attribute(STATE_STR, "underflow");
                break;
            }
        }
    }

    static {
        ValueState[] enumValues = ValueState.values();
        BYTE_TO_ENUM = new ValueState[enumValues.length];
        CCLDB_STATE_TO_ENUM = new HashMap<Integer, ValueState>();
        ValueState[] valueStateArray = enumValues;
        int n = valueStateArray.length;
        for (int i = 0; i < n; ++i) {
            ValueState value;
            ValueState.BYTE_TO_ENUM[value.getState()] = value = valueStateArray[i];
            CCLDB_STATE_TO_ENUM.put(value.getCCLDBState(), value);
        }
    }
}

