/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEErrorCodeHandler;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public final class XQEErrorCodeConfigurationManager {
    private static final String LOGMSG_CONFIG_ERROR = "An error occurred while loading configurations: ";
    private static final String CONFIG_FILE_PATH = "/xqe.errorcodes.xml";
    private static final String DEFAULT_SEARCH_URL = "http://www.ibm.com/search?q=";
    private String searchURL = "http://www.ibm.com/search?q=";
    private HashSet<String> errorCodesList = new HashSet();
    private boolean errorCodesConsumed = false;
    private XQELogger logger = null;
    private File configFile = null;
    private static SingletonHelper<XQEErrorCodeConfigurationManager> singletonHelper = new SingletonHelper<XQEErrorCodeConfigurationManager>(){

        @Override
        protected XQEErrorCodeConfigurationManager newInstance() {
            return new XQEErrorCodeConfigurationManager();
        }

        @Override
        protected void releaseImpl(XQEErrorCodeConfigurationManager theInstance) {
        }

        @Override
        protected void initializeImpl(XQEErrorCodeConfigurationManager theInstance) {
        }
    };

    public static XQEErrorCodeConfigurationManager getInstance() {
        return singletonHelper.getInstance();
    }

    private XQEErrorCodeConfigurationManager() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        try {
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.configFile = new File(xqeConfig.getConfigDirectory() + CONFIG_FILE_PATH);
            this.reloadConfigurations();
        }
        catch (RuntimeException ex) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, "An error occurred during initialization:\n", (Throwable)ex);
            }
            throw ex;
        }
    }

    public void reloadConfigurations() {
        if (!this.configFile.exists()) {
            this.loadDefaults();
        } else {
            this.reloadFile(this.configFile);
        }
    }

    public void setSearchURL(String searchURLVal) {
        this.searchURL = searchURLVal;
    }

    public String getSearchURL() {
        return this.searchURL;
    }

    public void setErrorCode(String errorCode) {
        this.errorCodesList.add(errorCode);
    }

    public void setErrorCode(HashSet<String> errorCodes) {
        this.errorCodesList.addAll(errorCodes);
    }

    public HashSet<String> getErrorCodes() {
        return this.errorCodesList;
    }

    public void setErrorCodesConsumed(boolean errorCodesConsumedVal) {
        this.errorCodesConsumed = errorCodesConsumedVal;
    }

    public boolean getErrorCodesConsumed() {
        return this.errorCodesConsumed;
    }

    public void loadDefaults() {
        this.searchURL = DEFAULT_SEARCH_URL;
        this.errorCodesList.clear();
    }

    public void reloadFile(File configurationFile) {
        RuntimeException exception;
        block9: {
            this.loadDefaults();
            XQELogger traceLogger = this.getLogger();
            InputStreamReader fileReader = null;
            XMLInputFactory inputFactory = null;
            exception = null;
            try {
                fileReader = new InputStreamReader(new FileInputStream(this.configFile));
                BufferedReader bufReader = new BufferedReader(fileReader);
                XQEErrorCodeHandler documentHandler = new XQEErrorCodeHandler(this);
                inputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
                StaxUtil.configureInputFactory(inputFactory, false, true, true);
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(bufReader);
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
                    inputFactory = null;
                }
                catch (Exception ex) {
                    throw XQERuntimeException.wrap(ex);
                }
                documentHandler.consume(xmlReader);
            }
            catch (Exception ex) {
                if (traceLogger.isOn(LogLevel.ERROR)) {
                    traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, (Throwable)ex);
                }
                exception = XQERuntimeException.wrap(ex);
            }
            if (null != fileReader) {
                try {
                    ((Reader)fileReader).close();
                    fileReader = null;
                }
                catch (Exception ex) {
                    if (exception != null) break block9;
                    exception = XQERuntimeException.wrap(ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private XQELogger getLogger() {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "XQEErrorCodeConfiguration", LogLevel.INFO);
    }
}

