/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TreeMap;

public class XQEMessage {
    private static final char DOUBLE_QUOTE = '\"';
    private static final String LIST_SEPARATOR = ",";
    private IMessageKey mMessageKey;
    private String[] mParams;
    private ArrayList<IXQEQueryNode> mContext;
    private String postMsg;

    public IMessageKey getMessageKey() {
        return this.mMessageKey;
    }

    public String[] getParams() {
        return this.mParams;
    }

    public List<IXQEQueryNode> getContext() {
        return this.mContext;
    }

    XQEMessage(IMessageKey key, String[] params, List<IXQEQueryNode> context) {
        this.mMessageKey = key;
        this.mParams = params;
        this.mContext = (ArrayList)context;
    }

    private XQEMessage(IMessageKey key, String[] params, IXQEQueryNode context) {
        this.mMessageKey = key;
        this.mParams = params;
        this.mContext = new ArrayList();
        this.mContext.add(context);
    }

    public XQEMessage(IMessageKey.Param0 key, IXQEQueryNode context) {
        this((IMessageKey)key, new String[0], context);
    }

    public XQEMessage(IMessageKey.Param0 key, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[0], context);
    }

    public XQEMessage(IMessageKey.Param1 key, String param1, IXQEQueryNode context) {
        this((IMessageKey)key, new String[]{param1}, context);
    }

    public XQEMessage(IMessageKey.Param1 key, String param1, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[]{param1}, context);
    }

    public XQEMessage(IMessageKey.Param2 key, String param1, String param2, IXQEQueryNode context) {
        this((IMessageKey)key, new String[]{param1, param2}, context);
    }

    public XQEMessage(IMessageKey.Param2 key, String param1, String param2, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[]{param1, param2}, context);
    }

    public XQEMessage(IMessageKey.Param3 key, String param1, String param2, String param3, IXQEQueryNode context) {
        this((IMessageKey)key, new String[]{param1, param2, param3}, context);
    }

    public XQEMessage(IMessageKey.Param3 key, String param1, String param2, String param3, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[]{param1, param2, param3}, context);
    }

    public XQEMessage(IMessageKey.Param4 key, String param1, String param2, String param3, String param4, IXQEQueryNode context) {
        this((IMessageKey)key, new String[]{param1, param2, param3, param4}, context);
    }

    public XQEMessage(IMessageKey.Param4 key, String param1, String param2, String param3, String param4, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[]{param1, param2, param3, param4}, context);
    }

    public XQEMessage(IMessageKey.Param5 key, String param1, String param2, String param3, String param4, String param5, IXQEQueryNode context) {
        this((IMessageKey)key, new String[]{param1, param2, param3, param4, param5}, context);
    }

    public XQEMessage(IMessageKey.Param5 key, String param1, String param2, String param3, String param4, String param5, List<IXQEQueryNode> context) {
        this((IMessageKey)key, new String[]{param1, param2, param3, param4, param5}, context);
    }

    public static void appendQuotedItem(StringBuilder sb, String item) {
        sb.append('\"');
        sb.append(item);
        sb.append('\"');
    }

    public static void appendQuotedItemList(StringBuilder sb, Collection<String> list) {
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(LIST_SEPARATOR);
            }
            XQEMessage.appendQuotedItem(sb, item);
        }
    }

    public static String quoteItem(String item) {
        StringBuilder sb = new StringBuilder();
        XQEMessage.appendQuotedItem(sb, item);
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        return this.getLocalizedMessageCore(locale);
    }

    public String getBody(Locale locale) {
        StringBuilder sb = new StringBuilder(this.getLocalizedMessageCore(locale));
        String separator = "\n    ";
        List<IXQEQueryNode> context = this.getContext();
        if (context != null) {
            Collection<V5QueryNode> messageNodes = this.resolveContext(context);
            Iterator<V5QueryNode> it = messageNodes.iterator();
            while (it.hasNext()) {
                sb.append("\n    ");
                it.next().formatForMessage(sb);
            }
        }
        if (this.postMsg != null) {
            sb.append("\n    ");
            sb.append(this.postMsg);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private Collection<V5QueryNode> resolveContext(List<IXQEQueryNode> context) {
        TreeMap<Integer, V5QueryNode> nodeMap = new TreeMap<Integer, V5QueryNode>();
        ListIterator<IXQEQueryNode> contextIterator = context.listIterator();
        while (contextIterator.hasNext()) {
            Collection<IXQEQueryNode> lineage = ((IXQEQueryNode)contextIterator.next()).getLineage();
            if (lineage == null || lineage.size() <= 0) continue;
            for (V5QueryNode v5QueryNode : lineage) {
                void var6_6;
                V5QueryNode effectiveNode = v5QueryNode.getEffectiveNodeForMessage();
                while (!var6_6.equals(effectiveNode) && effectiveNode != null) {
                    V5QueryNode v5QueryNode2 = effectiveNode;
                    effectiveNode = v5QueryNode2.getEffectiveNodeForMessage();
                }
                if (effectiveNode == null) continue;
                int id = effectiveNode.getId();
                nodeMap.put(new Integer(id), effectiveNode);
            }
        }
        return nodeMap.values();
    }

    private String getLocalizedMessageCore(Locale locale) {
        return XQEMessages.getMessageImpl(this.getMessageKey(), locale, this.getParams());
    }

    public void setPostMessage(String message) {
        this.postMsg = message;
    }
}

