/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.exception.ILocalizable;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.ISOAPFault;
import com.cognos.xqe.exception.XQEFault;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class XQERuntimeException
extends RuntimeException
implements ILocalizable,
ISOAPFault {
    private static final long serialVersionUID = 1L;
    private static final int BYTES_PER_MB = 0x100000;
    private Object[] mArguments = null;
    private XQEMessage mMessage;
    private IMessageKey mMessageKey;
    private LogLevel mLogLevel = LogLevel.ERROR;
    private Locale mLocale = null;

    public XQERuntimeException() {
        this((Throwable)null, new Object[0], XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
    }

    public XQERuntimeException(IMessageKey.Param0 messageKey) {
        this((Throwable)null, new Object[0], messageKey);
    }

    public XQERuntimeException(IMessageKey.Param1 messageKey, String par1) {
        this((Throwable)null, new Object[]{par1}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param2 messageKey, String par1, String par2) {
        this((Throwable)null, new Object[]{par1, par2}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param2 messageKey, String par1, String par2, String par3) {
        this((Throwable)null, new Object[]{par1, par2, par3}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param2 messageKey, Object par1, Object par2) {
        this((Throwable)null, new Object[]{par1, par2}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param1 messageKey, Object par1) {
        this((Throwable)null, new Object[]{par1}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param3 messageKey, Object par1, Object par2, Object par3) {
        this((Throwable)null, new Object[]{par1, par2, par3}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param4 messageKey, Object par1, Object par2, Object par3, Object par4) {
        this((Throwable)null, new Object[]{par1, par2, par3, par4}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param5 messageKey, Object par1, Object par2, Object par3, Object par4, Object par5) {
        this((Throwable)null, new Object[]{par1, par2, par3, par4, par5}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param6 messageKey, Object par1, Object par2, Object par3, Object par4, Object par5, Object par6) {
        this((Throwable)null, new Object[]{par1, par2, par3, par4, par5, par6}, messageKey);
    }

    public XQERuntimeException(Throwable aCause) {
        this(aCause, new Object[0], XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
    }

    public XQERuntimeException(IMessageKey.Param0 messageKey, Throwable aCause) {
        this(aCause, new Object[0], messageKey);
    }

    public XQERuntimeException(IMessageKey.Param1 messageKey, Throwable aCause, String par1) {
        this(aCause, new Object[]{par1}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param1 messageKey, Throwable aCause, Object par1) {
        this(aCause, new Object[]{par1}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param2 messageKey, Throwable aCause, Object par1, Object par2) {
        this(aCause, new Object[]{par1, par2}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param3 messageKey, Throwable aCause, Object par1, Object par2, Object par3) {
        this(aCause, new Object[]{par1, par2, par3}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param4 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4) {
        this(aCause, new Object[]{par1, par2, par3, par4}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param5 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4, Object par5) {
        this(aCause, new Object[]{par1, par2, par3, par4, par5}, messageKey);
    }

    public XQERuntimeException(IMessageKey.Param6 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4, Object par5, Object par6) {
        this(aCause, new Object[]{par1, par2, par3, par4, par5, par6}, messageKey);
    }

    private XQERuntimeException(Throwable aCause, Object[] args, IMessageKey messageKey) {
        super(null, aCause);
        this.mMessage = null;
        this.mMessageKey = messageKey;
        this.mArguments = args;
        this.countUsage();
    }

    public XQERuntimeException(XQEMessage message) {
        this.mMessage = message;
        this.mMessageKey = null;
        this.countUsage();
    }

    public XQERuntimeException(IMessageKey messageKey, Object[] args) {
        this.mMessage = null;
        this.mMessageKey = messageKey;
        this.mArguments = args;
    }

    private void countUsage() {
        String indName = this.getClass().getSimpleName();
        IMessageKey messageKey = this.getMessageKey();
        if (messageKey != null) {
            indName = indName + "/" + messageKey.toString();
        }
        IUsageIndicator ind = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.ERROR, indName);
        ind.increment();
    }

    public Object[] getArguments() {
        Object[] arguments = this.mArguments;
        if (arguments == null && this.mMessage != null) {
            arguments = this.mMessage.getParams();
        }
        return arguments;
    }

    protected void setArguments(Object[] args) {
        if (this.mMessage != null) {
            throw new RuntimeException("XQE Internal error: setArguments is not supported for XQEMessage containers.");
        }
        this.mArguments = args;
    }

    @Override
    public String getMessage() {
        if (this.mLocale == null) {
            return this.getLocalizedMessage(XQEMessages.getCurrProductLocale());
        }
        return this.getLocalizedMessage(this.mLocale);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.mLocale == null) {
            return this.getLocalizedMessage(XQEMessages.getCurrProductLocale());
        }
        return this.getLocalizedMessage(this.mLocale);
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getXQEMessage().getBody(locale);
    }

    public static String getStackTraceString(Throwable throwable) {
        String stackTrace;
        if (null != throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            stackTrace = stringWriter.toString();
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            stackTrace = "";
        }
        return stackTrace;
    }

    @Override
    public IMessageKey getMessageKey() {
        IMessageKey messageKey = this.mMessageKey;
        if (messageKey == null && this.mMessage != null) {
            messageKey = this.mMessage.getMessageKey();
        }
        return messageKey;
    }

    protected void setMessageKey(Object[] args, IMessageKey messageKey) {
        this.mMessage = null;
        this.mMessageKey = messageKey;
        this.mArguments = args;
    }

    public XQEMessage getXQEMessage() {
        XQEMessage message = this.mMessage;
        if (message == null) {
            int n = this.mArguments.length;
            String[] params = new String[n];
            for (int i = 0; i < n; ++i) {
                Object arg = this.mArguments[i];
                params[i] = arg == null ? null : arg.toString();
            }
            message = new XQEMessage(this.mMessageKey, params, null);
        }
        return message;
    }

    public void setLogLevel(LogLevel ll) {
        this.mLogLevel = ll;
    }

    public LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public String toString() {
        String msg = this.getLocalizedMessage();
        if (msg != null) {
            return msg;
        }
        return "";
    }

    @Override
    public Fault getFault() {
        XQEFault fault = new XQEFault(this);
        MessageContextImpl messageContext = new MessageContextImpl();
        messageContext.setProperty("locale", (Object)XQEMessages.getCurrProductLocale());
        fault.setMessageContext((MessageContext)messageContext);
        return fault;
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        return faultEnvelope;
    }

    @Override
    public String getFaultCode() {
        return XQEMessages.getErrorCode(this.getLocalizedMessage());
    }

    @Override
    public String getFaultString() {
        return XQEMessages.getErrorMessage(this.getLocalizedMessage());
    }

    protected Fault getFaultFromEnvelope() {
        Fault fault = new Fault("", (SOAPEnvelope)this.getFaultEnvelope());
        MessageContextImpl messageContext = new MessageContextImpl();
        fault.setMessageContext((MessageContext)messageContext);
        return fault;
    }

    public static boolean isACause(Throwable exception, Class<? extends Throwable> cause) {
        while (exception != null) {
            if (exception.getClass().isInstance(cause)) {
                return true;
            }
            exception = exception.getCause();
        }
        return false;
    }

    public static RuntimeException wrap(Throwable e) {
        return XQERuntimeException.wrap(null, e);
    }

    public static RuntimeException wrap(IMessageKey.Param0 key, Throwable e) {
        if (XQERuntimeException.isOomError(e)) {
            return XQERuntimeException.wrapOomError(e);
        }
        if (e instanceof XQERuntimeException) {
            return (XQERuntimeException)e;
        }
        if (key == null) {
            return new XQERuntimeException(e);
        }
        return new XQERuntimeException(key, e);
    }

    public static boolean isOomError(Throwable throwable) {
        return XQERuntimeException.getOomError(throwable) != null;
    }

    public static XQERuntimeException wrapOomError(Throwable throwable) {
        Throwable oom = XQERuntimeException.getOomError(throwable);
        if (oom == null) {
            oom = throwable;
        }
        String maxHeapSize = String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L);
        return new XQERuntimeException(XQEMessageKeys.GEN_QueryServiceOOM, oom, maxHeapSize);
    }

    public static Throwable getOomError(Throwable throwable) {
        for (Throwable oomCandidate = throwable; oomCandidate != null; oomCandidate = oomCandidate.getCause()) {
            if (!(oomCandidate instanceof OutOfMemoryError)) continue;
            return oomCandidate;
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.mLocale = locale;
    }
}

