/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.FormatService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;

public final class FormatId
implements Comparable<FormatId> {
    private static final AtomicInteger NEXT_FORMAT_ID = new AtomicInteger(0);
    private static final int INITIAL_POOL_SIZE = 16;
    private static final Map<Short, FormatId> FORMAT_ID_CACHE = new ConcurrentHashMap<Short, FormatId>(16);
    public static final FormatId INVALID_FORMAT_FID = FormatId.newInstance();
    private static final String INVALID_FORMAT_STRING_ID = "0";
    public static final FormatId EMPTY_FORMAT_FID = FormatId.newInstance();
    public static final FormatId NUMBER_FORMAT_FID = FormatId.newInstance();
    public static final FormatId PERCENT_FORMAT_FID = FormatId.newInstance();
    public static final FormatId CURRENCY_FORMAT_FID = FormatId.newInstance();
    public static final FormatId DATE_FORMAT_FID = FormatId.newInstance();
    public static final FormatId DATETIME_FORMAT_FID = FormatId.newInstance();
    public static final FormatId TIME_FORMAT_FID = FormatId.newInstance();
    public static final FormatId INTERVAL_FORMAT_FID = FormatId.newInstance();
    public static final FormatId STRING_FORMAT_FID = FormatId.newInstance();
    public static final FormatId CUSTOM_FORMAT_FID = FormatId.newInstance();
    public static final FormatId TIMETZ_FORMAT_FID = FormatId.newInstance();
    public static final FormatId DATETIMETZ_FORMAT_FID = FormatId.newInstance();
    public static final FormatId INTEGER_FORMAT_FID = FormatId.newInstance();
    public static final FormatId DEFAULT_NUMBER_FORMAT_FID = FormatId.newInstance();
    public static final FormatId DEFAULT_LONG_FORMAT_FID = FormatId.newInstance();
    private final short formatId = FormatId.getNextFormatId();
    private String cachedFormatStringId = null;

    private FormatId() {
    }

    private static short getNextFormatId() {
        return (short)NEXT_FORMAT_ID.getAndIncrement();
    }

    static FormatId newInstance() {
        FormatId id = new FormatId();
        FORMAT_ID_CACHE.put(id.formatId, id);
        return id;
    }

    public static FormatId getInstance(short formatId) {
        return FORMAT_ID_CACHE.get(formatId);
    }

    public static boolean isDefaultFormatId(FormatId id) {
        return id.formatId < 16;
    }

    public boolean equals(Object id) {
        if (this == id) {
            return true;
        }
        if (!(id instanceof FormatId)) {
            return false;
        }
        return ((FormatId)id).formatId == this.formatId;
    }

    public int hashCode() {
        return this.formatId;
    }

    @Override
    public int compareTo(FormatId id) {
        if (null == id) {
            return -1;
        }
        if (this.formatId < id.formatId) {
            return -1;
        }
        if (this.formatId > id.formatId) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Integer.toString(this.formatId);
    }

    public boolean isInvalid() {
        return this.equals(INVALID_FORMAT_FID);
    }

    public short getInternalValue() {
        return this.formatId;
    }

    public String getFormatStringId() {
        if (null != this.cachedFormatStringId) {
            return this.cachedFormatStringId;
        }
        if (this.isInvalid()) {
            this.cachedFormatStringId = INVALID_FORMAT_STRING_ID;
            return this.cachedFormatStringId;
        }
        FormatService formatService = FormatService.getInstance();
        String v5FormatString = formatService.retrieveFormatString(this);
        if (null == v5FormatString) {
            this.cachedFormatStringId = INVALID_FORMAT_STRING_ID;
        } else {
            CRC32 crc = new CRC32();
            crc.update(v5FormatString.getBytes());
            this.cachedFormatStringId = Long.toString(crc.getValue());
        }
        return this.cachedFormatStringId;
    }
}

