/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.PropertyTypeEnum;
import com.cognos.xqe.format.TextFormatPropertyValue;
import com.cognos.xqe.trace.LogLevel;

public class FormatPropertyDefinition
implements Comparable<FormatPropertyDefinition> {
    private final String propertyName;
    private PropertyTypeEnum propertyType;
    private FormatPropertyValue defaultValue;
    private FormatPropertyValue emptyValue;
    private boolean isHidden;

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyTypeEnum getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypeEnum type) {
        this.propertyType = type;
    }

    public FormatPropertyValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(FormatPropertyValue value) {
        this.defaultValue = value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    protected void setIsHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public FormatPropertyDefinition(String propName, PropertyTypeEnum propType, FormatPropertyValue defValue, boolean hidden) {
        this.propertyName = propName.intern();
        this.propertyType = propType;
        this.defaultValue = defValue;
        this.isHidden = hidden;
    }

    public FormatPropertyDefinition(String propName, PropertyTypeEnum propType) {
        this.propertyName = propName.intern();
        this.propertyType = propType;
        this.defaultValue = null;
        this.isHidden = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyDefinition: name=");
        sb.append(this.propertyName);
        sb.append(" type=");
        sb.append((Object)this.propertyType);
        sb.append(" defaultValue=");
        if (null == this.defaultValue) {
            sb.append("not defined");
        } else {
            sb.append(this.defaultValue.getStringValue());
        }
        sb.append(" hidden=");
        sb.append(this.isHidden);
        return sb.toString();
    }

    @Override
    public int compareTo(FormatPropertyDefinition propDef) {
        return this.propertyName.compareTo(propDef.propertyName);
    }

    public FormatPropertyValue createPropertyValue(Object value) {
        try {
            switch (this.propertyType) {
                case NUMBER: {
                    return new NumberFormatPropertyValue(this.getPropertyName(), Double.parseDouble(value.toString()));
                }
                case BOOLEAN: {
                    return new BooleanFormatPropertyValue(this.getPropertyName(), Boolean.parseBoolean(value.toString()));
                }
                case TEXT: {
                    return new TextFormatPropertyValue(this.getPropertyName(), value.toString());
                }
            }
            return null;
        }
        catch (ClassCastException ex) {
            FormatService.FSLOGGER_STRING_PARSING.log(LogLevel.ERROR, "Can't create property " + this.getPropertyName() + " of type " + this.getPropertyType().toString() + " with value " + value.toString() + ".");
            return null;
        }
    }

    public FormatPropertyValue createEmptyPropertyValue() {
        if (null != this.emptyValue) {
            return this.emptyValue;
        }
        switch (this.propertyType) {
            case NUMBER: {
                this.emptyValue = new NumberFormatPropertyValue(this.propertyName);
                break;
            }
            case BOOLEAN: {
                this.emptyValue = new BooleanFormatPropertyValue(this.propertyName);
                break;
            }
            case TEXT: {
                this.emptyValue = new TextFormatPropertyValue(this.propertyName);
                break;
            }
            default: {
                this.emptyValue = new TextFormatPropertyValue(this.propertyName);
            }
        }
        return this.emptyValue;
    }

    public static FormatPropertyValue createPropertyValue(FormatService service, String propertyName, Object propertyValue) {
        FormatPropertyDefinition propDef = service.getFormatPropertyDefinition(propertyName);
        if (null == propDef) {
            FormatService.FSLOGGER_STRING_PARSING.log(LogLevel.WARN, propertyName + " is not a recognized V5 or XQE format property.");
            TextFormatPropertyValue propVal = new TextFormatPropertyValue(propertyName, propertyValue.toString());
            return propVal;
        }
        return propDef.createPropertyValue(propertyValue);
    }
}

