/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.PropertyTypeEnum;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class FormatPropertyValue
implements Comparable<FormatPropertyValue> {
    protected final String propertyName;
    protected Comparable<?> propertyValue;
    private int hashCode = 0;

    public FormatPropertyValue(String propName) {
        this.propertyName = null == propName ? "" : propName.intern();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public abstract PropertyTypeEnum getPropertyType();

    public abstract boolean isEmpty();

    public String getStringValue() {
        return this.propertyValue.toString();
    }

    public String toString() {
        return this.propertyName + "=\"" + this.getStringValue() + "\"";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormatPropertyValue)) {
            return false;
        }
        FormatPropertyValue fObject = (FormatPropertyValue)object;
        if (!this.getPropertyType().equals((Object)fObject.getPropertyType())) {
            return false;
        }
        return 0 == this.compareTo(fObject);
    }

    public int hashCode() {
        if (0 != this.hashCode) {
            return this.hashCode;
        }
        if (null == this.propertyValue) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The member field 'propertyValue' is not expected to be null.");
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        this.hashCode = hcb.append((Object)this.propertyName).append(this.propertyValue).toHashCode();
        if (0 == this.hashCode) {
            this.hashCode = 1;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(FormatPropertyValue value) {
        int keyCompare = this.propertyName.compareTo(value.propertyName);
        if (0 == keyCompare) {
            return this.propertyValue.compareTo(value.propertyValue);
        }
        return keyCompare;
    }
}

