/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceLoader;
import com.cognos.xqe.format.FormatType;
import com.cognos.xqe.format.formatter.Library;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.format.string.V5FormatInfo;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class FormatServiceImpl
extends FormatService {
    protected static final String DIVIDER = "|";
    protected static final String DOT = ".";
    protected static final String EMPTY_STR = "";
    protected static final String NULL_STR = "null";
    protected static final String SPACE = " ";
    protected static final String LOGMSG_REGISTER_FORMAT_OBJECT = "Register %s format [%s] with id %s and locale %s.";
    private static final String LOGMSG_EXISTING_SET_NEW_FORMAT_ID = "Attempting to register an existing FormatPropertySet with a new FormatId.";
    private static final String LOGMSG_REGISTER_DEFAULT_FORMAT = "Register %s default format [%s] with id %s.";
    private Map<String, FormatPropertyDefinition> formatPropertyDefinitions = null;
    private Map<String, FormatType> formatTypes = null;
    private Map<String, Library> formatLibraries;
    private Map<FormatId, FormatPropertySet> formatPropertySets = new ConcurrentHashMap<FormatId, FormatPropertySet>();
    private Map<Object, FormatId> parsedFormatObjects = new ConcurrentHashMap<Object, FormatId>();
    private Map<FormatId, String> propertySetFormatStrings = new ConcurrentHashMap<FormatId, String>();
    private Map<ResultFormatCacheKey, FormatId> resultFormatCache = new ConcurrentHashMap<ResultFormatCacheKey, FormatId>();
    private ThreadLocal<ResultFormatter> currentFormatter = new ThreadLocal();

    protected boolean initializeFormatsUsingLoader(String formatFile, String propertyDefinitionFile) {
        boolean problemsLoadingService = false;
        FormatServiceLoader loader = new FormatServiceLoader(this, formatFile, propertyDefinitionFile);
        if (loader.loadExternalResources()) {
            this.formatPropertyDefinitions = loader.getFormatPropertyDefinitions();
            this.formatTypes = loader.getFormatTypes();
            this.formatLibraries = loader.getLibraries();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "Loaded the external resources.");
        } else {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Error loading the external resources.  The service is not fully operational.");
            problemsLoadingService = true;
        }
        return problemsLoadingService;
    }

    protected abstract IFormatParser getFormatParser(FormatParserType var1);

    @Override
    public abstract String formatValue(IValue var1, FormatId var2, Locale var3);

    @Override
    public FormatId formatResult(String expressionKeyword, List<FormatId> operandFormatIds) {
        return this.formatResult(expressionKeyword, operandFormatIds, new Properties());
    }

    @Override
    public FormatId formatResult(String expressionKeyword, List<FormatId> operandFormatIds, Properties externalParameters) {
        FormatPropertySet resultPropertySet;
        ResultFormatCacheKey resultCacheKey = new ResultFormatCacheKey(expressionKeyword, operandFormatIds, externalParameters);
        FormatId previousResult = this.resultFormatCache.get(resultCacheKey);
        if (null != previousResult) {
            if (this.loggerIsOn(LogLevel.INFO)) {
                FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, resultCacheKey.toString() + " already cached. Returning result " + previousResult.toString() + DOT);
            }
            return previousResult;
        }
        if (this.loggerIsOn(LogLevel.INFO)) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, resultCacheKey.toString() + " not cached. Invoking a new ResultFormatter.");
        }
        ArrayList<FormatPropertySet> operandFormatSets = new ArrayList<FormatPropertySet>(operandFormatIds.size());
        for (FormatId formatId : operandFormatIds) {
            if (formatId.equals(FormatId.INVALID_FORMAT_FID)) {
                operandFormatSets.add(this.getFormatPropertySet(FormatId.EMPTY_FORMAT_FID));
                continue;
            }
            operandFormatSets.add(this.getFormatPropertySet(formatId));
        }
        this.currentFormatter.set(new ResultFormatter(this, expressionKeyword, operandFormatSets, externalParameters));
        this.currentFormatter.get().setLibraries(this.getLibrariesForContext());
        try {
            resultPropertySet = this.currentFormatter.get().resolve();
        }
        catch (ResultFormattingException e) {
            FSLOGGER_FORMATTER.log("Encountered a ResultFormattingException: ", (Throwable)e);
            return FormatId.EMPTY_FORMAT_FID;
        }
        resultPropertySet = this.commitSetToCollection(resultPropertySet);
        FormatId resultFormatId = resultPropertySet.getFormatId();
        this.resultFormatCache.put(resultCacheKey, resultFormatId);
        if (this.loggerIsOn(LogLevel.INFO)) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "Caching new result as " + resultCacheKey.toString() + " with result " + resultFormatId.toString() + DOT);
        }
        return resultFormatId;
    }

    @Override
    public FormatPropertyDefinition getFormatPropertyDefinition(String propertyName) {
        return this.formatPropertyDefinitions.get(propertyName);
    }

    @Override
    public FormatPropertySet getFormatPropertySet(FormatId id) {
        return this.formatPropertySets.get(id);
    }

    @Override
    public ResultFormatter getCurrentFormatter() throws IllegalStateException {
        if (null == this.currentFormatter.get()) {
            throw new IllegalStateException();
        }
        return this.currentFormatter.get();
    }

    @Override
    public FormatType getFormatType(String formatType) {
        return this.formatTypes.get(formatType);
    }

    protected FormatPropertySet commitSetToCollection(FormatPropertySet set) {
        return this.commitSetToCollection(set, null);
    }

    private FormatPropertySet commitSetToCollection(FormatPropertySet set, FormatId id) {
        XQELogger logger = FSLOGGER_STRING_PARSING;
        if (null == set) {
            return null;
        }
        if (!set.getFormatId().isInvalid()) {
            FormatPropertySet existingSet = this.formatPropertySets.get(set.getFormatId());
            if (null == existingSet) {
                logger.log(LogLevel.WARN, "Format id " + set.getFormatId().toString() + " is not assigned to a set.");
            } else if (set.equals(existingSet)) {
                return existingSet;
            }
            set.setFormatId(FormatId.INVALID_FORMAT_FID);
        }
        for (FormatPropertySet existingSet : this.formatPropertySets.values()) {
            if (!existingSet.equals(set)) continue;
            if (null != id && !id.equals(existingSet.getFormatId())) {
                FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, LOGMSG_EXISTING_SET_NEW_FORMAT_ID);
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, LOGMSG_EXISTING_SET_NEW_FORMAT_ID);
            }
            return existingSet;
        }
        if (null != id) {
            set.setFormatId(id);
        } else {
            set.setFormatId(FormatId.newInstance());
        }
        this.formatPropertySets.put(set.getFormatId(), set);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, set.toString());
        }
        return set;
    }

    protected FormatId registerFormatInfoImpl(IFormatInfo info, FormatParserType providerType, Locale locale) {
        XQELogger spLogger = FSLOGGER_STRING_PARSING;
        if (null == info || null == providerType) {
            spLogger.log(LogLevel.ERROR, "Invalid parameters for registerFormatInfo: " + this.providerFormatParamsToString(info, providerType));
            return FormatId.EMPTY_FORMAT_FID;
        }
        if (null == locale) {
            locale = Locale.US;
        }
        try {
            IFormatParser parser = this.getFormatParser(providerType);
            if (null == parser) {
                return FormatId.EMPTY_FORMAT_FID;
            }
            FormatId fid = null;
            Object parsedFormatObjectsKey = parser.getFormatCacheKey(info, locale);
            if (null != parsedFormatObjectsKey && null != (fid = this.parsedFormatObjects.get(parsedFormatObjectsKey))) {
                return fid;
            }
            FormatPropertySet propertySet = parser.parseFormat(info, locale);
            if (null == propertySet) {
                spLogger.log(LogLevel.WARN, "Could not parse the format object: " + this.providerFormatParamsToString(info, providerType));
                if (null != parsedFormatObjectsKey) {
                    this.parsedFormatObjects.put(parsedFormatObjectsKey, FormatId.EMPTY_FORMAT_FID);
                }
                return FormatId.EMPTY_FORMAT_FID;
            }
            propertySet = this.commitSetToCollection(propertySet);
            fid = propertySet.getFormatId();
            if (null != parsedFormatObjectsKey) {
                this.parsedFormatObjects.put(parsedFormatObjectsKey, fid);
            }
            return fid;
        }
        catch (Exception ex) {
            spLogger.log(LogLevel.ERROR, "Encountered exception while parsing " + (Object)((Object)providerType) + " format object:\n" + this.providerFormatParamsToString(info, providerType) + "\nException: ", (Throwable)ex);
            return FormatId.EMPTY_FORMAT_FID;
        }
    }

    protected void registerStaticFormatString(String v5FormatString, FormatId id) {
        IFormatParser parser = this.getFormatParser(FormatParserType.V5);
        V5FormatInfo info = new V5FormatInfo(v5FormatString);
        FormatPropertySet set = null;
        try {
            set = parser.parseFormat(info, Locale.US);
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format(LOGMSG_REGISTER_DEFAULT_FORMAT, FormatParserType.V5.toString(), v5FormatString, id).toString());
        }
        this.commitSetToCollection(set, id);
    }

    private String providerFormatParamsToString(IFormatInfo info, FormatParserType providerType) {
        StringBuilder providerFormatStr = new StringBuilder();
        if (null == info) {
            providerFormatStr.append(NULL_STR);
        } else {
            providerFormatStr.append(info.toString());
        }
        providerFormatStr.append(SPACE);
        providerFormatStr.append((Object)providerType);
        providerFormatStr.append(DOT);
        return providerFormatStr.toString();
    }

    public Collection<Library> getLibrariesForContext() {
        return Collections.unmodifiableCollection(this.formatLibraries.values());
    }

    public void setTestResultFormatter(ResultFormatter formatter) {
        this.currentFormatter.set(formatter);
    }

    @Override
    public FormatPropertyValue createFormatPropertyValue(String propertyName, String value) {
        FormatPropertyDefinition definition = this.getFormatPropertyDefinition(propertyName);
        if (null == definition) {
            return null;
        }
        return definition.createPropertyValue(value);
    }

    @Override
    public String formatValue(IValue value, FormatId id) {
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        return this.formatValue(value, id, env.getRequestEnvironment().getRunLocale());
    }

    @Override
    public String getCurrencyCode(FormatId id) {
        FormatPropertyValue value = this.getFormatPropertyValue(id, "currencyCode");
        if (null != value) {
            return value.getStringValue();
        }
        return null;
    }

    @Override
    public FormatPropertyValue getFormatPropertyValue(FormatId id, String propertyName) {
        if (id.isInvalid()) {
            return null;
        }
        FormatPropertySet set = this.getFormatPropertySet(id);
        if (null == set) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Unrecognized FormatId " + id.toString() + DOT);
            return null;
        }
        FormatPropertyValue value = set.getPropertyValue(propertyName);
        return value;
    }

    @Override
    public String getFormatStringId(FormatId id) {
        if (null == id) {
            return null;
        }
        return id.getFormatStringId();
    }

    @Override
    public String getFormatTypeName(FormatId id) {
        FormatPropertySet set = this.getFormatPropertySet(id);
        if (null == set) {
            return EMPTY_STR;
        }
        String formatTypeName = this.getFormatPropertySet(id).getFormatTypeName();
        if (null == formatTypeName) {
            return EMPTY_STR;
        }
        return formatTypeName;
    }

    @Override
    public String getUnitOfMeasure(FormatId id) {
        FormatPropertyValue value = this.getFormatPropertyValue(id, "unitOfMeasure");
        if (null != value) {
            return value.getStringValue();
        }
        return null;
    }

    @Override
    public String retrieveFormatString(FormatId id) {
        return this.retrieveFormatString(id, false);
    }

    @Override
    public String retrieveFormatString(FormatId id, boolean includeHidden) {
        if (null == id || id.equals(FormatId.INVALID_FORMAT_FID)) {
            return null;
        }
        if (!includeHidden && this.propertySetFormatStrings.containsKey(id)) {
            return this.propertySetFormatStrings.get(id);
        }
        FormatPropertySet set = this.getFormatPropertySet(id);
        if (null == set) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Cannot generate V5 format string for unknown FormatId " + id.toString());
            return null;
        }
        String v5FormatString = EMPTY_STR;
        String formatType = set.getFormatTypeName();
        if (null != formatType && 0 < formatType.length()) {
            StringBuilder sb = new StringBuilder();
            sb.append("&lt;formatGroup&gt;&lt;");
            sb.append(formatType);
            for (FormatPropertyValue property : set.getPropertyValues()) {
                FormatPropertyDefinition definition = this.getFormatPropertyDefinition(property.getPropertyName());
                if (null != definition && !includeHidden && definition.isHidden()) continue;
                sb.append(SPACE);
                sb.append(property.getPropertyName());
                sb.append("=&quot;");
                sb.append(property.getStringValue());
                sb.append("&quot;");
            }
            sb.append("/&gt;&lt;/formatGroup&gt;");
            v5FormatString = sb.toString();
        }
        if (!includeHidden) {
            this.propertySetFormatStrings.put(id, v5FormatString);
        }
        return v5FormatString;
    }

    private final class ResultFormatCacheKey
    implements Comparable<ResultFormatCacheKey> {
        private final String expressionName;
        private final List<FormatId> operandIds;
        private final Properties externalParameters;
        private int cachedHashCode = -1;

        private ResultFormatCacheKey(String expression, List<FormatId> operands, Properties parameters) {
            this.expressionName = expression;
            this.operandIds = operands;
            this.externalParameters = parameters;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ResultFormatCacheKey)) {
                return false;
            }
            ResultFormatCacheKey key = (ResultFormatCacheKey)object;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.expressionName, (Object)key.expressionName);
            if (!eb.isEquals()) {
                return false;
            }
            eb.append(this.operandIds, key.operandIds);
            if (!eb.isEquals()) {
                return false;
            }
            eb.append((Object)this.externalParameters, (Object)key.externalParameters);
            return eb.isEquals();
        }

        public int hashCode() {
            if (-1 != this.cachedHashCode) {
                return this.cachedHashCode;
            }
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.expressionName);
            for (FormatId formatId : this.operandIds) {
                hcb.append((Object)formatId);
            }
            this.cachedHashCode = hcb.append((Object)this.externalParameters).toHashCode();
            if (-1 == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
            return this.cachedHashCode;
        }

        @Override
        public int compareTo(ResultFormatCacheKey key) {
            if (null == key) {
                return -1;
            }
            if (this == key) {
                return 0;
            }
            CompareToBuilder ctb = new CompareToBuilder();
            ctb.append((Object)this.expressionName, (Object)key.expressionName);
            if (ctb.toComparison() != 0) {
                return ctb.toComparison();
            }
            ctb.append(this.operandIds, key.operandIds);
            if (ctb.toComparison() != 0) {
                return ctb.toComparison();
            }
            ctb.append((Object)this.externalParameters, (Object)key.externalParameters);
            return ctb.toComparison();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ResultFormatCacheKey expression=");
            sb.append(this.expressionName);
            sb.append(" with operand FormatIds {");
            Iterator<FormatId> idIter = this.operandIds.iterator();
            while (idIter.hasNext()) {
                sb.append(idIter.next().toString());
                if (!idIter.hasNext()) continue;
                sb.append(FormatServiceImpl.DIVIDER);
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

