/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatType;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.PropertyTypeEnum;
import com.cognos.xqe.format.TextFormatPropertyValue;
import com.cognos.xqe.format.formatter.Library;
import com.cognos.xqe.format.formatter.TransformationLibraryParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.stax.ForwardingChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;

class FormatServiceLoader {
    private static final String LOGMSG_FMT_VALUE_NOT_A_NUMBER = "The value [%s] for property [%s] could not be parsed as a number.";
    private static final String LOGMSG_UNKNOWN_PROPERTY_TYPE = "Cannot create a property of type [%s].";
    private static final String EMPTY_NAMESPACE = "";
    private static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String XS_PREF = "xs";
    private static final QName FORMAT_PROPERTY_DEFINITIONS_QNAME = new QName("", "formatPropertyDefinitions");
    private static final QName PROPERTY_DEFINITION_QNAME = new QName("", "propertyDefinition");
    private static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xs");
    private static final QName ELEMENT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "element", "xs");
    private static final QName ATTRIBUTE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attribute", "xs");
    private static final QName ATTRIBUTE_GROUP_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attributeGroup", "xs");
    private static final QName COMPLEX_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "complexType", "xs");
    private static final String DEFAULT_VALUE_ATTR = "defaultValue";
    private static final String HIDDEN_ATTR = "hidden";
    private static final String VALUE_TYPE_ATTR = "valueType";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String REF_ATTR = "ref";
    private static final String NUMBER_VAL = "number";
    private static final String TEXT_VAL = "text";
    private static final String BOOLEAN_VAL = "boolean";
    private static final String TRUE_VAL = "true";
    private static final String XS_DOUBLE = "xs:double";
    private static final String XS_FLOAT = "xs:float";
    private static final String XS_DECIMAL = "xs:decimal";
    private static final String XS_INTEGER = "xs:integer";
    private static final String XS_NON_POSITIVE_INTEGER = "xs:nonPositiveInteger";
    private static final String XS_LONG = "xs:long";
    private static final String XS_NON_NEGATIVE_INTEGER = "xs:nonNegativeInteger";
    private static final String XS_NEGATIVE_INTEGER = "xs:negativeInteger";
    private static final String XS_INT = "xs:int";
    private static final String XS_UNSIGNED_LONG = "xs:unsignedLong";
    private static final String XS_POSITIVE_INTEGER = "xs:positiveInteger";
    private static final String XS_SHORT = "xs:short";
    private static final String XS_UNSIGNED_INT = "xs:unsignedInt";
    private static final String XS_BYTE = "xs:byte";
    private static final String XS_UNSIGNED_SHORT = "xs:unsignedShort";
    private static final String XS_UNSIGNED_BYTE = "xs:unsignedByte";
    private static final String XS_BOOLEAN = "xs:boolean";
    private static final String LOGMSG_HANDLING_FORMAT_FILE = "Handling the format definition file: ";
    private static final String LOGMSG_HANDLING_PROPERTY_DEFINITION_FILE = "Handling the XQE format definition file: ";
    private static final String SPACE = " ";
    private final FormatService mService;
    private final String mFormatFile;
    private final String mPropertyDefinitionFile;
    private boolean loadedExternalResources = false;
    private Map<String, FormatPropertyDefinition> formatPropertyDefinitions = new HashMap<String, FormatPropertyDefinition>();
    private Map<String, FormatType> formatTypes = new HashMap<String, FormatType>();
    private Map<String, Library> libraries = new HashMap<String, Library>();
    private XQELogger resourceParsingLogger = null;

    static FormatPropertyValue createFormatPropertyValue(FormatPropertyDefinition definition, String strValue) {
        return FormatServiceLoader.createFormatPropertyValue(definition.getPropertyName(), definition.getPropertyType(), strValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static FormatPropertyValue createFormatPropertyValue(String propertyName, PropertyTypeEnum propertyType, String strValue) {
        switch (propertyType) {
            case NUMBER: {
                try {
                    return new NumberFormatPropertyValue(propertyName, Double.parseDouble(strValue));
                }
                catch (NumberFormatException e) {
                    if (!FormatService.FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.ERROR)) return new TextFormatPropertyValue(propertyName, strValue);
                    Formatter formatter = new Formatter();
                    formatter.format(LOGMSG_FMT_VALUE_NOT_A_NUMBER, strValue, propertyName);
                    FormatService.FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, formatter.toString());
                    return null;
                }
            }
            case TEXT: {
                return new TextFormatPropertyValue(propertyName, strValue);
            }
            case BOOLEAN: {
                return new BooleanFormatPropertyValue(propertyName, Boolean.parseBoolean(strValue));
            }
        }
        if (!FormatService.FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.ERROR)) return null;
        Formatter formatter = new Formatter();
        formatter.format(LOGMSG_UNKNOWN_PROPERTY_TYPE, new Object[]{propertyType});
        FormatService.FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, formatter.toString());
        return null;
    }

    FormatServiceLoader(FormatService service, String formatFile, String propertyDefinitionFile) {
        this.mService = service;
        this.mFormatFile = formatFile;
        this.mPropertyDefinitionFile = propertyDefinitionFile;
        this.resourceParsingLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FormatService.Parser.Resource", LogLevel.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPropertyDefinitions(InputStream formatFile, InputStream formatDefinitionFile) {
        this.resourceParsingLogger.log(LogLevel.INFO, "Loading the format types and property definitions from the format definition file.");
        XMLStreamReader formatStreamReader = null;
        try {
            formatStreamReader = StaxUtil.createXMLStreamReader(formatFile);
            PropertyDefinitionParser propertyDefinitionsParser = new PropertyDefinitionParser();
            StaxUtil.moveToElement(formatStreamReader, SCHEMA_QNAME);
            propertyDefinitionsParser.consume(formatStreamReader);
        }
        catch (Exception ex) {
            this.resourceParsingLogger.log(LogLevel.ERROR, "Exception while parsing the format definition file.");
            this.resourceParsingLogger.log(LogLevel.ERROR, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != formatStreamReader) {
                try {
                    formatStreamReader.close();
                }
                catch (Exception ex) {
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_FORMAT_FILE, (Throwable)ex);
                    return false;
                }
                try {
                    formatFile.close();
                }
                catch (Exception ex) {
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_FORMAT_FILE, (Throwable)ex);
                    return false;
                }
            }
        }
        this.resourceParsingLogger.log(LogLevel.INFO, "Loading the format types and property definitions from " + this.mPropertyDefinitionFile + ".");
        XMLStreamReader xqePropertyDefinitonStreamReader = null;
        try {
            xqePropertyDefinitonStreamReader = StaxUtil.createXMLStreamReader(formatDefinitionFile);
            XQEPropertyDefinitionParser xqePropertyDefinitionsParser = new XQEPropertyDefinitionParser();
            StaxUtil.moveToElement(xqePropertyDefinitonStreamReader, FORMAT_PROPERTY_DEFINITIONS_QNAME);
            xqePropertyDefinitionsParser.consume(xqePropertyDefinitonStreamReader);
        }
        catch (Exception ex) {
            this.resourceParsingLogger.log(LogLevel.ERROR, "Exception while parsing the xqe.propertyDefinitions.xml file.");
            this.resourceParsingLogger.log(LogLevel.ERROR, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != xqePropertyDefinitonStreamReader) {
                try {
                    xqePropertyDefinitonStreamReader.close();
                }
                catch (Exception ex) {
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_PROPERTY_DEFINITION_FILE, (Throwable)ex);
                    return false;
                }
                try {
                    formatDefinitionFile.close();
                }
                catch (Exception ex) {
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_PROPERTY_DEFINITION_FILE, (Throwable)ex);
                    return false;
                }
            }
        }
        this.dumpPropertyDefinitions();
        this.dumpFormatTypes();
        this.resourceParsingLogger.log(LogLevel.INFO, "Loaded the format types and property definitions.");
        return true;
    }

    Map<String, FormatPropertyDefinition> getFormatPropertyDefinitions() {
        if (this.loadedExternalResources) {
            return this.formatPropertyDefinitions;
        }
        return null;
    }

    Map<String, FormatType> getFormatTypes() {
        if (this.loadedExternalResources) {
            return this.formatTypes;
        }
        return null;
    }

    Map<String, Library> getLibraries() {
        if (this.loadedExternalResources) {
            return this.libraries;
        }
        return null;
    }

    boolean loadExternalResources() {
        if (this.loadedExternalResources) {
            return true;
        }
        if (!this.loadPropertyDefinitions()) {
            this.loadedExternalResources = false;
            return false;
        }
        if (!this.loadTransformationLibraries()) {
            this.loadedExternalResources = false;
            return false;
        }
        this.loadedExternalResources = true;
        return true;
    }

    private void dumpFormatTypes() {
        if (this.resourceParsingLogger.isOn(LogLevel.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Format types::");
            TreeMap<String, FormatType> sortedMap = new TreeMap<String, FormatType>(this.formatTypes);
            for (FormatType type : sortedMap.values()) {
                sb.append(type.toString());
            }
            this.resourceParsingLogger.log(LogLevel.INFO, sb.toString());
        }
    }

    private void dumpPropertyDefinitions() {
        if (this.resourceParsingLogger.isOn(LogLevel.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Format property Definitions::");
            TreeMap<String, FormatPropertyDefinition> sortedMap = new TreeMap<String, FormatPropertyDefinition>(this.formatPropertyDefinitions);
            for (FormatPropertyDefinition definition : sortedMap.values()) {
                sb.append(definition.toString());
            }
            this.resourceParsingLogger.log(LogLevel.INFO, sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPropertyDefinitions() {
        boolean bl;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        InputStream formatFile = null;
        InputStream propertyDefinitionFile = null;
        try {
            block5: {
                try {
                    formatFile = new FileInputStream(config.getBinDirectory() + "/../schemas/rspec/15.5/" + this.mFormatFile);
                }
                catch (Exception openEx) {
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_FORMAT_FILE, (Throwable)openEx);
                    formatFile = this.getClass().getResourceAsStream(this.mFormatFile);
                    if (formatFile != null) break block5;
                    XQERuntimeException ex = new XQERuntimeException(XQEMessageKeys.GEN_ErrorLoadingFormatDefinitions);
                    this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_FORMAT_FILE, (Throwable)ex);
                    throw ex;
                }
            }
            propertyDefinitionFile = this.getClass().getResourceAsStream(this.mPropertyDefinitionFile);
            if (propertyDefinitionFile == null) {
                XQERuntimeException ex = new XQERuntimeException(XQEMessageKeys.GEN_ErrorLoadingFormatDefinitions);
                this.resourceParsingLogger.log(LogLevel.ERROR, LOGMSG_HANDLING_PROPERTY_DEFINITION_FILE, (Throwable)ex);
                throw ex;
            }
            bl = this.loadPropertyDefinitions(formatFile, propertyDefinitionFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(formatFile);
            IOUtils.closeQuietly(propertyDefinitionFile);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)formatFile);
        IOUtils.closeQuietly((InputStream)propertyDefinitionFile);
        return bl;
    }

    private boolean loadTransformationLibraries() {
        Library coreLibrary = new TransformationLibraryParser(this.mService).loadLibrary("core.library");
        if (null == coreLibrary) {
            return false;
        }
        this.libraries.put("core.library", coreLibrary);
        this.resourceParsingLogger.log(LogLevel.INFO, "Loaded the external format library 'core.library.xml'.");
        return true;
    }

    private final class XQEPropertyDefinitionParser
    implements IStaxComponentHandler {
        XQEPropertyDefinitionParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(XMLStreamReader reader) throws XMLStreamException {
            reader.require(1, FORMAT_PROPERTY_DEFINITIONS_QNAME.getNamespaceURI(), FORMAT_PROPERTY_DEFINITIONS_QNAME.getLocalPart());
            ForwardingChildElementIterator propDefIter = new ForwardingChildElementIterator(reader);
            while (propDefIter.next()) {
                reader.require(1, PROPERTY_DEFINITION_QNAME.getNamespaceURI(), PROPERTY_DEFINITION_QNAME.getLocalPart());
                String name = reader.getAttributeValue(null, FormatServiceLoader.NAME_ATTR);
                String valueType = reader.getAttributeValue(null, FormatServiceLoader.VALUE_TYPE_ATTR);
                String defaultValue = reader.getAttributeValue(null, FormatServiceLoader.DEFAULT_VALUE_ATTR);
                String hidden = reader.getAttributeValue(null, FormatServiceLoader.HIDDEN_ATTR);
                PropertyTypeEnum dataType = PropertyTypeEnum.NO_TYPE;
                if (null != valueType) {
                    if (valueType.equals(FormatServiceLoader.NUMBER_VAL)) {
                        dataType = PropertyTypeEnum.NUMBER;
                    } else if (valueType.equals(FormatServiceLoader.TEXT_VAL)) {
                        dataType = PropertyTypeEnum.TEXT;
                    } else if (valueType.equals(FormatServiceLoader.BOOLEAN_VAL)) {
                        dataType = PropertyTypeEnum.BOOLEAN;
                    } else {
                        dataType = PropertyTypeEnum.NO_TYPE;
                        if (FormatServiceLoader.this.resourceParsingLogger.isOn(LogLevel.WARN)) {
                            try (Formatter formatter = new Formatter();){
                                FormatServiceLoader.this.resourceParsingLogger.log(LogLevel.WARN, formatter.format("The property defintion %s has an invalid property type %s.", name, valueType).toString());
                            }
                        }
                    }
                }
                boolean isHidden = false;
                if (null != hidden && hidden.equals(FormatServiceLoader.TRUE_VAL)) {
                    isHidden = true;
                }
                FormatPropertyDefinition definition = null;
                if (FormatServiceLoader.this.formatPropertyDefinitions.containsKey(name)) {
                    definition = (FormatPropertyDefinition)FormatServiceLoader.this.formatPropertyDefinitions.get(name);
                    definition.setDefaultValue(FormatServiceLoader.createFormatPropertyValue(definition, defaultValue));
                    definition.setIsHidden(isHidden);
                    if (dataType == PropertyTypeEnum.NO_TYPE) continue;
                    definition.setPropertyType(dataType);
                    continue;
                }
                definition = new FormatPropertyDefinition(name, dataType, FormatServiceLoader.createFormatPropertyValue(name, dataType, defaultValue), isHidden);
                FormatServiceLoader.this.formatPropertyDefinitions.put(name, definition);
                ForwardingChildElementIterator fmtTypeIter = new ForwardingChildElementIterator(reader);
                while (fmtTypeIter.next()) {
                    String strType = reader.getAttributeValue(null, FormatServiceLoader.TYPE_ATTR);
                    if (strType.equals("all")) {
                        Collection types = FormatServiceLoader.this.formatTypes.values();
                        for (FormatType type : types) {
                            type.addProperty(definition);
                        }
                        fmtTypeIter.skipToEnd();
                        continue;
                    }
                    FormatType type = (FormatType)FormatServiceLoader.this.formatTypes.get(strType);
                    if (null != type) {
                        type.addProperty(definition);
                        continue;
                    }
                    if (!FormatServiceLoader.this.resourceParsingLogger.isOn(LogLevel.WARN)) continue;
                    try (Formatter formatter = new Formatter();){
                        FormatServiceLoader.this.resourceParsingLogger.log(LogLevel.WARN, formatter.format("Unknown format type '%s'.", strType).toString());
                    }
                }
            }
        }
    }

    private class PropertyDefinitionParser
    implements IStaxComponentHandler {
        private Map<String, PropertyTypeEnum> xsSchemaTypeMap = new HashMap<String, PropertyTypeEnum>();

        PropertyDefinitionParser() {
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_BOOLEAN, PropertyTypeEnum.BOOLEAN);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_BYTE, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_DECIMAL, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_DOUBLE, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_FLOAT, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_INT, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_INTEGER, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_LONG, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_NEGATIVE_INTEGER, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_NON_NEGATIVE_INTEGER, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_NON_POSITIVE_INTEGER, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_POSITIVE_INTEGER, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_SHORT, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_UNSIGNED_BYTE, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_UNSIGNED_INT, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_UNSIGNED_LONG, PropertyTypeEnum.NUMBER);
            this.xsSchemaTypeMap.put(FormatServiceLoader.XS_UNSIGNED_SHORT, PropertyTypeEnum.NUMBER);
        }

        @Override
        public void consume(XMLStreamReader reader) throws XMLStreamException {
            Set agContentSet;
            reader.require(1, SCHEMA_QNAME.getNamespaceURI(), SCHEMA_QNAME.getLocalPart());
            HashMap agFormatTypeReferenceMap = new HashMap();
            HashMap agContentMap = new HashMap();
            HashMap agReferenceMap = new HashMap();
            ForwardingChildElementIterator schemaChildIter = new ForwardingChildElementIterator(reader);
            while (schemaChildIter.next()) {
                if (reader.isStartElement() && reader.getName().equals(ELEMENT_QNAME)) {
                    String formatTypeName = reader.getAttributeValue(null, FormatServiceLoader.NAME_ATTR);
                    FormatType formatType = new FormatType(formatTypeName);
                    ForwardingChildElementIterator fmtTypeChildIter = new ForwardingChildElementIterator(reader);
                    while (fmtTypeChildIter.next()) {
                        if (!reader.getName().equals(COMPLEX_TYPE_QNAME)) continue;
                        ForwardingChildElementIterator fmtTypeAttrIter = new ForwardingChildElementIterator(reader);
                        while (fmtTypeAttrIter.next()) {
                            if (reader.getName().equals(ATTRIBUTE_QNAME)) {
                                FormatPropertyDefinition propDef = this.parsePropertyDefinition(reader);
                                if (null == propDef) continue;
                                formatType.addProperty(propDef);
                                continue;
                            }
                            if (!reader.getName().equals(ATTRIBUTE_GROUP_QNAME)) continue;
                            String attributeGroupName = reader.getAttributeValue(null, FormatServiceLoader.REF_ATTR);
                            if (!agFormatTypeReferenceMap.containsKey(attributeGroupName)) {
                                agFormatTypeReferenceMap.put(attributeGroupName, new LinkedList());
                            }
                            ((List)agFormatTypeReferenceMap.get(attributeGroupName)).add(formatType);
                        }
                    }
                    FormatServiceLoader.this.formatTypes.put(formatTypeName, formatType);
                    continue;
                }
                if (reader.isStartElement() && reader.getName().equals(ATTRIBUTE_GROUP_QNAME)) {
                    String agName = reader.getAttributeValue(null, FormatServiceLoader.NAME_ATTR);
                    agContentMap.put(agName, new HashSet());
                    ForwardingChildElementIterator attributeGroupChildIter = new ForwardingChildElementIterator(reader);
                    while (attributeGroupChildIter.next()) {
                        if (reader.getName().equals(ATTRIBUTE_QNAME)) {
                            FormatPropertyDefinition propDef = this.parsePropertyDefinition(reader);
                            if (null == propDef) continue;
                            ((Set)agContentMap.get(agName)).add(propDef);
                            continue;
                        }
                        if (!reader.getName().equals(ATTRIBUTE_GROUP_QNAME)) continue;
                        String agReferenceName = reader.getAttributeValue(null, FormatServiceLoader.REF_ATTR);
                        if (!agReferenceMap.containsKey(agReferenceName)) {
                            agReferenceMap.put(agReferenceName, new LinkedList());
                        }
                        ((List)agReferenceMap.get(agReferenceName)).add(agName);
                    }
                    continue;
                }
                String[] expectedElementNames = new String[]{ELEMENT_QNAME.getLocalPart(), ATTRIBUTE_GROUP_QNAME.getLocalPart()};
                this.handleUnexpectedElement(reader, expectedElementNames);
            }
            for (String agRefName : agReferenceMap.keySet()) {
                agContentSet = (Set)agContentMap.get(agRefName);
                List agToCompleteList = (List)agReferenceMap.get(agRefName);
                for (String agToComplete : agToCompleteList) {
                    ((Set)agContentMap.get(agToComplete)).addAll(agContentSet);
                }
            }
            for (String agRefName : agFormatTypeReferenceMap.keySet()) {
                agContentSet = (Set)agContentMap.get(agRefName);
                List ftToComplete = (List)agFormatTypeReferenceMap.get(agRefName);
                for (FormatType type : ftToComplete) {
                    type.addProperties(agContentSet);
                }
            }
        }

        private PropertyTypeEnum getPropertyTypeEnumForXSType(String xsType) {
            if (this.xsSchemaTypeMap.containsKey(xsType)) {
                return this.xsSchemaTypeMap.get(xsType);
            }
            return PropertyTypeEnum.TEXT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUnexpectedElement(XMLStreamReader reader, String[] expectedElementNameList) throws XMLStreamException {
            if (FormatServiceLoader.this.resourceParsingLogger.isOn(LogLevel.WARN)) {
                StringBuilder sb = new StringBuilder();
                sb.append("{ ");
                for (String expectedElement : expectedElementNameList) {
                    sb.append(expectedElement);
                    sb.append(FormatServiceLoader.SPACE);
                }
                sb.append("}");
                try (Formatter formatter = new Formatter();){
                    formatter.format("Unexpected element '%s' at line %d. Expecting, one of %s.", reader.getLocalName(), reader.getLocation().getLineNumber(), sb.toString());
                    FormatServiceLoader.this.resourceParsingLogger.log(LogLevel.WARN, formatter.toString());
                }
            }
            StaxUtil.skipElement(reader);
        }

        private FormatPropertyDefinition parsePropertyDefinition(XMLStreamReader reader) throws XMLStreamException {
            reader.require(1, ATTRIBUTE_QNAME.getNamespaceURI(), ATTRIBUTE_QNAME.getLocalPart());
            String name = reader.getAttributeValue(null, FormatServiceLoader.NAME_ATTR);
            String type = reader.getAttributeValue(null, FormatServiceLoader.TYPE_ATTR);
            if (null == name) {
                FormatServiceLoader.this.resourceParsingLogger.log(LogLevel.WARN, "Skipping property definition with no name.");
                return null;
            }
            PropertyTypeEnum valueType = this.getPropertyTypeEnumForXSType(type);
            FormatPropertyDefinition propDef = (FormatPropertyDefinition)FormatServiceLoader.this.formatPropertyDefinitions.get(name);
            if (null == propDef) {
                propDef = new FormatPropertyDefinition(name, valueType);
                FormatServiceLoader.this.formatPropertyDefinitions.put(name, propDef);
            } else if (null != type && !propDef.getPropertyType().equals((Object)valueType) && FormatServiceLoader.this.resourceParsingLogger.isOn(LogLevel.WARN)) {
                StringBuilder sb = new StringBuilder();
                sb.append("A property definition for ");
                sb.append(name);
                sb.append(" already exists but the property types do not match.");
                FormatServiceLoader.this.resourceParsingLogger.log(LogLevel.WARN, sb.toString());
            }
            return propDef;
        }
    }
}

