/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.FormatPropertyDefinition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class FormatType {
    private final String name;
    private Set<FormatPropertyDefinition> supportedProperties;

    public String getName() {
        return this.name;
    }

    protected FormatType(String typeName) {
        this.name = typeName;
        this.supportedProperties = new HashSet<FormatPropertyDefinition>();
    }

    protected void addProperty(FormatPropertyDefinition property) {
        this.supportedProperties.add(property);
    }

    protected void addProperties(Collection<FormatPropertyDefinition> properties) {
        this.supportedProperties.addAll(properties);
    }

    public boolean isSupportedProperty(String propertyName) {
        if (null == propertyName) {
            return false;
        }
        for (FormatPropertyDefinition supportedProperty : this.supportedProperties) {
            if (!supportedProperty.getPropertyName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FormatType: name=");
        sb.append(this.name);
        sb.append(" supportedProperties=");
        TreeSet<FormatPropertyDefinition> sortedProps = new TreeSet<FormatPropertyDefinition>(this.supportedProperties);
        block5: for (FormatPropertyDefinition prop : sortedProps) {
            sb.append(prop.getPropertyName());
            switch (prop.getPropertyType()) {
                case BOOLEAN: {
                    sb.append("(B) ");
                    continue block5;
                }
                case TEXT: {
                    sb.append("(T) ");
                    continue block5;
                }
                case NUMBER: {
                    sb.append("(N) ");
                    continue block5;
                }
            }
            sb.append("(U) ");
        }
        return sb.toString();
    }
}

