/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.PropertyTypeEnum;

public final class NumberFormatPropertyValue
extends FormatPropertyValue {
    private static final Double EMPTY_VALUE = new Double(0.0);

    public NumberFormatPropertyValue(String propertyName) {
        this(propertyName, EMPTY_VALUE);
    }

    public NumberFormatPropertyValue(String propertyName, double val) {
        super(propertyName);
        this.propertyValue = new Double(val);
    }

    @Override
    public PropertyTypeEnum getPropertyType() {
        return PropertyTypeEnum.NUMBER;
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == EMPTY_VALUE.doubleValue();
    }

    public double getValue() {
        return (Double)this.propertyValue;
    }

    @Override
    public String getStringValue() {
        Double dblValue = (Double)this.propertyValue;
        int intValue = dblValue.intValue();
        if ((double)intValue == dblValue) {
            return Integer.toString(intValue);
        }
        return dblValue.toString();
    }
}

