/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.data.providers.relational.LOCALCastFormatter;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceImpl;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.format.string.QFWResultCellFormatParser;
import com.cognos.xqe.format.string.V5FormatInfo;
import com.cognos.xqe.format.string.V5FormatParser;
import com.cognos.xqe.format.value.IValueFormatter;
import com.cognos.xqe.format.value.ValueFormatterManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.SingletonHelper;
import java.lang.reflect.Constructor;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XQEFormatService
extends FormatServiceImpl {
    private static final String MSAS_FORMAT_PARSER = "com.cognos.xqe.data.olap.common.MSASCommonFormatParser";
    private static final String FORMATTING_ON_CAST_OPERATOR;
    private static final String XQE_PROPERTY_DEFINITION_FILE = "xqe.propertyDefinition.xml";
    private static final String V5_FORMAT_FILE = "V5_format.xsd";
    private volatile boolean instanceInitialized = false;
    private volatile boolean registeredStaticFormats = false;
    private volatile boolean registeredLocalCastingFormats = false;
    private Map<FormatParserType, IFormatParser> formatParsers = new ConcurrentHashMap<FormatParserType, IFormatParser>();

    public static FormatService getInstance() {
        return FormatService.getInstance();
    }

    @Override
    protected void initialize() {
        if (this.instanceInitialized) {
            return;
        }
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "Initializing the XQE Format Service.");
        boolean problemsLoadingService = this.initializeFormatsUsingLoader(V5_FORMAT_FILE, XQE_PROPERTY_DEFINITION_FILE);
        if (!this.registeredStaticFormats) {
            this.initStaticFormatStrings();
            this.registeredStaticFormats = true;
        }
        if (!this.registeredLocalCastingFormats && FORMATTING_ON_CAST_OPERATOR.equalsIgnoreCase("true")) {
            LOCALCastFormatter.getInstance();
            this.registeredLocalCastingFormats = true;
        }
        boolean bl = this.instanceInitialized = !problemsLoadingService;
        if (this.instanceInitialized) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "XQE Format Service initialized.");
        } else {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "XQE Format Service not initialized.");
        }
    }

    @Override
    protected void release() {
        if (FSLOGGER_FORMAT_SERVICE.isOn()) {
            FSLOGGER_FORMAT_SERVICE.log("Released XQE Format Service.");
        }
    }

    @Override
    public String formatValue(IValue value, FormatId id, Locale locale) {
        IValueFormatter valueFormatter;
        FormatPropertySet formatProperties;
        if (!id.isInvalid() && (formatProperties = this.getFormatPropertySet(id)) != null && (valueFormatter = ValueFormatterManager.getInstance().getValueFormatter(formatProperties.getFormatTypeName())) != null && valueFormatter.canApply(value)) {
            return valueFormatter.applyFormat(value, formatProperties, locale);
        }
        return value.toString();
    }

    @Override
    public FormatId registerV5Format(String formatString, Locale locale) {
        V5FormatInfo formatInfo = new V5FormatInfo(formatString);
        FormatId id = this.registerFormatInfoImpl(formatInfo, FormatParserType.V5, locale);
        if (this.loggerIsOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.V5.toString(), formatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerMSASFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.MSAS, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.MSAS.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerXmlaMsasFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.XMLA_MSAS, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.XMLA_MSAS.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerQFWResultFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.QFWRESULT, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.QFWRESULT.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerSBWODPCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.SBWODP, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.SBWODP.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerSNWODPCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.SNWODP, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.SNWODP.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerEssbaseCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.ESSBASE, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.ESSBASE.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerTM1CellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.TM1, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.TM1.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerTMRCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.TMR, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.TMR.toString(), valueFormatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerNeoCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.NEO, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.NEO.toString(), valueFormatInfo, id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    protected IFormatParser getFormatParser(FormatParserType parserType) {
        IFormatParser parser = this.formatParsers.get((Object)parserType);
        if (null == parser) {
            switch (parserType) {
                case V5: {
                    parser = new V5FormatParser(this);
                    break;
                }
                case QFWRESULT: {
                    parser = new QFWResultCellFormatParser(this);
                    break;
                }
                case MSAS: {
                    try {
                        Class<?> providerClass = Class.forName(MSAS_FORMAT_PARSER);
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate MSASCommonFormatParser object: ", (Throwable)ex);
                        throw XQERuntimeException.wrap(ex);
                    }
                }
                case XMLA_MSAS: {
                    try {
                        Class<?> providerClass = Class.forName(MSAS_FORMAT_PARSER);
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate XMLA MSASFormatParser object: ", (Throwable)ex);
                        throw XQERuntimeException.wrap(ex);
                    }
                }
                case TM1: {
                    try {
                        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                        Boolean useEnhancedFormatParser = configuration.getBooleanProperty("formatting.useEnhancedTM1FormatParser[@value]", Boolean.TRUE);
                        Class<?> providerClass = useEnhancedFormatParser != false ? Class.forName("com.cognos.xqe.data.providers.olap.tm1.data.EnhancedTM1CellFormatParser") : Class.forName("com.cognos.xqe.data.providers.olap.tm1.data.TM1CellFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate TM1CellFormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case TMR: {
                    try {
                        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                        Boolean useEnhancedFormatParser = configuration.getBooleanProperty("formatting.useEnhancedTM1FormatParser[@value]", Boolean.TRUE);
                        Class<?> providerClass = useEnhancedFormatParser != false ? Class.forName("com.cognos.xqe.data.providers.olap.tm1rest.data.EnhancedTMRCellFormatParser") : Class.forName("com.cognos.xqe.data.providers.olap.tm1rest.data.TMRCellFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate TMRCellFormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case SBWODP: {
                    try {
                        Class<?> providerClass = Class.forName("com.cognos.xqe.data.providers.olap.sbwodp.SBWODPCellFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate SBWODPCellFormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case SNWODP: {
                    try {
                        Class<?> providerClass = Class.forName("com.cognos.xqe.data.providers.olap.snwodp.SNWODPCellFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate SNWODPCellFormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case ESSBASE: {
                    try {
                        Class<?> providerClass = Class.forName("com.cognos.xqe.data.providers.olap.essbase.EssbaseCellFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate EssbaseCellFormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case NEO: {
                    try {
                        Class<?> providerClass = Class.forName("com.ibm.cognos.xqe.athena.formatting.FormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate Neo FormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                default: {
                    FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Unknown FormatParserType " + (Object)((Object)parserType) + ".");
                }
            }
            if (null != parser) {
                this.formatParsers.put(parserType, parser);
            }
        }
        return parser;
    }

    private void initStaticFormatStrings() {
        this.registerStaticFormatString("", FormatId.EMPTY_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><numberFormat/></formatGroup>", FormatId.NUMBER_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><percentFormat/></formatGroup>", FormatId.PERCENT_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><currencyFormat/></formatGroup>", FormatId.CURRENCY_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><dateFormat/></formatGroup>", FormatId.DATE_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><dateTimeFormat/></formatGroup>", FormatId.DATETIME_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><timeFormat/></formatGroup>", FormatId.TIME_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><intervalFormat/></formatGroup>", FormatId.INTERVAL_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><stringFormat/></formatGroup>", FormatId.STRING_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><format/></formatGroup>", FormatId.CUSTOM_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><timeFormat showTimeZone=\"true\"/></formatGroup>", FormatId.TIMETZ_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><dateTimeFormat showTimeZone=\"true\"/></formatGroup>", FormatId.DATETIMETZ_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><numberFormat decimalSize=\"0\" /></formatGroup>", FormatId.INTEGER_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><numberFormat xml:lang=\"en-us\" decimalSize=\"0\" useGrouping=\"true\" /></formatGroup>", FormatId.DEFAULT_LONG_FORMAT_FID);
        this.registerStaticFormatString("&lt;formatGroup&gt;&lt;numberFormat xml:lang=&quot;en-us&quot;/&gt;&lt;/formatGroup&gt;", FormatId.DEFAULT_NUMBER_FORMAT_FID);
    }

    @Override
    public FormatId registerNeoICUFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    static {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        FORMATTING_ON_CAST_OPERATOR = config.getStringProperty("queryPlanning.localFormattingOnCastOperator[@enabled]", "false");
        XQEFormatService.setSingletonHelper(new SingletonHelper<FormatService>(){

            @Override
            protected FormatService newInstance() {
                return CommonClassesFactory.createFormatService();
            }

            @Override
            protected void releaseImpl(FormatService theInstance) {
                theInstance.release();
            }

            @Override
            protected void initializeImpl(FormatService theInstance) {
                theInstance.initialize();
            }
        });
    }
}

