/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.Action;
import com.cognos.xqe.format.formatter.ICondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.trace.LogLevel;

public abstract class ActionTransformation
extends Transformation {
    ICondition cond;
    Action act;

    public ActionTransformation(FormatService service, ICondition condition, Action action, String description, boolean alwaysApply, Integer passNumber) {
        super(service, description, alwaysApply, passNumber);
        this.cond = condition;
        this.act = action;
    }

    @Override
    public boolean apply() throws ResultFormattingException {
        if (this.cond.isMet()) {
            String resolvedProperty = this.act.applyAction();
            ResultFormatter formatter = this.getService().getCurrentFormatter();
            if (null != resolvedProperty && FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
                FormatPropertyValue value = formatter.getResultSet().getPropertyValue(resolvedProperty);
                String strValue = null == value ? "not present" : value.getStringValue();
                FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Resolved " + resolvedProperty + "=" + strValue + ":" + this.getDescription());
            }
            return formatter.isCurrentPropertyResolved();
        }
        return false;
    }

    public ICondition getCondition() {
        return this.cond;
    }

    public Action getAction() {
        return this.act;
    }
}

