/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.trace.LogLevel;

public class AssignmentTransformation
extends Transformation {
    private static final String DEFAULT_VAL = "@default";
    private String targetProperty;
    private String value;

    public AssignmentTransformation(FormatService service, String assignedValue, String targetPropertyName, String description, boolean alwaysApply, Integer passNumber) {
        super(service, description, alwaysApply, passNumber);
        this.targetProperty = targetPropertyName;
        this.value = assignedValue;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public boolean apply() throws ResultFormattingException {
        String propertyValue;
        FormatPropertyDefinition propertyDefinition;
        ResultFormatter resultFormatter = this.getService().getCurrentFormatter();
        if (null != this.targetProperty) {
            propertyDefinition = this.getService().getFormatPropertyDefinition(this.targetProperty);
            if (null == propertyDefinition) {
                throw new ResultFormattingException("Target property " + this.targetProperty + " is not defined in the V5 format schema.");
            }
        } else {
            propertyDefinition = resultFormatter.getCurrentPropertyDefinition();
        }
        FormatPropertySet resultSet = resultFormatter.getResultSet();
        if (resultFormatter.resolvedProperties.contains(propertyDefinition.getPropertyName())) {
            return false;
        }
        if (this.value.equals(DEFAULT_VAL)) {
            FormatPropertyValue defaultValue = propertyDefinition.getDefaultValue();
            if (null == defaultValue) {
                throw new ResultFormattingException("The current property " + propertyDefinition.getPropertyName() + " does not have a default value defined.");
            }
            propertyValue = defaultValue.getStringValue();
        } else if (this.value.startsWith("@")) {
            String parameterValue = resultFormatter.getParameterValue(this.value.substring(1));
            if (null == parameterValue) {
                throw new ResultFormattingException("The external parameter " + this.value + " was not passed in FormatService.formatResult().");
            }
            propertyValue = parameterValue;
        } else {
            propertyValue = this.value;
        }
        FormatPropertyValue resultValue = propertyDefinition.createPropertyValue(propertyValue);
        resultSet.addPropertyValue(resultValue);
        if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Resolved " + propertyDefinition.getPropertyName() + "=" + propertyValue + ":" + this.getDescription());
        }
        resultFormatter.markPropertyResolved(propertyDefinition.getPropertyName());
        return resultFormatter.isCurrentPropertyResolved();
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public String getValue() {
        return this.value;
    }
}

