/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.IBinaryCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.trace.LogLevel;
import java.util.Formatter;

public class BinaryPatternCondition
implements IBinaryCondition {
    private BinaryOperandState firstState;
    private BinaryOperandState secondState;

    public BinaryPatternCondition(BinaryOperandState firstOperandState, BinaryOperandState secondOperandState) {
        this.firstState = firstOperandState;
        this.secondState = secondOperandState;
    }

    @Override
    public boolean isMet() {
        try {
            boolean secondConditionMet;
            boolean firstConditionMet;
            ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
            if (!formatter.isBinaryExpression()) {
                return false;
            }
            FormatPropertyDefinition propertyDefinition = formatter.getCurrentPropertyDefinition();
            FormatPropertyValue firstValue = formatter.getOperandProperties(0).getPropertyValue(propertyDefinition.getPropertyName());
            FormatPropertyValue secondValue = formatter.getOperandProperties(1).getPropertyValue(propertyDefinition.getPropertyName());
            switch (this.firstState) {
                case DONT_CARE: {
                    firstConditionMet = true;
                    break;
                }
                case NOT_PRESENT: {
                    firstConditionMet = null == firstValue;
                    break;
                }
                case EMPTY: {
                    firstConditionMet = null != firstValue && firstValue.isEmpty();
                    break;
                }
                case PRESENT: {
                    firstConditionMet = null != firstValue;
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (this.secondState) {
                case DONT_CARE: {
                    secondConditionMet = true;
                    break;
                }
                case NOT_PRESENT: {
                    secondConditionMet = null == secondValue;
                    break;
                }
                case EMPTY: {
                    secondConditionMet = null != secondValue && secondValue.isEmpty();
                    break;
                }
                case PRESENT: {
                    secondConditionMet = null != secondValue;
                    break;
                }
                default: {
                    return false;
                }
            }
            return firstConditionMet && secondConditionMet;
        }
        catch (ResultFormattingException e) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.ERROR, "A ResultParsingException occurred while evaluating a BinaryPatternCondition: ", (Throwable)e);
            return false;
        }
    }

    public BinaryOperandState getFirstState() {
        return this.firstState;
    }

    public BinaryOperandState getSecondState() {
        return this.secondState;
    }

    public static enum BinaryOperandState {
        NOT_PRESENT,
        EMPTY,
        PRESENT,
        DONT_CARE;

        private static final String LOGMSG_INVALID_OPERAND_STATE = "Invalid value '%s' for the binary operand state attribute.";

        static BinaryOperandState parseOperandState(String operandStateStr) throws FormatResourceParsingException {
            BinaryOperandState state;
            if (null == operandStateStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if ("notPresent".equals(operandStateStr)) {
                state = NOT_PRESENT;
            } else if ("empty".equals(operandStateStr)) {
                state = EMPTY;
            } else if ("present".equals(operandStateStr)) {
                state = PRESENT;
            } else if ("dontCare".equals(operandStateStr)) {
                state = DONT_CARE;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, operandStateStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return state;
        }
    }
}

