/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import java.util.Formatter;

public class Criterion {
    private String propName;
    private CriterionComparisonOperator op;
    private String val;

    public Criterion(String propertyName, CriterionComparisonOperator operator, String value) {
        this.propName = propertyName;
        this.op = operator;
        this.val = value;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public CriterionComparisonOperator getComparisonOperator() {
        return this.op;
    }

    public String getValue() {
        return this.val;
    }

    public boolean isMet(FormatPropertySet operandSet) {
        FormatPropertyValue value = operandSet.getPropertyValue(this.propName);
        if (null == value) {
            return this.op.equals((Object)CriterionComparisonOperator.NEQ);
        }
        boolean propertyEqualsValue = value.getStringValue().equals(this.val);
        return this.op.equals((Object)CriterionComparisonOperator.EQ) && propertyEqualsValue || this.op.equals((Object)CriterionComparisonOperator.NEQ) && !propertyEqualsValue;
    }

    public static enum CriterionComparisonOperator {
        EQ,
        NEQ;

        private static final String LOGMSG_INVALID_COMPARATOR = "Invalid value '%s' for the attribute 'comparison'.";

        static CriterionComparisonOperator parseCriterionComparatorEnum(String criterionComparatorStr) throws FormatResourceParsingException {
            CriterionComparisonOperator comparator;
            if (null == criterionComparatorStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if ("eq".equals(criterionComparatorStr)) {
                comparator = EQ;
            } else if ("neq".equals(criterionComparatorStr)) {
                comparator = NEQ;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, criterionComparatorStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return comparator;
        }
    }
}

