/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatResourceParsingException;
import java.util.Formatter;

enum ExpressionType {
    UNARY,
    BINARY,
    SET;

    private static final String LOGMSG_INVALID_EXPRESSION_TYPE = "Invalid value '%s' for the attribute 'expressionType'.";

    static ExpressionType parseExpressionType(String expressionTypeStr) throws FormatResourceParsingException {
        ExpressionType expressionType;
        if (null == expressionTypeStr) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_INVALID_EXPRESSION_TYPE, "null");
            String sErr = formatter.toString();
            formatter.close();
            throw new FormatResourceParsingException(sErr);
        }
        if ("unary".equals(expressionTypeStr)) {
            expressionType = UNARY;
        } else if ("binary".equalsIgnoreCase(expressionTypeStr)) {
            expressionType = BINARY;
        } else if ("set".equals(expressionTypeStr)) {
            expressionType = SET;
        } else {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_INVALID_EXPRESSION_TYPE, expressionTypeStr);
            String sErr = formatter.toString();
            formatter.close();
            throw new FormatResourceParsingException(sErr);
        }
        return expressionType;
    }
}

