/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatType;
import com.cognos.xqe.format.formatter.ExpressionType;
import com.cognos.xqe.format.formatter.Library;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.format.formatter.TransformationPass;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class ResultFormatter {
    private static final String LOGMSG_INVALID_OPERAND_INDEX = "The operand index %d is out of bounds for expression %s.";
    private static final String DOT = ".";
    private static final String DIVIDER = "|";
    private static final String IS_NOT_VALID_FOR_A = " is not valid for a ";
    private final FormatService mService;
    private FormatPropertyDefinition currentProperty;
    private List<FormatPropertySet> propertySets;
    protected FormatPropertySet resultSet;
    protected final List<String> propertiesToResolve = new ArrayList<String>();
    protected final List<String> resolvedProperties = new ArrayList<String>();
    private int currentPropertyIndex;
    private String expression;
    private ExpressionType expressionType;
    private Collection<Library> formatLibraries;
    private Properties externalParameters;

    public ResultFormatter(FormatService service, String expressionName, List<FormatPropertySet> operandPropertySets, Properties parameters) {
        this.mService = service;
        this.resultSet = new FormatPropertySet(this.mService);
        this.propertySets = operandPropertySets;
        this.expression = expressionName;
        this.externalParameters = parameters;
    }

    public FormatPropertyDefinition getCurrentPropertyDefinition() throws IllegalStateException {
        if (null == this.currentProperty) {
            throw new IllegalStateException("No format property currently in context.");
        }
        return this.currentProperty;
    }

    public String getExpressionName() {
        return this.expression;
    }

    public FormatPropertySet getResultSet() {
        return this.resultSet;
    }

    public boolean isCurrentPropertyResolved() {
        return this.resolvedProperties.contains(this.getCurrentPropertyDefinition().getPropertyName());
    }

    public FormatPropertySet resolve() throws ResultFormattingException {
        this.validateInitialState();
        if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Executing " + this.toString() + DOT);
        }
        TreeSet<String> distinctPropertiesSet = new TreeSet<String>();
        for (FormatPropertySet operandSet : this.propertySets) {
            distinctPropertiesSet.addAll(operandSet.getPropertyNames());
        }
        this.propertiesToResolve.addAll(distinctPropertiesSet);
        if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Properties to resolve: " + this.propertyListToString(this.propertiesToResolve));
        }
        for (Library currentLibrary : this.formatLibraries) {
            if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
                FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Current library: " + currentLibrary.getName());
            }
            this.expressionType = currentLibrary.getExpressionType(this.expression);
            for (TransformationPass currentPass : currentLibrary.getTransformationPasses()) {
                Map<String, List<Transformation>> expressionProperties;
                if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
                    FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Current pass: " + currentPass.passNumber.toString());
                }
                if (currentPass.expressionTypeTransformations.containsKey(this.expression)) {
                    currentPass.expressionTypeTransformations.get(this.expression).apply();
                } else if (null != currentPass.defaultTypeTransformation) {
                    currentPass.defaultTypeTransformation.apply();
                }
                if (currentPass.expressionTransformations.containsKey(this.expression)) {
                    expressionProperties = currentPass.expressionTransformations.get(this.expression);
                    this.currentPropertyIndex = 0;
                    while (this.readyToProcessNextProperty()) {
                        String currentPropertyName = this.getCurrentPropertyDefinition().getPropertyName();
                        List<Transformation> propertyTransformations = expressionProperties.get(currentPropertyName);
                        this.applyTransformationsToCurrentProperty(propertyTransformations);
                    }
                }
                if (currentPass.checkedExpressionTransformations.containsKey(this.expression)) {
                    expressionProperties = currentPass.checkedExpressionTransformations.get(this.expression);
                    for (String currentPropertyName : expressionProperties.keySet()) {
                        if (this.resolvedProperties.contains(currentPropertyName)) continue;
                        this.setCurrentPropertyDefinition(this.mService.getFormatPropertyDefinition(currentPropertyName));
                        List<Transformation> propertyTransformations = expressionProperties.get(currentPropertyName);
                        this.applyTransformationsToCurrentProperty(propertyTransformations);
                    }
                }
                if (this.propertiesToResolve.isEmpty()) continue;
                if (currentPass.propertyTransformations.size() > 0) {
                    this.currentPropertyIndex = 0;
                    while (this.readyToProcessNextProperty()) {
                        String currentPropertyName = this.getCurrentPropertyDefinition().getPropertyName();
                        List<Transformation> propertyTransformations = currentPass.propertyTransformations.get(currentPropertyName);
                        this.applyTransformationsToCurrentProperty(propertyTransformations);
                    }
                    if (this.propertiesToResolve.isEmpty()) continue;
                }
                if (currentPass.defaultTransformations.isEmpty()) continue;
                this.currentPropertyIndex = 0;
                while (this.readyToProcessNextProperty()) {
                    this.applyTransformationsToCurrentProperty(currentPass.defaultTransformations);
                }
            }
        }
        return this.resultSet;
    }

    public void setCurrentPropertyDefinition(FormatPropertyDefinition propertyDefintion) {
        this.currentProperty = propertyDefintion;
    }

    public void setLibraries(Collection<Library> libraries) {
        this.formatLibraries = libraries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Result Formatter: expression=");
        sb.append(this.expression);
        sb.append(" operands ");
        Iterator<FormatPropertySet> psIter = this.propertySets.iterator();
        while (psIter.hasNext()) {
            sb.append(psIter.next().toString());
            if (!psIter.hasNext()) continue;
            sb.append(DIVIDER);
        }
        return sb.toString();
    }

    List<FormatPropertySet> getAllOperandProperties() {
        return this.propertySets;
    }

    FormatPropertySet getOperandProperties(int operandIndex) throws ResultFormattingException {
        if (operandIndex >= this.propertySets.size() || operandIndex < 0) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_INVALID_OPERAND_INDEX, operandIndex, this.expression);
            String sErr = formatter.toString();
            formatter.close();
            throw new ResultFormattingException(sErr);
        }
        return this.propertySets.get(operandIndex);
    }

    String getParameterValue(String parameterName) {
        return this.externalParameters.getProperty(parameterName);
    }

    boolean isBinaryExpression() {
        if (null != this.expressionType) {
            return this.expressionType.equals((Object)ExpressionType.BINARY);
        }
        return this.propertySets.size() == 2;
    }

    boolean isUnaryExpression() {
        if (null != this.expressionType) {
            return this.expressionType.equals((Object)ExpressionType.UNARY);
        }
        return this.propertySets.size() == 1;
    }

    void markPropertyResolved(String propertyName) {
        int propertyNameIndex;
        XQELogger logger = FormatService.FSLOGGER_FORMATTER;
        if (!this.resolvedProperties.contains(propertyName)) {
            this.resolvedProperties.add(propertyName);
        }
        if ((propertyNameIndex = this.propertiesToResolve.indexOf(propertyName)) != -1) {
            if (propertyNameIndex < this.currentPropertyIndex) {
                --this.currentPropertyIndex;
            }
            this.propertiesToResolve.remove(propertyName);
        }
        if (propertyName.equals("formatType")) {
            FormatType formatType = this.mService.getFormatType(this.resultSet.getFormatTypeName());
            if (null == formatType) {
                logger.log(LogLevel.WARN, "Unknown format type " + this.resultSet.getFormatTypeName() + ". Cannot filter invalid properties from result set.");
                return;
            }
            Iterator<String> propItr = this.propertiesToResolve.iterator();
            while (propItr.hasNext()) {
                String propertyToResolve = propItr.next();
                if (formatType.isSupportedProperty(propertyToResolve)) continue;
                if (logger.isOn(LogLevel.INFO)) {
                    logger.log(LogLevel.INFO, propertyToResolve + IS_NOT_VALID_FOR_A + formatType.getName() + ". Removing from properties to resolve.");
                }
                if (this.propertiesToResolve.indexOf(propertyToResolve) < this.currentPropertyIndex) {
                    --this.currentPropertyIndex;
                }
                propItr.remove();
            }
            for (String resultSetProperty : this.resultSet.getPropertyNames()) {
                if (formatType.isSupportedProperty(resultSetProperty)) continue;
                if (logger.isOn(LogLevel.INFO)) {
                    logger.log(LogLevel.INFO, resultSetProperty + IS_NOT_VALID_FOR_A + formatType.getName() + ". Removing from result.");
                }
                this.resultSet.removePropertyValue(resultSetProperty);
            }
        }
    }

    private void applyTransformationsToCurrentProperty(List<Transformation> transformationList) throws ResultFormattingException {
        if (null == transformationList || transformationList.isEmpty()) {
            ++this.currentPropertyIndex;
            return;
        }
        for (Transformation transformation : transformationList) {
            if (!transformation.apply()) continue;
            return;
        }
        ++this.currentPropertyIndex;
    }

    private String propertyListToString(List<String> propertyList) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<String> strIter = propertyList.iterator();
        while (strIter.hasNext()) {
            sb.append(strIter.next());
            if (!strIter.hasNext()) continue;
            sb.append(DIVIDER);
        }
        sb.append("}");
        return sb.toString();
    }

    private boolean readyToProcessNextProperty() throws ResultFormattingException {
        if (this.currentPropertyIndex >= this.propertiesToResolve.size()) {
            this.currentProperty = null;
            return false;
        }
        this.currentProperty = this.mService.getFormatPropertyDefinition(this.propertiesToResolve.get(this.currentPropertyIndex));
        if (null == this.currentProperty) {
            throw new ResultFormattingException("The property " + this.propertiesToResolve.get(this.currentPropertyIndex) + " is not defined in the V5_format spec.");
        }
        return true;
    }

    private void validateInitialState() throws ResultFormattingException {
        if (null == this.expression) {
            throw new ResultFormattingException("The expression name has not been set in the ResultFormatter.");
        }
        if (null == this.propertySets || this.propertySets.isEmpty()) {
            throw new ResultFormattingException("The list of operand property sets has not been set in the ResultFormatter.");
        }
        if (null == this.formatLibraries || this.formatLibraries.isEmpty()) {
            throw new ResultFormattingException("The list of format libraries has not been set in the ResultFormatter.");
        }
        if (!this.resultSet.getPropertyNames().isEmpty()) {
            throw new ResultFormattingException("The ResultFormatter instance cannot be reused to resolve an expression result.");
        }
    }
}

