/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.ISetCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;

public class SetComparisonCondition
implements ISetCondition {
    private SetComparatorEnum setComparator;

    public SetComparisonCondition(SetComparatorEnum comparator) {
        this.setComparator = comparator;
    }

    @Override
    public boolean isMet() {
        ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
        FormatPropertyDefinition propertyDefinition = formatter.getCurrentPropertyDefinition();
        List<FormatPropertySet> operandPropertySets = formatter.getAllOperandProperties();
        if (operandPropertySets.isEmpty()) {
            return false;
        }
        Iterator<FormatPropertySet> operandItr = operandPropertySets.iterator();
        FormatPropertyValue firstValue = operandItr.next().getPropertyValue(propertyDefinition.getPropertyName());
        if (null == firstValue) {
            return false;
        }
        boolean operandsAreEqual = true;
        while (operandItr.hasNext()) {
            FormatPropertyValue currentValue = operandItr.next().getPropertyValue(propertyDefinition.getPropertyName());
            if (null == currentValue) {
                return false;
            }
            if (firstValue.equals(currentValue)) continue;
            operandsAreEqual = false;
        }
        return this.setComparator.equals((Object)SetComparatorEnum.EQ) && operandsAreEqual || this.setComparator.equals((Object)SetComparatorEnum.NEQ) && !operandsAreEqual;
    }

    public SetComparatorEnum getComparator() {
        return this.setComparator;
    }

    public static enum SetComparatorEnum {
        EQ,
        NEQ;

        private static final String LOGMSG_INVALID_COMPARATOR = "Invalid value '%s' for the attribute 'comparison'.";

        static SetComparatorEnum parseSetComparatorEnum(String setComparatorStr) throws FormatResourceParsingException {
            SetComparatorEnum comparator;
            if (null == setComparatorStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if ("eq".equals(setComparatorStr)) {
                comparator = EQ;
            } else if ("neq".equals(setComparatorStr)) {
                comparator = NEQ;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, setComparatorStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return comparator;
        }
    }
}

