/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class TypeTransformation
extends Transformation {
    private static final String FORMAT_TYPE_PROPERTY = "formatType";
    private List<String> typeNames;

    public TypeTransformation(FormatService service, List<String> formatTypeNames, String description, boolean alwaysApply, Integer passNumber) {
        super(service, description, alwaysApply, passNumber);
        this.typeNames = formatTypeNames;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public boolean apply() throws ResultFormattingException {
        ResultFormatter resultFormatter = FormatService.getInstance().getCurrentFormatter();
        FormatPropertySet resultSet = resultFormatter.getResultSet();
        if (resultFormatter.resolvedProperties.contains(FORMAT_TYPE_PROPERTY)) {
            return false;
        }
        List<FormatPropertySet> operandList = resultFormatter.getAllOperandProperties();
        List<FormatPropertyValue> operandFormatTypes = FormatServiceUtils.extractPropertyFromOperandList(FORMAT_TYPE_PROPERTY, operandList);
        if (operandFormatTypes.isEmpty()) {
            return false;
        }
        ArrayList<String> operandTypeNames = new ArrayList<String>();
        for (FormatPropertyValue formatPropertyValue : operandFormatTypes) {
            operandTypeNames.add(formatPropertyValue.getStringValue());
        }
        int highestIndex = -1;
        for (String typeName : operandTypeNames) {
            highestIndex = Math.max(this.typeNames.indexOf(typeName), highestIndex);
        }
        if (highestIndex == -1) {
            throw new ResultFormattingException("The type transformation cannot determine the format type with the highest precedence.");
        }
        String string = this.typeNames.get(highestIndex);
        if (null == FormatService.getInstance().getFormatType(string)) {
            throw new ResultFormattingException("The string " + string + " is not a valid V5 format type.");
        }
        resultSet.addPropertyValue(FormatPropertyDefinition.createPropertyValue(this.getService(), FORMAT_TYPE_PROPERTY, string));
        if (FormatService.FSLOGGER_FORMATTER.isOn(LogLevel.INFO)) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.INFO, "Resolved formatType=" + string + ":" + this.getDescription());
        }
        resultFormatter.markPropertyResolved(FORMAT_TYPE_PROPERTY);
        return true;
    }

    public List<String> getTypeNames() {
        return this.typeNames;
    }
}

