/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.ICondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.trace.LogLevel;
import java.util.Formatter;

public class UnaryCondition
implements ICondition {
    private static final String NOT_PRESENT_STR = "notPresent";
    private static final String EMPTY_STR = "empty";
    private static final String PRESENT_STR = "present";
    private static final String DONT_CARE_STR = "dontCare";
    private UnaryOperandState unaryState;

    public UnaryCondition(UnaryOperandState state) {
        this.unaryState = state;
    }

    @Override
    public boolean isMet() {
        try {
            ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
            if (!formatter.isUnaryExpression()) {
                return false;
            }
            FormatPropertyDefinition propertyDefinition = formatter.getCurrentPropertyDefinition();
            FormatPropertyValue operandValue = formatter.getOperandProperties(0).getPropertyValue(propertyDefinition.getPropertyName());
            return this.returnEvaluatedPattern(operandValue);
        }
        catch (ResultFormattingException e) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.ERROR, "A ResultParsingException occurred while evaluating a UnaryCondition: ", (Throwable)e);
            return false;
        }
    }

    private boolean returnEvaluatedPattern(FormatPropertyValue operandValue) {
        switch (this.unaryState) {
            case DONT_CARE: {
                return true;
            }
            case NOT_PRESENT: {
                return null == operandValue;
            }
            case EMPTY: {
                return null != operandValue && operandValue.isEmpty();
            }
            case PRESENT: {
                return null != operandValue;
            }
        }
        return false;
    }

    public UnaryOperandState getUnaryState() {
        return this.unaryState;
    }

    public static enum UnaryOperandState {
        NOT_PRESENT,
        EMPTY,
        PRESENT,
        DONT_CARE;

        private static final String LOGMSG_INVALID_OPERAND_STATE = "Invalid value '%s' for the attribute operandState.";

        static UnaryOperandState parseUnaryOperandState(String operandStateStr) throws FormatResourceParsingException {
            UnaryOperandState state;
            if (null == operandStateStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if (operandStateStr.equals(UnaryCondition.NOT_PRESENT_STR)) {
                state = NOT_PRESENT;
            } else if (operandStateStr.equals(UnaryCondition.EMPTY_STR)) {
                state = EMPTY;
            } else if (operandStateStr.equals(UnaryCondition.PRESENT_STR)) {
                state = PRESENT;
            } else if (operandStateStr.equals(UnaryCondition.DONT_CARE_STR)) {
                state = DONT_CARE;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, operandStateStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return state;
        }
    }
}

