/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.value.IValueFormatter;
import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTimeValueFormatter
implements IValueFormatter {
    private static final String DATESTYLE_PROP = "dateStyle";
    private static final String TIMESTYLE_PROP = "timeStyle";
    private static final String FORMAT_TYPE = "formatType";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";

    DateTimeValueFormatter() {
    }

    private int getStyle(FormatPropertyValue style) {
        if (style == null) {
            return 2;
        }
        String val = style.getStringValue();
        if (SHORT.equalsIgnoreCase(val)) {
            return 3;
        }
        if (MEDIUM.equalsIgnoreCase(val)) {
            return 2;
        }
        if (LONG.equalsIgnoreCase(val)) {
            return 1;
        }
        if (FULL.equalsIgnoreCase(val)) {
            return 0;
        }
        return 2;
    }

    @Override
    public String applyFormat(IValue value, FormatPropertySet formatProperties, Locale locale) {
        FormatPropertyValue formatTypeValue = formatProperties.getPropertyValue(FORMAT_TYPE);
        String formatType = formatTypeValue.getStringValue();
        String formattedValue = null;
        Date date = this.getAsDate(value);
        if ("dateTimeFormat".equals(formatType)) {
            formattedValue = this.formatAsTimestamp(date, formatProperties, locale);
        } else if ("dateFormat".equals(formatType)) {
            formattedValue = this.formatAsDate(date, formatProperties, locale);
        } else if ("timeFormat".equals(formatType)) {
            formattedValue = this.formatAsTime(date, formatProperties, locale);
        }
        if (formattedValue == null) {
            return value.toString();
        }
        return formattedValue;
    }

    private Date getAsDate(IValue value) {
        IDataType dataType = value.getDataType();
        if (dataType.isTimestamp()) {
            return ((TimestampValue)value).getDate();
        }
        if (dataType.isDate()) {
            return ((DateValue)value).getDate();
        }
        if (dataType.isTime()) {
            return ((TimeValue)value).getDate();
        }
        return null;
    }

    private String formatAsTimestamp(Date date, FormatPropertySet formatProperties, Locale locale) {
        FormatPropertyValue dateStyleValue = formatProperties.getPropertyValue(DATESTYLE_PROP);
        FormatPropertyValue timeStyleValue = formatProperties.getPropertyValue(TIMESTYLE_PROP);
        if (dateStyleValue != null || timeStyleValue != null) {
            int dateStyle = this.getStyle(dateStyleValue);
            int timeStyle = this.getStyle(timeStyleValue);
            DateFormat dateFormat = DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (Locale)locale);
            return dateFormat.format(date);
        }
        return null;
    }

    private String formatAsDate(Date date, FormatPropertySet formatProperties, Locale locale) {
        FormatPropertyValue dateStyleValue = formatProperties.getPropertyValue(DATESTYLE_PROP);
        if (dateStyleValue != null) {
            DateFormat dateFormat = DateFormat.getDateInstance((int)this.getStyle(dateStyleValue), (Locale)locale);
            return dateFormat.format(date);
        }
        return null;
    }

    private String formatAsTime(Date date, FormatPropertySet formatProperties, Locale locale) {
        FormatPropertyValue timeStyleValue = formatProperties.getPropertyValue(TIMESTYLE_PROP);
        if (timeStyleValue != null) {
            DateFormat timeFormat = DateFormat.getTimeInstance((int)this.getStyle(timeStyleValue), (Locale)locale);
            return timeFormat.format(date);
        }
        return null;
    }

    @Override
    public boolean canApply(IValue value) {
        IDataType dataType = value.getDataType();
        return DataTypeComparator.areCompatibleDataTypes(dataType, TimestampType.TIMESTAMPTYPE) || DataTypeComparator.areCompatibleDataTypes(dataType, DateType.DATETYPE) || DataTypeComparator.areCompatibleDataTypes(dataType, TimeType.TIMETYPE);
    }
}

