/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.value.IValueFormatter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class ICUDateTimeValueFormatter
implements IValueFormatter {
    private static final String LONG = "long";
    private static final String NARROW = "narrow";
    private static final String NUMERIC = "numeric";
    private static final String SHORT = "short";
    private static final String TWO_DIGIT = "2-digit";
    private static final String ICU_SHORT_YEAR = "yy";
    private static final String ICU_TWO_DIGIT_MONTH = "MM";
    private static final String ICU_SHORT_MONTH = "MMM";
    private static final String ICU_NARROW_MONTH = "MMMMM";
    private static final String ICU_TWO_DIGIT_DAY = "dd";
    private static final String ICU_NARROW_WEEKDAY = "EEEEE";
    private static final String ICU_SHORT_WEEKDAY = "E";
    private static final String ICU_LONG_WEEKDAY = "EEEE";
    private static final String ICU_TWO_DIGIT_HOUR_MINUTE_SECOND = "hhmmss";
    private static final String ICU_TWO_DIGIT_HOUR24_MINUTE_SECOND = "HHmmss";

    @Override
    public String applyFormat(IValue genericValue, FormatPropertySet formatProperties, Locale locale) {
        Value value = (Value)genericValue;
        if (genericValue.isNull()) {
            FormatPropertyValue whenMissingProperty = formatProperties.getPropertyValue("whenMissing");
            if (whenMissingProperty == null) {
                return " ";
            }
            return whenMissingProperty.getStringValue();
        }
        IDataType dataType = value.getDataType();
        Set<String> propertyNames = formatProperties.getPropertyNames();
        SimpleDateFormat dateFormat = null;
        String showYears = null;
        String showMonths = null;
        String showDays = null;
        String showWeekDays = null;
        String showHours = null;
        String showMinutes = null;
        String showSeconds = null;
        boolean showAmPm = false;
        boolean processedProperty = false;
        for (String propertyName : propertyNames) {
            if (propertyName.equals("showYears")) {
                showYears = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showMonths")) {
                showMonths = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showDays")) {
                showDays = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showWeekday")) {
                showWeekDays = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showHours")) {
                showHours = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showMinutes")) {
                showMinutes = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (propertyName.equals("showSeconds")) {
                showSeconds = formatProperties.getPropertyValue(propertyName).getStringValue();
                processedProperty = true;
                continue;
            }
            if (!propertyName.equals("showAmPm")) continue;
            BooleanFormatPropertyValue showAmPmProperty = (BooleanFormatPropertyValue)formatProperties.getPropertyValue(propertyName);
            showAmPm = showAmPmProperty.getValue();
            processedProperty = true;
        }
        if (processedProperty) {
            StringBuilder pattern = new StringBuilder();
            if (formatProperties.getFormatTypeName().equals("dateFormat") || formatProperties.getFormatTypeName().equals("dateTimeFormat")) {
                if (showYears.equals(NUMERIC)) {
                    pattern.append("y");
                } else if (showYears.equals(TWO_DIGIT)) {
                    pattern.append(ICU_SHORT_YEAR);
                }
                if (showMonths.equals(NUMERIC)) {
                    pattern.append("M");
                } else if (showMonths.equals(TWO_DIGIT)) {
                    pattern.append(ICU_TWO_DIGIT_MONTH);
                } else if (showMonths.equals(NARROW)) {
                    pattern.append(ICU_NARROW_MONTH);
                } else if (showMonths.equals(SHORT)) {
                    pattern.append(ICU_SHORT_MONTH);
                } else if (showMonths.equals(LONG)) {
                    pattern.append("MMMM");
                }
                if (showWeekDays != null) {
                    if (showWeekDays.equals(NARROW)) {
                        pattern.append(ICU_NARROW_WEEKDAY);
                    } else if (showWeekDays.equals(SHORT)) {
                        pattern.append(ICU_SHORT_WEEKDAY);
                    } else if (showWeekDays.equals(LONG)) {
                        pattern.append(ICU_LONG_WEEKDAY);
                    }
                }
                if (showDays.equals(NUMERIC)) {
                    pattern.append("d");
                } else if (showDays.equals(TWO_DIGIT)) {
                    pattern.append(ICU_TWO_DIGIT_DAY);
                }
            }
            if (formatProperties.getFormatTypeName().equals("dateTimeFormat") || formatProperties.getFormatTypeName().equals("timeFormat")) {
                if (showAmPm) {
                    pattern.append(ICU_TWO_DIGIT_HOUR_MINUTE_SECOND);
                } else {
                    pattern.append(ICU_TWO_DIGIT_HOUR24_MINUTE_SECOND);
                }
            }
            dateFormat = DateFormat.getPatternInstance((String)pattern.toString(), (Locale)locale);
        } else if (formatProperties.getFormatTypeName().equals("dateFormat")) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (formatProperties.getFormatTypeName().equals("dateTimeFormat")) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (formatProperties.getFormatTypeName().equals("timeFormat")) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
        }
        if (dataType.isDate()) {
            return dateFormat.format(value.getDate());
        }
        if (dataType.isTime()) {
            return dateFormat.format((Date)value.getTime());
        }
        if (dataType.isTimestamp()) {
            return dateFormat.format((Date)value.getTimestamp());
        }
        throw new IllegalArgumentException("Invalid datatype for ICU DateTime value formatter, data type=" + dataType.toString());
    }

    @Override
    public boolean canApply(IValue value) {
        return (value.getDataType().isDate() || value.getDataType().isDatetime()) && value instanceof Value;
    }
}

