/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.value.IValueFormatter;
import java.util.Locale;

public class NumberValueFormatter
implements IValueFormatter {
    NumberValueFormatter() {
    }

    @Override
    public String applyFormat(IValue value, FormatPropertySet formatProperties, Locale locale) {
        IDataType dataType = value.getDataType();
        if (dataType == DoubleType.DOUBLETYPE) {
            DoubleValue doubleValue = (DoubleValue)value;
            try {
                int intValue = doubleValue.getInteger();
                IntegerValue integerValue = DataValueFactory.createIntegerValue(intValue);
                if (doubleValue.compareTo(integerValue) == 0) {
                    return integerValue.toString();
                }
            }
            catch (ValueConversionException valueConversionException) {
                // empty catch block
            }
        }
        return value.toString();
    }

    @Override
    public boolean canApply(IValue value) {
        IDataType dataType = value.getDataType();
        return DataTypeComparator.areCompatibleDataTypes(dataType, DoubleType.DOUBLETYPE) || DataTypeComparator.areCompatibleDataTypes(dataType, IntegerType.INTEGERTYPE) || DataTypeComparator.areCompatibleDataTypes(dataType, DecimalType.DEFAULT_DECIMALTYPE);
    }
}

